/*
 * Decompiled with CFR 0.152.
 */
package com.alekiponi.alekiships.network;

import com.alekiponi.alekiships.common.entity.vehiclehelper.CleatEntity;
import com.alekiponi.alekiships.util.ClientHelper;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;

public class ClientBoundCleatLinkPacket {
    private final int cleatId;
    private final int designationId;

    public ClientBoundCleatLinkPacket(CleatEntity cleat, @Nullable Entity designation) {
        this.cleatId = cleat.m_19879_();
        this.designationId = designation != null ? designation.m_19879_() : 0;
    }

    public ClientBoundCleatLinkPacket(FriendlyByteBuf byteBuf) {
        this.cleatId = byteBuf.readInt();
        this.designationId = byteBuf.readInt();
    }

    public void encoder(FriendlyByteBuf byteBuf) {
        byteBuf.writeInt(this.cleatId);
        byteBuf.writeInt(this.designationId);
    }

    public void handle() {
        Level level = ClientHelper.getLevel();
        if (level == null) {
            return;
        }
        Entity entity = level.m_6815_(this.cleatId);
        if (entity instanceof CleatEntity) {
            CleatEntity cleat = (CleatEntity)entity;
            cleat.setDelayedLeashHolderId(this.designationId);
        }
    }
}

