/*
 * Decompiled with CFR 0.152.
 */
package com.alekiponi.alekiships.network;

import com.alekiponi.alekiships.common.entity.vehiclehelper.compartment.CompartmentCloneable;
import java.util.function.Supplier;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.NetworkEvent;

public class ServerBoundPickCompartmentPacket {
    private final int compartmentID;
    private final ItemStack itemStack;
    private final int slotIndex;

    public ServerBoundPickCompartmentPacket(int compartmentID, ItemStack itemStack, int slotIndex) {
        this.compartmentID = compartmentID;
        this.itemStack = itemStack.m_41777_();
        this.slotIndex = slotIndex;
    }

    protected ServerBoundPickCompartmentPacket(FriendlyByteBuf byteBuf) {
        this.compartmentID = byteBuf.readInt();
        this.itemStack = byteBuf.m_130267_();
        this.slotIndex = byteBuf.readInt();
    }

    public void encoder(FriendlyByteBuf byteBuf) {
        byteBuf.writeInt(this.compartmentID);
        byteBuf.writeItemStack(this.itemStack, false);
        byteBuf.writeInt(this.slotIndex);
    }

    public void handle(Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> {
            boolean nonEmptyStack;
            Entity entity;
            ServerPlayer player = ((NetworkEvent.Context)context.get()).getSender();
            if (player == null) {
                return;
            }
            if (!player.f_8941_.m_9295_()) {
                return;
            }
            if (!this.itemStack.m_246617_(player.m_9236_().m_246046_())) {
                return;
            }
            if (!this.itemStack.m_41619_() && (entity = player.m_9236_().m_6815_(this.compartmentID)) instanceof CompartmentCloneable) {
                CompartmentCloneable compartment = (CompartmentCloneable)entity;
                this.itemStack.m_41700_("BlockEntityTag", (Tag)compartment.saveForItemStack());
            }
            boolean validSlot = this.slotIndex >= 1 && this.slotIndex <= 45;
            boolean bl = nonEmptyStack = this.itemStack.m_41619_() || this.itemStack.m_41773_() >= 0 && this.itemStack.m_41613_() <= 64 && !this.itemStack.m_41619_();
            if (validSlot && nonEmptyStack) {
                player.f_36095_.m_38853_(this.slotIndex).m_269060_(this.itemStack);
                player.f_36095_.m_38946_();
            } else if (this.slotIndex < 0 && nonEmptyStack) {
                player.m_36176_(this.itemStack, true);
            }
        });
    }
}

