/*
 * Decompiled with CFR 0.152.
 */
package com.chyzman.chowl.block;

import com.chyzman.chowl.block.BreakProgressMaskingBlock;
import com.chyzman.chowl.block.DrawerFrameBlockEntity;
import com.chyzman.chowl.block.ExtendedParticleSpriteBlock;
import com.chyzman.chowl.block.ExtendedSoundGroupBlock;
import com.chyzman.chowl.block.SidedComparatorOutput;
import com.chyzman.chowl.block.button.BlockButton;
import com.chyzman.chowl.block.button.BlockButtonProvider;
import com.chyzman.chowl.block.button.ButtonRenderCondition;
import com.chyzman.chowl.block.button.ButtonRenderer;
import com.chyzman.chowl.classes.AttackInteractionReceiver;
import com.chyzman.chowl.graph.ServerGraphStore;
import com.chyzman.chowl.item.component.DisplayingPanelItem;
import com.chyzman.chowl.item.component.LockablePanelItem;
import com.chyzman.chowl.item.component.PanelItem;
import com.chyzman.chowl.item.component.UpgradeablePanelItem;
import com.chyzman.chowl.pond.ShapeContextExtended;
import com.chyzman.chowl.registry.ChowlRegistry;
import com.chyzman.chowl.transfer.BigStorageView;
import com.chyzman.chowl.transfer.PanelStorageContext;
import com.chyzman.chowl.util.BlockSideUtils;
import com.chyzman.chowl.util.ChowlRegistryHelper;
import io.wispforest.owo.ops.ItemOps;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.ToIntFunction;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.SlottedStorage;
import net.fabricmc.fabric.api.transfer.v1.storage.base.SingleSlotStorage;
import net.minecraft.class_10;
import net.minecraft.class_1264;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1747;
import net.minecraft.class_1750;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2237;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2464;
import net.minecraft.class_2487;
import net.minecraft.class_2498;
import net.minecraft.class_2512;
import net.minecraft.class_2586;
import net.minecraft.class_259;
import net.minecraft.class_2591;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2758;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3610;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_3726;
import net.minecraft.class_3737;
import net.minecraft.class_3965;
import net.minecraft.class_4538;
import net.minecraft.class_4970;
import net.minecraft.class_5558;
import net.minecraft.class_5819;
import net.minecraft.class_7871;
import net.minecraft.class_7923;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DrawerFrameBlock
extends class_2237
implements class_3737,
BlockButtonProvider,
AttackInteractionReceiver,
SidedComparatorOutput,
ExtendedParticleSpriteBlock,
ExtendedSoundGroupBlock,
BreakProgressMaskingBlock {
    public static final class_2746 WATERLOGGED = class_2741.field_12508;
    public static final class_2758 LIGHT_LEVEL = class_2741.field_12538;
    public static final class_2746 TICKING = class_2746.method_11825((String)"ticking");
    public static final ToIntFunction<class_2680> STATE_TO_LUMINANCE = state -> (Integer)state.method_11654((class_2769)LIGHT_LEVEL);
    public static final class_265 BASE = class_259.method_17786((class_265)class_2248.method_9541((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)2.0), (class_265[])new class_265[]{class_2248.method_9541((double)0.0, (double)0.0, (double)14.0, (double)16.0, (double)2.0, (double)16.0), class_2248.method_9541((double)0.0, (double)14.0, (double)14.0, (double)16.0, (double)16.0, (double)16.0), class_2248.method_9541((double)0.0, (double)14.0, (double)0.0, (double)16.0, (double)16.0, (double)2.0), class_2248.method_9541((double)0.0, (double)14.0, (double)2.0, (double)2.0, (double)16.0, (double)14.0), class_2248.method_9541((double)0.0, (double)0.0, (double)2.0, (double)2.0, (double)2.0, (double)14.0), class_2248.method_9541((double)14.0, (double)0.0, (double)2.0, (double)16.0, (double)2.0, (double)14.0), class_2248.method_9541((double)14.0, (double)14.0, (double)2.0, (double)16.0, (double)16.0, (double)14.0), class_2248.method_9541((double)14.0, (double)2.0, (double)0.0, (double)16.0, (double)14.0, (double)2.0), class_2248.method_9541((double)0.0, (double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)2.0), class_2248.method_9541((double)0.0, (double)2.0, (double)14.0, (double)2.0, (double)14.0, (double)16.0), class_2248.method_9541((double)14.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0, (double)16.0)});
    public static final class_265[] SIDES = new class_265[]{class_2248.method_9541((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)2.0, (double)14.0), class_2248.method_9541((double)2.0, (double)14.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0), class_2248.method_9541((double)2.0, (double)2.0, (double)0.0, (double)14.0, (double)14.0, (double)2.0), class_2248.method_9541((double)2.0, (double)2.0, (double)14.0, (double)14.0, (double)14.0, (double)16.0), class_2248.method_9541((double)0.0, (double)2.0, (double)2.0, (double)2.0, (double)14.0, (double)14.0), class_2248.method_9541((double)14.0, (double)2.0, (double)2.0, (double)16.0, (double)14.0, (double)14.0)};
    public static final BlockButton DEFAULT_PANEL_BUTTON = PanelItem.buttonBuilder(2.0f, 2.0f, 14.0f, 14.0f).onUse((world, drawerFrame, side, stack, player, hand) -> {
        List<DrawerFrameBlockEntity.SideState> stacks = drawerFrame.stacks;
        class_1799 stackInHand = player.method_5998(hand);
        if (stackInHand.method_7960()) {
            return class_1269.field_5811;
        }
        if (!stack.method_7960()) {
            return class_1269.field_5811;
        }
        if (!world.field_9236) {
            class_1799 temp = stackInHand.method_7972();
            temp.method_7939(1);
            stacks.set(side.method_10146(), stacks.get(side.method_10146()).withStack(temp));
            stackInHand.method_7934(1);
            drawerFrame.method_5431();
        }
        return class_1269.field_5812;
    }).onAttack((world, drawerFrame, side, stack, player) -> {
        List<DrawerFrameBlockEntity.SideState> stacks = drawerFrame.stacks;
        if (stack.method_7960()) {
            return class_1269.field_5811;
        }
        if (!world.field_9236) {
            player.method_31548().method_7398(stack);
            stacks.set(side.method_10146(), DrawerFrameBlockEntity.SideState.empty());
            drawerFrame.method_5431();
        }
        return class_1269.field_5812;
    }).build();
    public static final BlockButton REMOVE_BUTTON = BlockButton.builder(14.0f, 14.0f, 16.0f, 16.0f).onAttackOrUse((world, state, hitResult, player) -> {
        class_2586 patt0$temp = world.method_8321(hitResult.method_17777());
        if (!(patt0$temp instanceof DrawerFrameBlockEntity)) {
            return class_1269.field_5811;
        }
        DrawerFrameBlockEntity blockEntity = (DrawerFrameBlockEntity)patt0$temp;
        class_2350 side = BlockSideUtils.getSide(hitResult);
        class_1799 selected = blockEntity.stacks.get((int)side.method_10146()).stack;
        if (!world.field_9236) {
            player.method_31548().method_7398(selected);
            blockEntity.stacks.set(side.method_10146(), DrawerFrameBlockEntity.SideState.empty());
            blockEntity.method_5431();
        }
        return class_1269.field_5812;
    }).renderWhen(ButtonRenderCondition.PANEL_FOCUSED).renderer(ButtonRenderer.model(ChowlRegistryHelper.id("item/remove"))).build();
    public static final BlockButton FULL_REMOVE_BUTTON = BlockButton.builder(0.0f, 0.0f, 16.0f, 16.0f).onAttack((world, state, hitResult, player) -> {
        class_2586 patt0$temp = world.method_8321(hitResult.method_17777());
        if (!(patt0$temp instanceof DrawerFrameBlockEntity)) {
            return class_1269.field_5811;
        }
        DrawerFrameBlockEntity blockEntity = (DrawerFrameBlockEntity)patt0$temp;
        if (!player.method_5715()) {
            return class_1269.field_5811;
        }
        class_2350 side = BlockSideUtils.getSide(hitResult);
        DrawerFrameBlockEntity.SideState selected = blockEntity.stacks.get(side.method_10146());
        if (!world.field_9236) {
            player.method_31548().method_7398(selected.stack);
            blockEntity.stacks.set(side.method_10146(), DrawerFrameBlockEntity.SideState.empty());
            blockEntity.method_5431();
        }
        return class_1269.field_5812;
    }).onDoubleClick((world, state, hitResult, player) -> {
        class_2586 patt0$temp = world.method_8321(hitResult.method_17777());
        if (!(patt0$temp instanceof DrawerFrameBlockEntity)) {
            return class_1269.field_5811;
        }
        DrawerFrameBlockEntity blockEntity = (DrawerFrameBlockEntity)patt0$temp;
        boolean changed = false;
        for (int i = 0; i < 6; ++i) {
            if (!blockEntity.stacks.get(i).isEmpty()) continue;
            if (world.field_9236) {
                return class_1269.field_5812;
            }
            changed = true;
            blockEntity.stacks.set(i, new DrawerFrameBlockEntity.SideState(class_1799.field_8037, 0, true));
        }
        if (changed) {
            blockEntity.method_5431();
            return class_1269.field_5812;
        }
        return class_1269.field_5811;
    }).build();
    public static final BlockButton CONFIG_BUTTON = BlockButton.builder(12.0f, 14.0f, 14.0f, 16.0f).onAttackOrUse((world, state, hitResult, player) -> {
        class_2586 patt0$temp = world.method_8321(hitResult.method_17777());
        if (!(patt0$temp instanceof DrawerFrameBlockEntity)) {
            return class_1269.field_5811;
        }
        DrawerFrameBlockEntity blockEntity = (DrawerFrameBlockEntity)patt0$temp;
        class_2350 side = BlockSideUtils.getSide(hitResult);
        class_1799 selected = blockEntity.stacks.get((int)side.method_10146()).stack;
        class_1792 patt1$temp = selected.method_7909();
        if (!(patt1$temp instanceof PanelItem)) {
            return class_1269.field_5814;
        }
        PanelItem panel = (PanelItem)patt1$temp;
        if (!panel.hasConfig()) {
            return class_1269.field_5814;
        }
        panel.openConfig(selected, player, newStack -> {
            blockEntity.stacks.set(side.method_10146(), blockEntity.stacks.get(side.method_10146()).withStack((class_1799)newStack));
            blockEntity.method_5431();
        });
        return class_1269.field_5812;
    }).renderWhen(ButtonRenderCondition.PANEL_FOCUSED).renderer(ButtonRenderer.model(ChowlRegistryHelper.id("item/cog"))).build();

    public DrawerFrameBlock(class_4970.class_2251 settings) {
        super(settings);
        this.method_9590((class_2680)((class_2680)((class_2680)((class_2680)this.field_10647.method_11664()).method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.FALSE)).method_11657((class_2769)LIGHT_LEVEL, (Comparable)Integer.valueOf(0))).method_11657((class_2769)TICKING, (Comparable)Boolean.FALSE));
    }

    @Nullable
    public class_2680 method_9605(class_1750 ctx) {
        class_2338 blockPos = ctx.method_8037();
        class_3610 fluidState = ctx.method_8045().method_8316(blockPos);
        return (class_2680)super.method_9605(ctx).method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(fluidState.method_15772() == class_3612.field_15910));
    }

    public void method_9615(class_2680 state, class_1937 world, class_2338 pos, class_2680 oldState, boolean notify) {
        super.method_9615(state, world, pos, oldState, notify);
        if (oldState.method_26204() != this && world instanceof class_3218) {
            class_3218 sw = (class_3218)world;
            ServerGraphStore.get(sw).tryAdd(pos, state, this.findLinks(world, pos));
        }
    }

    public void method_9536(class_2680 state, class_1937 world, class_2338 pos, class_2680 newState, boolean moved) {
        class_2586 blockEntity;
        if (!state.method_27852(newState.method_26204()) && (blockEntity = world.method_8321(pos)) instanceof DrawerFrameBlockEntity) {
            DrawerFrameBlockEntity drawerFrameBlockEntity = (DrawerFrameBlockEntity)blockEntity;
            for (DrawerFrameBlockEntity.SideState stack : drawerFrameBlockEntity.stacks) {
                class_1264.method_5449((class_1937)world, (double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260(), (class_1799)stack.stack);
            }
        }
        super.method_9536(state, world, pos, newState, moved);
        if (newState.method_26204() != this && world instanceof class_3218) {
            class_3218 sw = (class_3218)world;
            ServerGraphStore.get(sw).tryRemove(pos);
        }
    }

    public class_2680 method_9559(class_2680 state, class_2350 direction, class_2680 neighborState, class_1936 world, class_2338 pos, class_2338 neighborPos) {
        this.scheduleFluidTick(world, pos, state);
        return super.method_9559(state, direction, neighborState, world, pos, neighborPos);
    }

    @Nullable
    public <T extends class_2586> class_5558<T> method_31645(class_1937 world, class_2680 state, class_2591<T> type) {
        if (((Boolean)state.method_11654((class_2769)TICKING)).booleanValue()) {
            return (world1, pos, state1, blockEntity) -> {
                if (blockEntity instanceof DrawerFrameBlockEntity) {
                    DrawerFrameBlockEntity drawerFrameBlockEntity = (DrawerFrameBlockEntity)blockEntity;
                    drawerFrameBlockEntity.tick(world1, pos, state1);
                }
            };
        }
        return super.method_31645(world, state, type);
    }

    private Set<class_2338> findLinks(class_1937 world, class_2338 pos) {
        HashSet<class_2338> links = new HashSet<class_2338>();
        for (int i = 0; i < 6; ++i) {
            class_2338 possible = pos.method_10093(class_2350.method_10143((int)i));
            if (pos.equals((Object)possible) || world.method_8320(possible).method_26204() != this) continue;
            links.add(possible.method_10062());
        }
        return links;
    }

    @Nullable
    public class_2586 method_10123(class_2338 pos, class_2680 state) {
        return new DrawerFrameBlockEntity(pos, state);
    }

    public class_2464 method_9604(class_2680 state) {
        return class_2464.field_11458;
    }

    public class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        if (context.method_17785(this.method_8389())) {
            return class_259.method_1077();
        }
        if (((ShapeContextExtended)context).isHolding(stack -> stack.method_7909() instanceof PanelItem) && !context.method_16193()) {
            return class_259.method_1077();
        }
        class_2586 class_25862 = world.method_8321(pos);
        if (!(class_25862 instanceof DrawerFrameBlockEntity)) {
            return BASE;
        }
        DrawerFrameBlockEntity frame = (DrawerFrameBlockEntity)class_25862;
        return frame.outlineShape;
    }

    public class_265 method_9549(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        class_2586 class_25862 = world.method_8321(pos);
        if (!(class_25862 instanceof DrawerFrameBlockEntity)) {
            return BASE;
        }
        DrawerFrameBlockEntity frame = (DrawerFrameBlockEntity)class_25862;
        return frame.collisionShape;
    }

    public class_3610 method_9545(class_2680 state) {
        return (Boolean)state.method_11654((class_2769)WATERLOGGED) != false ? class_3612.field_15910.method_15729(false) : super.method_9545(state);
    }

    public void method_9588(class_2680 state, class_3218 world, class_2338 pos, class_5819 random) {
        class_2586 class_25862 = world.method_8321(pos);
        if (class_25862 instanceof DrawerFrameBlockEntity) {
            DrawerFrameBlockEntity frame = (DrawerFrameBlockEntity)class_25862;
            frame.spreadTemplate();
        }
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{WATERLOGGED, LIGHT_LEVEL, TICKING});
    }

    @Override
    public class_1269 method_9534(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
        if (player.method_5998(hand).method_31574(this.method_8389())) {
            return class_1269.field_5811;
        }
        class_2350 side = BlockSideUtils.getSide(hit);
        int orientation = 0;
        if (side == class_2350.field_11036 || side == class_2350.field_11033 && player.method_5735().method_10166() == class_2350.class_2351.field_11051) {
            orientation = (int)player.method_5735().method_10153().method_10144() / 90;
        } else if (side == class_2350.field_11033) {
            orientation = (int)player.method_5735().method_10144() / 90;
        }
        class_1269 res = BlockButtonProvider.super.method_9534(state, world, pos, player, hand, hit);
        if (res != class_1269.field_5811) {
            this.scheduleFluidTick((class_1936)world, pos, state);
            return res;
        }
        class_2586 blockEntity = world.method_8321(pos);
        if (blockEntity instanceof DrawerFrameBlockEntity) {
            DrawerFrameBlockEntity frame = (DrawerFrameBlockEntity)blockEntity;
            List<DrawerFrameBlockEntity.SideState> stacks = frame.stacks;
            class_1799 stackInHand = player.method_5998(hand);
            DrawerFrameBlockEntity.SideState sideStack = stacks.get(side.method_10146());
            if (sideStack.isEmpty()) {
                if (!stackInHand.method_7960()) {
                    if (!world.field_9236) {
                        class_1799 temp = ItemOps.singleCopy((class_1799)stackInHand);
                        stacks.set(side.method_10146(), new DrawerFrameBlockEntity.SideState(ItemOps.singleCopy((class_1799)temp), orientation, false));
                        stackInHand.method_7934(1);
                        frame.method_5431();
                        world.method_8408(pos, (class_2248)this);
                    }
                    return class_1269.field_5812;
                }
                if (!world.field_9236) {
                    stacks.set(side.method_10146(), new DrawerFrameBlockEntity.SideState(class_1799.field_8037, orientation, true));
                    frame.method_5431();
                    world.method_8408(pos, (class_2248)this);
                }
                return class_1269.field_5812;
            }
        }
        return class_1269.field_5811;
    }

    @Override
    public List<BlockButton> listButtons(class_1937 world, class_2680 state, class_2338 pos, class_2350 side) {
        class_1792 class_17922;
        class_2586 class_25862 = world.method_8321(pos);
        if (!(class_25862 instanceof DrawerFrameBlockEntity)) {
            return List.of();
        }
        DrawerFrameBlockEntity blockEntity = (DrawerFrameBlockEntity)class_25862;
        DrawerFrameBlockEntity.SideState selected = blockEntity.stacks.get(side.method_10146());
        if (selected.isEmpty()) {
            return List.of();
        }
        ArrayList<BlockButton> buttons = new ArrayList<BlockButton>();
        if (selected.isBlank || selected.stack.method_31574(ChowlRegistry.PHANTOM_PANEL_ITEM)) {
            buttons.add(FULL_REMOVE_BUTTON);
        } else {
            buttons.add(REMOVE_BUTTON);
        }
        if (selected.stack.method_7909() instanceof LockablePanelItem) {
            buttons.add(LockablePanelItem.LOCK_BUTTON);
        }
        if ((class_17922 = selected.stack.method_7909()) instanceof PanelItem) {
            class_1792 class_17923;
            PanelItem panelItem = (PanelItem)class_17922;
            if (panelItem.hasConfig()) {
                buttons.add(CONFIG_BUTTON);
            }
            if ((class_17923 = selected.stack.method_7909()) instanceof UpgradeablePanelItem) {
                UpgradeablePanelItem upgradeable = (UpgradeablePanelItem)class_17923;
                if (!DisplayingPanelItem.getConfig(selected.stack).hideUpgrades()) {
                    upgradeable.addUpgradeButtons(selected.stack, buttons);
                }
            }
            buttons.addAll(panelItem.listButtons(blockEntity, side, selected.stack));
        } else {
            buttons.add(DEFAULT_PANEL_BUTTON);
        }
        return buttons;
    }

    @Override
    @NotNull
    public class_1269 onAttack(class_1937 world, class_2680 state, class_3965 hitResult, class_1657 player) {
        this.scheduleFluidTick((class_1936)world, hitResult.method_17777(), state);
        return BlockButtonProvider.super.onAttack(world, state, hitResult, player);
    }

    @Override
    @NotNull
    public class_1269 onDoubleClick(class_1937 world, class_2680 state, class_3965 hitResult, class_1657 player) {
        this.scheduleFluidTick((class_1936)world, hitResult.method_17777(), state);
        return BlockButtonProvider.super.onDoubleClick(world, state, hitResult, player);
    }

    public boolean method_9498(class_2680 state) {
        return true;
    }

    public int method_9572(class_2680 state, class_1937 world, class_2338 pos) {
        class_2586 class_25862 = world.method_8321(pos);
        if (!(class_25862 instanceof DrawerFrameBlockEntity)) {
            return 0;
        }
        DrawerFrameBlockEntity frame = (DrawerFrameBlockEntity)class_25862;
        for (int i = 0; i < 6; ++i) {
            SlottedStorage<ItemVariant> storage;
            PanelItem panel;
            DrawerFrameBlockEntity.SideState panelStack = frame.stacks.get(i);
            class_1792 class_17922 = panelStack.stack.method_7909();
            if (!(class_17922 instanceof PanelItem) || !(panel = (PanelItem)class_17922).hasComparatorOutput() || (storage = panel.getStorage(PanelStorageContext.from(frame, class_2350.method_10143((int)i)))).getSlotCount() == 0) continue;
            SingleSlotStorage slot = storage.getSlot(0);
            return BigStorageView.bigAmount(slot).multiply(BigInteger.valueOf(15L)).divide(BigStorageView.bigCapacity(slot)).intValue();
        }
        return 0;
    }

    @Override
    public int getSidedComparatorOutput(class_2680 state, class_1937 world, class_2338 pos, class_2350 side) {
        class_2586 class_25862 = world.method_8321(pos);
        if (!(class_25862 instanceof DrawerFrameBlockEntity)) {
            return 0;
        }
        DrawerFrameBlockEntity frame = (DrawerFrameBlockEntity)class_25862;
        DrawerFrameBlockEntity.SideState panelStack = frame.stacks.get(side.method_10153().method_10146());
        class_1792 class_17922 = panelStack.stack.method_7909();
        if (!(class_17922 instanceof PanelItem)) {
            return 0;
        }
        PanelItem panel = (PanelItem)class_17922;
        if (!panel.hasComparatorOutput()) {
            return 0;
        }
        SlottedStorage<ItemVariant> storage = panel.getStorage(PanelStorageContext.from(frame, side.method_10153()));
        if (storage.getSlotCount() == 0) {
            return 0;
        }
        SingleSlotStorage slot = storage.getSlot(0);
        return BigStorageView.bigAmount(slot).multiply(BigInteger.valueOf(15L)).divide(BigStorageView.bigCapacity(slot)).intValue();
    }

    public static int getOrientation(class_1937 world, class_3965 hitResult) {
        class_2586 blockEntity = world.method_8321(hitResult.method_17777());
        if (blockEntity instanceof DrawerFrameBlockEntity) {
            DrawerFrameBlockEntity drawerFrameBlockEntity = (DrawerFrameBlockEntity)blockEntity;
            class_2350 side = BlockSideUtils.getSide(hitResult);
            return drawerFrameBlockEntity.stacks.get((int)side.method_10146()).orientation;
        }
        return 0;
    }

    private void scheduleFluidTick(class_1936 world, class_2338 pos, class_2680 state) {
        if (((Boolean)state.method_11654((class_2769)WATERLOGGED)).booleanValue()) {
            world.method_39281(pos, (class_3611)class_3612.field_15910, class_3612.field_15910.method_15789((class_4538)world));
        }
    }

    @Override
    public class_2680 getParticleState(class_1937 world, class_2338 pos, class_2680 state) {
        class_2586 class_25862 = world.method_8321(pos);
        if (!(class_25862 instanceof DrawerFrameBlockEntity)) {
            return state;
        }
        DrawerFrameBlockEntity frame = (DrawerFrameBlockEntity)class_25862;
        if (frame.templateState == null) {
            return state;
        }
        return frame.templateState;
    }

    @Override
    public class_2498 getSoundGroup(class_1937 world, class_2338 pos, class_2680 state) {
        class_2586 class_25862 = world.method_8321(pos);
        if (!(class_25862 instanceof DrawerFrameBlockEntity)) {
            return this.method_9573(state);
        }
        DrawerFrameBlockEntity frame = (DrawerFrameBlockEntity)class_25862;
        if (frame.templateState == null) {
            return this.method_9573(state);
        }
        return frame.templateState.method_26231();
    }

    @Override
    public class_2498 getSoundGroup(class_1937 world, class_2338 pos, class_2680 state, class_1799 stack) {
        class_2487 tag = class_1747.method_38072((class_1799)stack);
        if (tag == null) {
            return this.method_9573(state);
        }
        if (!tag.method_10573("TemplateState", 10)) {
            return this.method_9573(state);
        }
        return class_2512.method_10681((class_7871)class_7923.field_41175.method_46771(), (class_2487)tag.method_10562("TemplateState")).method_26231();
    }

    /*
     * Enabled aggressive block sorting
     */
    public void method_9496(class_2680 state, class_1937 world, class_2338 pos, class_5819 random) {
        class_2586 class_25862 = world.method_8321(pos);
        if (class_25862 instanceof DrawerFrameBlockEntity) {
            DrawerFrameBlockEntity frame = (DrawerFrameBlockEntity)class_25862;
            if (frame.templateState != null && frame.templateState != state) {
                frame.templateState.method_26204().method_9496(frame.templateState, world, pos, random);
                return;
            }
        }
        super.method_9496(state, world, pos, random);
    }

    public boolean method_9579(class_2680 state, class_1922 world, class_2338 pos) {
        class_2586 class_25862 = world.method_8321(pos);
        if (class_25862 instanceof DrawerFrameBlockEntity) {
            DrawerFrameBlockEntity frame = (DrawerFrameBlockEntity)class_25862;
            if (frame.templateState != null) {
                return frame.templateState.method_26204().method_9579(frame.templateState, world, pos);
            }
        }
        return super.method_9579(state, world, pos);
    }

    @Override
    public float calcMaskedBlockBreakingDelta(class_2680 state, class_1657 player, class_1922 world, class_2338 pos) {
        class_2586 class_25862 = world.method_8321(pos);
        if (class_25862 instanceof DrawerFrameBlockEntity) {
            DrawerFrameBlockEntity frame = (DrawerFrameBlockEntity)class_25862;
            if (frame.templateState != null) {
                return frame.templateState.method_26165(player, world, pos);
            }
        }
        return this.method_9594(state, player, world, pos);
    }

    public boolean method_9516(class_2680 state, class_1922 world, class_2338 pos, class_10 type) {
        return false;
    }
}

