/*
 * Decompiled with CFR 0.152.
 */
package com.chyzman.chowl.block;

import com.chyzman.chowl.Chowl;
import com.chyzman.chowl.block.DrawerFrameBlock;
import com.chyzman.chowl.client.ChowlClient;
import com.chyzman.chowl.item.component.DisplayingPanelItem;
import com.chyzman.chowl.item.component.PanelItem;
import com.chyzman.chowl.registry.ChowlRegistry;
import com.chyzman.chowl.transfer.PanelStorageContext;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import io.wispforest.owo.ops.WorldOps;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.SlottedStorage;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.base.CombinedSlottedStorage;
import net.fabricmc.fabric.api.transfer.v1.storage.base.SidedStorageBlockEntity;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_259;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2622;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_7871;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;

public class DrawerFrameBlockEntity
extends class_2586
implements SidedStorageBlockEntity {
    public List<SideState> stacks = new ArrayList(class_2371.method_10213((int)6, (Object)new SideState(class_1799.field_8037, 0, false)).stream().toList());
    public class_2680 templateState = null;
    public class_265 outlineShape = DrawerFrameBlock.BASE;
    public class_265 collisionShape = DrawerFrameBlock.BASE;
    private static final LoadingCache<Integer, class_265> SHAPE_CACHE = CacheBuilder.newBuilder().build(CacheLoader.from(sides -> {
        class_265 shape = DrawerFrameBlock.BASE;
        for (int i = 0; i < 6; ++i) {
            if ((sides & 1 << i) == 0) continue;
            shape = class_259.method_1084((class_265)shape, (class_265)DrawerFrameBlock.SIDES[i]);
        }
        return shape;
    }));

    public DrawerFrameBlockEntity(class_2338 pos, class_2680 state) {
        super(Chowl.DRAWER_FRAME_BLOCK_ENTITY_TYPE, pos, state);
    }

    public class_2487 method_16887() {
        return this.method_38244();
    }

    @Nullable
    public class_2596<class_2602> method_38235() {
        return class_2622.method_38585((class_2586)this);
    }

    @Nullable
    public Storage<ItemVariant> getItemStorage(@Nullable class_2350 fromSide) {
        if (fromSide == null) {
            ArrayList<SlottedStorage<ItemVariant>> storages = new ArrayList<SlottedStorage<ItemVariant>>();
            for (int i = 0; i < 6; ++i) {
                PanelItem panelItem;
                SlottedStorage<ItemVariant> storage;
                PanelStorageContext ctx = PanelStorageContext.from(this, class_2350.method_10143((int)i));
                class_1792 class_17922 = ctx.stack().method_7909();
                if (!(class_17922 instanceof PanelItem) || (storage = (panelItem = (PanelItem)class_17922).getStorage(ctx)) == null) continue;
                storages.add(storage);
            }
            return new CombinedSlottedStorage(storages);
        }
        PanelStorageContext ctx = PanelStorageContext.from(this, fromSide);
        class_1792 class_17923 = ctx.stack().method_7909();
        if (!(class_17923 instanceof PanelItem)) {
            return null;
        }
        PanelItem panelItem = (PanelItem)class_17923;
        return panelItem.getStorage(ctx);
    }

    public boolean isSideBaked(int sideId) {
        SideState side = this.stacks.get(sideId);
        if (this.templateState != null && side.stack.method_7909() instanceof PanelItem && !DisplayingPanelItem.getConfig(side.stack).ignoreTemplating()) {
            return true;
        }
        return side.isBlank;
    }

    private void updateShapes() {
        int collision = 0;
        int outline = 0;
        for (int i = 0; i < this.stacks.size(); ++i) {
            SideState side = this.stacks.get(i);
            if (side.isEmpty()) continue;
            outline |= 1 << i;
            if (side.stack.method_7909() == ChowlRegistry.PHANTOM_PANEL_ITEM) continue;
            collision |= 1 << i;
        }
        this.collisionShape = (class_265)SHAPE_CACHE.getUnchecked((Object)collision);
        this.outlineShape = (class_265)SHAPE_CACHE.getUnchecked((Object)outline);
    }

    public void scheduleSpreadTemplate() {
        this.field_11863.method_39279(this.field_11867, this.method_11010().method_26204(), 1);
    }

    public void spreadTemplate() {
        for (int i = 0; i < 6; ++i) {
            class_2338 possible = this.field_11867.method_10093(class_2350.method_10143((int)i));
            class_2586 class_25862 = this.field_11863.method_8321(possible);
            if (!(class_25862 instanceof DrawerFrameBlockEntity)) continue;
            DrawerFrameBlockEntity other = (DrawerFrameBlockEntity)class_25862;
            if (other.templateState == this.templateState) continue;
            other.templateState = this.templateState;
            this.field_11863.method_8501(possible, (class_2680)this.field_11863.method_8320(possible).method_11657((class_2769)DrawerFrameBlock.LIGHT_LEVEL, (Comparable)Integer.valueOf(this.templateState != null ? this.templateState.method_26213() : 0)));
            other.method_5431();
            other.scheduleSpreadTemplate();
        }
    }

    public void method_5431() {
        super.method_5431();
        WorldOps.updateIfOnServer((class_1937)this.field_11863, (class_2338)this.field_11867);
        this.updateShapes();
    }

    public void method_11014(class_2487 nbt) {
        if (nbt == null) {
            return;
        }
        super.method_11014(nbt);
        class_2499 nbtList = nbt.method_10554("Inventory", 10);
        for (int i = 0; i < nbtList.size(); ++i) {
            class_2487 compound = (class_2487)nbtList.method_10534(i);
            this.stacks.set(i, new SideState(class_1799.method_7915((class_2487)compound.method_10562("Stack")), compound.method_10550("Orientation"), compound.method_10577("IsBlank")));
        }
        this.templateState = nbt.method_10573("TemplateState", 10) ? class_2512.method_10681((class_7871)class_7923.field_41175.method_46771(), (class_2487)nbt.method_10562("TemplateState")) : null;
        if (this.field_11863 != null && this.field_11863.field_9236) {
            ChowlClient.reloadPos(this.field_11863, this.field_11867);
        }
        this.updateShapes();
    }

    public void method_11007(class_2487 nbt) {
        super.method_11007(nbt);
        DrawerFrameBlockEntity.writePanelsToNbt(this.stacks, nbt);
        if (this.templateState != null) {
            nbt.method_10566("TemplateState", (class_2520)class_2512.method_10686((class_2680)this.templateState));
        }
    }

    public static void writePanelsToNbt(List<SideState> panels, class_2487 nbt) {
        class_2499 nbtList = new class_2499();
        for (SideState stack : panels) {
            class_2487 compound = new class_2487();
            compound.method_10566("Stack", (class_2520)stack.stack.method_7953(new class_2487()));
            compound.method_10569("Orientation", stack.orientation);
            compound.method_10556("IsBlank", stack.isBlank);
            nbtList.add((Object)compound);
        }
        nbt.method_10566("Inventory", (class_2520)nbtList);
    }

    @Nullable
    public Object getRenderData() {
        return this.templateState;
    }

    public void tick(class_1937 world, class_2338 pos, class_2680 state) {
        if (world.field_9236) {
            return;
        }
        for (SideState stored : this.stacks) {
            if (!stored.stack.method_7960()) continue;
        }
    }

    public static final class SideState {
        public class_1799 stack;
        public int orientation;
        public boolean isBlank;

        public SideState(class_1799 stack, int orientation, boolean isBlank) {
            this.stack = stack;
            this.orientation = orientation;
            this.isBlank = isBlank;
        }

        public static SideState empty() {
            return new SideState(class_1799.field_8037, 0, false);
        }

        public SideState withStack(class_1799 stack) {
            return new SideState(stack, this.orientation, this.isBlank);
        }

        public boolean isEmpty() {
            return this.stack.method_7960() && !this.isBlank;
        }
    }
}

