/*
 * Decompiled with CFR 0.152.
 */
package com.chyzman.chowl.block;

import com.chyzman.chowl.block.DrawerFrameBlockEntity;
import com.chyzman.chowl.client.RenderGlobals;
import com.chyzman.chowl.client.RetextureInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import net.fabricmc.fabric.api.renderer.v1.mesh.MutableQuadView;
import net.fabricmc.fabric.api.renderer.v1.model.ForwardingBakedModel;
import net.fabricmc.fabric.api.renderer.v1.render.RenderContext;
import net.minecraft.class_1058;
import net.minecraft.class_1087;
import net.minecraft.class_1100;
import net.minecraft.class_1799;
import net.minecraft.class_1920;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3665;
import net.minecraft.class_4730;
import net.minecraft.class_5819;
import net.minecraft.class_7775;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DrawerFrameBlockModel
extends ForwardingBakedModel {
    private final Map<class_2350, class_1087> panels;

    private DrawerFrameBlockModel(class_1087 wrapped, Map<class_2350, class_1087> panels) {
        this.panels = panels;
        this.wrapped = wrapped;
    }

    public boolean isVanillaAdapter() {
        return false;
    }

    public void emitBlockQuads(class_1920 blockView, class_2680 state, class_2338 pos, Supplier<class_5819> randomSupplier, RenderContext context) {
        class_2680 template = (class_2680)blockView.getBlockEntityRenderData(pos);
        if (template != null) {
            RetextureInfo info = RetextureInfo.get(template);
            context.pushTransform((RenderContext.QuadTransform)new RetextureTransform(info, blockView, pos));
        }
        super.emitBlockQuads(blockView, state, pos, randomSupplier, context);
        class_2586 be = blockView.method_8321(pos);
        if (be instanceof DrawerFrameBlockEntity) {
            DrawerFrameBlockEntity frame = (DrawerFrameBlockEntity)be;
            for (int sideId = 0; sideId < 6; ++sideId) {
                class_2350 side = class_2350.method_10143((int)sideId);
                if (!frame.isSideBaked(sideId)) continue;
                this.panels.get(side).emitBlockQuads(blockView, state, pos, randomSupplier, context);
            }
        }
        if (template != null) {
            context.popTransform();
        }
    }

    public void emitItemQuads(class_1799 stack, Supplier<class_5819> randomSupplier, RenderContext context) {
        class_2680 template;
        DrawerFrameBlockEntity frame = RenderGlobals.DRAWER_FRAME.get();
        class_2680 class_26802 = template = frame != null ? frame.templateState : null;
        if (template != null) {
            RetextureInfo info = RetextureInfo.get(template);
            context.pushTransform((RenderContext.QuadTransform)new RetextureTransform(info, null, null));
        }
        super.emitItemQuads(stack, randomSupplier, context);
        if (frame != null) {
            for (int sideId = 0; sideId < 6; ++sideId) {
                class_2350 side = class_2350.method_10143((int)sideId);
                if (!frame.isSideBaked(sideId)) continue;
                this.panels.get(side).emitItemQuads(stack, randomSupplier, context);
            }
        }
        if (template != null) {
            context.popTransform();
        }
    }

    private static class RetextureTransform
    implements RenderContext.QuadTransform {
        private final RetextureInfo info;
        @Nullable
        private final class_1920 world;
        @Nullable
        private final class_2338 pos;

        private RetextureTransform(RetextureInfo info, @Nullable class_1920 world, @Nullable class_2338 pos) {
            this.info = info;
            this.world = world;
            this.pos = pos;
        }

        public boolean transform(MutableQuadView quad) {
            class_2350 face = quad.nominalFace();
            if (face == null) {
                return true;
            }
            if (!this.info.changeSprite(quad, face)) {
                return false;
            }
            if (this.world != null && this.pos != null) {
                this.info.changeColor(quad, face, this.world, this.pos);
            }
            return true;
        }
    }

    public record Unbaked(class_2960 baseModel, Map<class_2350, class_2960> panelModels) implements class_1100
    {
        public static Unbaked create(class_2960 baseModel, class_2960 panelModelPrefix) {
            HashMap<class_2350, class_2960> panelModels = new HashMap<class_2350, class_2960>();
            for (int sideId = 0; sideId < 6; ++sideId) {
                class_2350 side = class_2350.method_10143((int)sideId);
                panelModels.put(side, new class_2960(panelModelPrefix.method_12836(), panelModelPrefix.method_12832() + "_" + side.method_10151()));
            }
            return new Unbaked(baseModel, panelModels);
        }

        public Collection<class_2960> method_4755() {
            ArrayList<class_2960> deps = new ArrayList<class_2960>();
            deps.add(this.baseModel);
            deps.addAll(this.panelModels.values());
            return deps;
        }

        public void method_45785(Function<class_2960, class_1100> modelLoader) {
        }

        @NotNull
        public class_1087 method_4753(class_7775 baker, Function<class_4730, class_1058> textureGetter, class_3665 rotationContainer, class_2960 modelId) {
            EnumMap<class_2350, class_1087> bakedPanelModels = new EnumMap<class_2350, class_1087>(class_2350.class);
            for (Map.Entry<class_2350, class_2960> entry : this.panelModels.entrySet()) {
                bakedPanelModels.put(entry.getKey(), baker.method_45873(entry.getValue(), rotationContainer));
            }
            return new DrawerFrameBlockModel(baker.method_45873(this.baseModel, rotationContainer), bakedPanelModels);
        }
    }
}

