/*
 * Decompiled with CFR 0.152.
 */
package com.chyzman.chowl.block.button;

import com.chyzman.chowl.block.DoubleClickableBlock;
import com.chyzman.chowl.block.DrawerFrameBlock;
import com.chyzman.chowl.block.button.BlockButton;
import com.chyzman.chowl.classes.AttackInteractionReceiver;
import com.chyzman.chowl.util.BlockSideUtils;
import java.util.List;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_3965;
import net.minecraft.class_7833;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

public interface BlockButtonProvider
extends AttackInteractionReceiver,
DoubleClickableBlock {
    public List<BlockButton> listButtons(class_1937 var1, class_2680 var2, class_2338 var3, class_2350 var4);

    @Nullable
    default public BlockButton findButton(class_1937 world, class_2680 state, class_3965 hitResult, int orientation) {
        Vector3f vec = hitResult.method_17784().method_1020(hitResult.method_17777().method_46558()).method_46409();
        class_2350 side = BlockSideUtils.getSide(hitResult);
        vec.rotate((Quaternionfc)side.method_23224().invert()).rotate((Quaternionfc)class_2350.field_11039.method_23224()).rotate((Quaternionfc)class_7833.field_40713.rotationDegrees(orientation > 0 && orientation < 4 ? (float)(orientation * 90) : 0.0f));
        vec.add(0.5f, 0.5f, 0.5f);
        for (BlockButton button : this.listButtons(world, state, hitResult.method_17777(), side)) {
            if (!button.isIn(vec.z, vec.y)) continue;
            return button;
        }
        return null;
    }

    @NotNull
    default public class_1269 method_9534(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
        BlockButton button = this.findButton(world, state, hit, DrawerFrameBlock.getOrientation(world, hit));
        if (button == null) {
            return class_1269.field_5811;
        }
        if (button.use() == null) {
            return class_1269.field_5811;
        }
        return button.use().apply(state, world, pos, player, hand, hit);
    }

    @Override
    @NotNull
    default public class_1269 onAttack(class_1937 world, class_2680 state, class_3965 hitResult, class_1657 player) {
        BlockButton button = this.findButton(world, state, hitResult, DrawerFrameBlock.getOrientation(world, hitResult));
        if (button == null) {
            return class_1269.field_5811;
        }
        if (button.attack() == null) {
            return class_1269.field_5811;
        }
        return button.attack().apply(world, state, hitResult, player);
    }

    @Override
    @NotNull
    default public class_1269 onDoubleClick(class_1937 world, class_2680 state, class_3965 hitResult, class_1657 player) {
        BlockButton button = this.findButton(world, state, hitResult, DrawerFrameBlock.getOrientation(world, hitResult));
        if (button == null) {
            return class_1269.field_5811;
        }
        if (button.doubleClick() == null) {
            return class_1269.field_5811;
        }
        return button.doubleClick().apply(world, state, hitResult, player);
    }

    @FunctionalInterface
    public static interface UseFunction {
        public class_1269 apply(class_2680 var1, class_1937 var2, class_2338 var3, class_1657 var4, class_1268 var5, class_3965 var6);
    }

    @FunctionalInterface
    public static interface AttackFunction {
        public class_1269 apply(class_1937 var1, class_2680 var2, class_3965 var3, class_1657 var4);
    }

    @FunctionalInterface
    public static interface DoubleClickFunction {
        public class_1269 apply(class_1937 var1, class_2680 var2, class_3965 var3, class_1657 var4);
    }
}

