/*
 * Decompiled with CFR 0.152.
 */
package com.chyzman.chowl.client;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.List;
import java.util.concurrent.TimeUnit;
import net.fabricmc.fabric.api.renderer.v1.RendererAccess;
import net.fabricmc.fabric.api.renderer.v1.material.BlendMode;
import net.fabricmc.fabric.api.renderer.v1.material.RenderMaterial;
import net.fabricmc.fabric.api.renderer.v1.mesh.MutableQuadView;
import net.fabricmc.fabric.api.util.TriState;
import net.minecraft.class_1058;
import net.minecraft.class_1087;
import net.minecraft.class_1920;
import net.minecraft.class_1921;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_4696;
import net.minecraft.class_5819;
import net.minecraft.class_777;

public class RetextureInfo {
    private static final LoadingCache<class_2680, RetextureInfo> CACHE = CacheBuilder.newBuilder().expireAfterAccess(10L, TimeUnit.SECONDS).build(CacheLoader.from(RetextureInfo::new));
    private final class_2680 template;
    private final DirectionInfo[] directions = new DirectionInfo[6];
    private final RenderMaterial material;

    private RetextureInfo(class_2680 template) {
        this.template = template;
        class_1087 templateModel = class_310.method_1551().method_1541().method_3349(template);
        for (int dirId = 0; dirId < 6; ++dirId) {
            class_2350 dir = class_2350.method_10143((int)dirId);
            List quads = templateModel.method_4707(template, dir, class_5819.method_43047());
            if (quads.isEmpty()) {
                quads = templateModel.method_4707(template, null, class_5819.method_43047());
            }
            if (quads.isEmpty()) continue;
            class_777 quad = (class_777)quads.get(0);
            this.directions[dirId] = new DirectionInfo(quad.method_35788(), quad.method_3360(), quad.method_3359());
        }
        this.material = RendererAccess.INSTANCE.getRenderer().materialFinder().blendMode(BlendMode.fromRenderLayer((class_1921)class_4696.method_23679((class_2680)template))).ambientOcclusion(templateModel.method_4708() && template.method_26213() == 0 ? TriState.TRUE : TriState.FALSE).find();
    }

    public static RetextureInfo get(class_2680 template) {
        return (RetextureInfo)CACHE.getUnchecked((Object)template);
    }

    public boolean changeSprite(MutableQuadView quad, class_2350 face) {
        DirectionInfo info = this.directions[face.method_10146()];
        if (info == null) {
            return false;
        }
        quad.spriteBake(info.sprite, 4);
        quad.material(this.material);
        return true;
    }

    public void changeColor(MutableQuadView quad, class_2350 face, class_1920 world, class_2338 pos) {
        DirectionInfo info = this.directions[face.method_10146()];
        if (info == null) {
            return;
        }
        if (info.hasColor) {
            int color = class_310.method_1551().method_1505().method_1697(this.template, world, pos, info.colorIdx);
            quad.color(color |= 0xFF000000, color, color, color);
        }
    }

    private record DirectionInfo(class_1058 sprite, boolean hasColor, int colorIdx) {
    }
}

