/*
 * Decompiled with CFR 0.152.
 */
package com.chyzman.chowl.commands;

import com.chyzman.chowl.graph.ServerGraphStore;
import com.chyzman.chowl.util.CompressionManager;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1792;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_5321;
import net.minecraft.class_7157;
import net.minecraft.class_7733;
import net.minecraft.class_7923;
import net.minecraft.class_7924;

public final class DebugCommands {
    private DebugCommands() {
    }

    public static void register(CommandDispatcher<class_2168> dispatcher, class_7157 registryAccess) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"chowl").then(((LiteralArgumentBuilder)class_2170.method_9247((String)"graph").then(class_2170.method_9247((String)"dump").executes(DebugCommands::dumpGraphs))).then(class_2170.method_9247((String)"clear").executes(DebugCommands::clearGraphs)))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"compression").then(class_2170.method_9247((String)"dump").executes(DebugCommands::dumpCompression))).then(class_2170.method_9247((String)"build_all").executes(DebugCommands::buildAllCompression))).then(class_2170.method_9247((String)"clear").executes(DebugCommands::clearCompression))).then(class_2170.method_9247((String)"build").then(class_2170.method_9244((String)"item", (ArgumentType)class_7733.method_45603((class_7157)registryAccess, (class_5321)class_7924.field_41197)).executes(DebugCommands::buildItemCompression)))));
    }

    private static int dumpGraphs(CommandContext<class_2168> ctx) {
        StringBuilder sb = new StringBuilder();
        ServerGraphStore state = ServerGraphStore.get(((class_2168)ctx.getSource()).method_9225());
        sb.append("Dumping all graph data");
        for (ServerGraphStore.GraphEntry entry : state.graphs().values()) {
            sb.append("\nGraph ").append(entry.graphId).append(", ").append(entry.nodes.size()).append(" items:");
            for (ServerGraphStore.GraphNodeEntry node : entry.nodes.values()) {
                sb.append("\n  ").append(node.state()).append(" at ").append(node.pos()).append(", linked to ");
                for (Long link : node.links()) {
                    sb.append(class_2338.method_10092((long)link)).append(" ");
                }
            }
        }
        ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43470((String)sb.toString()), false);
        return 1;
    }

    private static int clearGraphs(CommandContext<class_2168> ctx) {
        ServerGraphStore state = ServerGraphStore.get(((class_2168)ctx.getSource()).method_9225());
        state.clear();
        ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43470((String)"Cleared all graph data."), false);
        return 1;
    }

    private static int dumpCompression(CommandContext<class_2168> ctx) {
        String dotGraph = CompressionManager.dumpDotGraph();
        Path graphPath = FabricLoader.getInstance().getGameDir().resolve("chowl_compression_graph.dot").toAbsolutePath();
        try {
            Files.writeString(graphPath, (CharSequence)dotGraph, new OpenOption[0]);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43470((String)("Dumped compression graph to " + String.valueOf(graphPath))), false);
        return 1;
    }

    private static int clearCompression(CommandContext<class_2168> ctx) {
        CompressionManager.NODES.clear();
        ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43470((String)"Cleared compression graph."), false);
        return 1;
    }

    private static int buildItemCompression(CommandContext<class_2168> ctx) throws CommandSyntaxException {
        class_1792 item = (class_1792)class_7733.method_45602(ctx, (String)"item", (class_5321)class_7924.field_41197).comp_349();
        long startNanos = System.nanoTime();
        CompressionManager.getOrCreateNode(item);
        long durationNanos = System.nanoTime() - startNanos;
        double duration = (double)durationNanos / 1.0E9;
        ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43470((String)("Built compression graph for " + String.valueOf(class_7923.field_41178.method_10221((Object)item)) + " in " + duration + "s")), false);
        return 1;
    }

    private static int buildAllCompression(CommandContext<class_2168> ctx) {
        CompressionManager.NODES.clear();
        long startNanos = System.nanoTime();
        for (class_1792 item : class_7923.field_41178) {
            CompressionManager.getOrCreateNode(item);
        }
        long durationNanos = System.nanoTime() - startNanos;
        double duration = (double)durationNanos / 1.0E9;
        ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43470((String)("Rebuilt all compression graph nodes in " + duration + "s")), false);
        return 1;
    }
}

