/*
 * Decompiled with CFR 0.152.
 */
package com.chyzman.chowl.graph;

import com.chyzman.chowl.graph.GraphStore;
import com.chyzman.chowl.graph.SyncGraphPacket;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.minecraft.class_2338;

@Environment(value=EnvType.CLIENT)
public final class ClientGraphStore
implements GraphStore {
    public static final ClientGraphStore STORE = new ClientGraphStore();
    private final Map<UUID, SyncGraphPacket> graphs = new HashMap<UUID, SyncGraphPacket>();
    private final Long2ObjectMap<UUID> blockToGraph = new Long2ObjectOpenHashMap();

    private ClientGraphStore() {
        ClientPlayConnectionEvents.DISCONNECT.register((handler, client) -> {
            this.graphs.clear();
            this.blockToGraph.clear();
        });
    }

    public static void init() {
    }

    public void insert(SyncGraphPacket packet) {
        this.graphs.put(packet.graphId(), packet);
        for (SyncGraphPacket.Node node : packet.nodes()) {
            this.blockToGraph.put(node.pos().method_10063(), (Object)packet.graphId());
        }
    }

    public void remove(UUID graphId) {
        SyncGraphPacket graph = this.graphs.remove(graphId);
        if (graph == null) {
            return;
        }
        for (SyncGraphPacket.Node node : graph.nodes()) {
            this.blockToGraph.remove(node.pos().method_10063());
        }
    }

    @Override
    public SyncGraphPacket getGraphFor(class_2338 pos) {
        UUID graphId = (UUID)this.blockToGraph.get(pos.method_10063());
        if (graphId == null) {
            return null;
        }
        return this.graphs.get(graphId);
    }
}

