/*
 * Decompiled with CFR 0.152.
 */
package com.chyzman.chowl.graph;

import com.chyzman.chowl.Chowl;
import com.chyzman.chowl.graph.DestroyGraphPacket;
import com.chyzman.chowl.graph.GraphStore;
import com.chyzman.chowl.graph.SyncGraphPacket;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.UUID;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.minecraft.class_1657;
import net.minecraft.class_18;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_7871;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;

public class ServerGraphStore
extends class_18
implements GraphStore {
    private final class_3218 world;
    private final Map<UUID, GraphEntry> graphs = new HashMap<UUID, GraphEntry>();
    private final Long2ObjectMap<UUID> blockToGraph = new Long2ObjectOpenHashMap();
    private final List<UUID> syncRemoves = new ArrayList<UUID>();

    private ServerGraphStore(class_3218 world) {
        this.world = world;
    }

    private ServerGraphStore(class_3218 world, class_2487 tag) {
        this(world);
        class_2499 graphsTag = tag.method_10554("Graphs", 10);
        for (int i = 0; i < graphsTag.size(); ++i) {
            class_2487 graphTag = graphsTag.method_10602(i);
            GraphEntry graph = new GraphEntry(graphTag);
            this.graphs.put(graph.graphId, graph);
        }
    }

    public static ServerGraphStore get(class_3218 world) {
        return (ServerGraphStore)world.method_17983().method_17924(tag -> new ServerGraphStore(world, (class_2487)tag), () -> new ServerGraphStore(world), "chowl_graph");
    }

    public Map<UUID, GraphEntry> graphs() {
        return this.graphs;
    }

    public void syncAllWith(class_3222 player) {
        for (GraphEntry graph : this.graphs.values()) {
            Chowl.CHANNEL.serverHandle((class_1657)player).send((Record)graph.toPacket());
        }
    }

    private void runTasks() {
        for (UUID id : this.syncRemoves) {
            Chowl.CHANNEL.serverHandle((Collection)this.world.method_18456()).send((Record)new DestroyGraphPacket(id));
        }
        this.syncRemoves.clear();
        for (GraphEntry graph : this.graphs.values()) {
            if (!graph.needsSync) continue;
            graph.needsSync = false;
            Chowl.CHANNEL.serverHandle((Collection)this.world.method_18456()).send((Record)graph.toPacket());
        }
    }

    public void clear() {
        this.graphs.clear();
        this.blockToGraph.clear();
    }

    public void tryRemove(class_2338 pos) {
        UUID graphId = (UUID)this.blockToGraph.get(pos.method_10063());
        if (graphId == null) {
            return;
        }
        GraphEntry graph = this.graphs.get(graphId);
        if (graph == null) {
            return;
        }
        GraphNodeEntry node = (GraphNodeEntry)graph.nodes.get(pos.method_10063());
        if (node == null) {
            return;
        }
        graph.removeAndSplitBy(node);
        if (graph.nodes.isEmpty()) {
            this.graphs.remove(graphId);
            graph.syncRemove();
        } else {
            graph.sync();
        }
    }

    public void tryAdd(class_2338 pos, class_2680 state, Set<class_2338> links) {
        UUID graphId = null;
        for (class_2338 link : links) {
            UUID linkGraphId = (UUID)this.blockToGraph.get(link.method_10063());
            if (linkGraphId == null || !this.graphs.containsKey(linkGraphId)) continue;
            graphId = linkGraphId;
            break;
        }
        if (graphId == null) {
            graphId = UUID.randomUUID();
            this.graphs.put(graphId, new GraphEntry(graphId, (Long2ObjectOpenHashMap<GraphNodeEntry>)new Long2ObjectOpenHashMap()));
        }
        GraphEntry graph = this.graphs.get(graphId);
        graph.insert(pos, state, links);
    }

    @Override
    @Nullable
    public GraphEntry getGraphFor(class_2338 pos) {
        UUID graphId = (UUID)this.blockToGraph.get(pos.method_10063());
        if (graphId == null) {
            return null;
        }
        return this.graphs.get(graphId);
    }

    public boolean method_79() {
        return true;
    }

    public class_2487 method_75(class_2487 tag) {
        class_2499 graphsTag = new class_2499();
        tag.method_10566("Graphs", (class_2520)graphsTag);
        for (GraphEntry graph : this.graphs.values()) {
            graphsTag.add((Object)graph.write(new class_2487()));
        }
        return tag;
    }

    static {
        ServerTickEvents.END_WORLD_TICK.register(world -> ServerGraphStore.get(world).runTasks());
    }

    public class GraphEntry
    implements GraphStore.Graph {
        public final UUID graphId;
        public Long2ObjectOpenHashMap<GraphNodeEntry> nodes;
        private boolean needsSync = false;

        public GraphEntry(UUID graphId, Long2ObjectOpenHashMap<GraphNodeEntry> nodes) {
            this.graphId = graphId;
            this.nodes = nodes;
        }

        private GraphEntry(class_2487 tag) {
            this.graphId = tag.method_25926("UUID");
            class_2499 nodesTag = tag.method_10554("Nodes", 10);
            this.nodes = new Long2ObjectOpenHashMap(nodesTag.size());
            for (int i = 0; i < nodesTag.size(); ++i) {
                class_2487 nodeTag = nodesTag.method_10602(i);
                GraphNodeEntry node = GraphNodeEntry.read(nodeTag);
                ServerGraphStore.this.blockToGraph.put(node.pos.method_10063(), (Object)this.graphId);
                this.nodes.put(node.pos.method_10063(), (Object)node);
            }
        }

        public class_2487 write(class_2487 tag) {
            tag.method_25927("UUID", this.graphId);
            class_2499 nodesTag = new class_2499();
            tag.method_10566("Nodes", (class_2520)nodesTag);
            for (GraphNodeEntry node : this.nodes.values()) {
                nodesTag.add((Object)node.write(new class_2487()));
            }
            return tag;
        }

        public void sync() {
            this.needsSync = true;
        }

        public void syncRemove() {
            ServerGraphStore.this.syncRemoves.add(this.graphId);
        }

        public SyncGraphPacket toPacket() {
            ArrayList<SyncGraphPacket.Node> networkNodes = new ArrayList<SyncGraphPacket.Node>();
            for (GraphNodeEntry node : this.nodes.values()) {
                networkNodes.add(new SyncGraphPacket.Node(node.pos(), node.state(), node.links().toLongArray()));
            }
            return new SyncGraphPacket(this.graphId, networkNodes);
        }

        public GraphNodeEntry insert(class_2338 pos, class_2680 state, Set<class_2338> links) {
            GraphNodeEntry entry = new GraphNodeEntry(pos, state, (LongSet)new LongOpenHashSet());
            this.nodes.put(entry.pos.method_10063(), (Object)entry);
            ServerGraphStore.this.blockToGraph.put(pos.method_10063(), (Object)this.graphId);
            for (class_2338 linkPos : links) {
                GraphNodeEntry other;
                GraphEntry linkGraph;
                entry.links.add(linkPos.method_10063());
                UUID linkGraphId = (UUID)ServerGraphStore.this.blockToGraph.get(linkPos.method_10063());
                if (linkGraphId != null && linkGraphId != this.graphId && (linkGraph = ServerGraphStore.this.graphs.get(linkGraphId)) != null) {
                    this.mergeIn(linkGraph);
                }
                if ((other = (GraphNodeEntry)this.nodes.get(linkPos.method_10063())) == null) continue;
                other.links.add(pos.method_10063());
            }
            this.sync();
            return entry;
        }

        public void mergeIn(GraphEntry other) {
            for (GraphNodeEntry node : other.nodes.values()) {
                this.nodes.put(node.pos.method_10063(), (Object)node);
                ServerGraphStore.this.blockToGraph.put(node.pos.method_10063(), (Object)this.graphId);
            }
            ServerGraphStore.this.graphs.values().remove(other);
            other.syncRemove();
        }

        public void removeAndSplitBy(GraphNodeEntry node) {
            this.nodes.remove(node.pos.method_10063());
            ServerGraphStore.this.blockToGraph.remove(node.pos.method_10063());
            for (GraphNodeEntry other : this.nodes.values()) {
                other.links().remove(node.pos().method_10063());
            }
            if (this.nodes.isEmpty()) {
                return;
            }
            ArrayDeque<GraphNodeEntry> queue = new ArrayDeque<GraphNodeEntry>();
            Long2ObjectOpenHashMap<GraphNodeEntry> first = this.bfs((GraphNodeEntry)this.nodes.values().iterator().next(), queue);
            while (!this.nodes.isEmpty()) {
                Long2ObjectOpenHashMap<GraphNodeEntry> graphEntries = this.bfs((GraphNodeEntry)this.nodes.values().iterator().next(), queue);
                GraphEntry graph = new GraphEntry(UUID.randomUUID(), graphEntries);
                for (GraphNodeEntry subEntry : graphEntries.values()) {
                    ServerGraphStore.this.blockToGraph.put(subEntry.pos.method_10063(), (Object)graph.graphId);
                }
                graph.sync();
                ServerGraphStore.this.graphs.put(graph.graphId, graph);
            }
            this.nodes = first;
        }

        private Long2ObjectOpenHashMap<GraphNodeEntry> bfs(GraphNodeEntry from, Queue<GraphNodeEntry> queue) {
            queue.clear();
            queue.add(from);
            Long2ObjectOpenHashMap collected = new Long2ObjectOpenHashMap();
            collected.put(from.pos.method_10063(), (Object)from);
            this.nodes.remove(from.pos.method_10063());
            while (!queue.isEmpty()) {
                GraphNodeEntry entry = queue.remove();
                for (Long link : entry.links) {
                    GraphNodeEntry linked;
                    if (collected.containsKey(link.longValue()) || (linked = (GraphNodeEntry)this.nodes.get(link.longValue())) == null) continue;
                    queue.add(linked);
                    collected.put(link.longValue(), (Object)linked);
                    this.nodes.remove(link.longValue());
                }
            }
            return collected;
        }

        public Collection<GraphNodeEntry> nodes() {
            return this.nodes.values();
        }
    }

    public record GraphNodeEntry(class_2338 pos, class_2680 state, LongSet links) implements GraphStore.GraphNode
    {
        public static GraphNodeEntry read(class_2487 tag) {
            class_2338 pos = class_2338.method_10092((long)tag.method_10537("Pos"));
            class_2680 state = class_2512.method_10681((class_7871)class_7923.field_41175.method_46771(), (class_2487)tag.method_10562("State"));
            LongOpenHashSet links = new LongOpenHashSet(tag.method_10565("Links"));
            return new GraphNodeEntry(pos, state, (LongSet)links);
        }

        public class_2487 write(class_2487 tag) {
            tag.method_10544("Pos", this.pos.method_10063());
            tag.method_10566("State", (class_2520)class_2512.method_10686((class_2680)this.state));
            tag.method_10564("Links", this.links.toLongArray());
            return tag;
        }
    }
}

