/*
 * Decompiled with CFR 0.152.
 */
package com.chyzman.chowl.item;

import com.chyzman.chowl.Chowl;
import com.chyzman.chowl.block.DrawerFrameBlockEntity;
import com.chyzman.chowl.block.button.BlockButton;
import com.chyzman.chowl.item.BasePanelItem;
import com.chyzman.chowl.item.component.DisplayingPanelItem;
import com.chyzman.chowl.item.component.FilteringPanelItem;
import com.chyzman.chowl.item.component.LockablePanelItem;
import com.chyzman.chowl.item.component.PanelItem;
import com.chyzman.chowl.item.component.StoragePanelItem;
import com.chyzman.chowl.item.component.UpgradeablePanelItem;
import com.chyzman.chowl.registry.ChowlRegistry;
import com.chyzman.chowl.transfer.BigSingleSlotStorage;
import com.chyzman.chowl.transfer.CompressingStorage;
import com.chyzman.chowl.transfer.InitialCompressingStorage;
import com.chyzman.chowl.transfer.PanelStorage;
import com.chyzman.chowl.transfer.PanelStorageContext;
import com.chyzman.chowl.util.CompressionManager;
import com.chyzman.chowl.util.NbtKeyTypes;
import com.chyzman.chowl.util.VariantUtils;
import io.wispforest.owo.nbt.NbtKey;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.item.PlayerInventoryStorage;
import net.fabricmc.fabric.api.transfer.v1.storage.SlottedStorage;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageUtil;
import net.fabricmc.fabric.api.transfer.v1.storage.base.CombinedSlottedStorage;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2350;
import net.minecraft.class_2378;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;

public class CompressingPanelItem
extends BasePanelItem
implements FilteringPanelItem,
LockablePanelItem,
DisplayingPanelItem,
StoragePanelItem,
UpgradeablePanelItem {
    public static final NbtKey<class_1792> ITEM = new NbtKey("Variant", NbtKey.Type.ofRegistry((class_2378)class_7923.field_41178));
    public static final NbtKey<BigInteger> COUNT = new NbtKey("Count", NbtKeyTypes.BIG_INTEGER);
    public static final NbtKey<Boolean> LOCKED = new NbtKey("Locked", NbtKey.Type.BOOLEAN);

    public CompressingPanelItem(class_1792.class_1793 settings) {
        super(settings);
    }

    @Override
    public ItemVariant currentFilter(class_1799 stack) {
        return ItemVariant.of((class_1935)((class_1935)stack.getOr(ITEM, (Object)class_1802.field_8162)));
    }

    @Override
    public boolean canSetFilter(class_1799 stack, ItemVariant to) {
        if (to.getNbt() != null && !to.getNbt().method_33133()) {
            return false;
        }
        return ((BigInteger)stack.getOr(COUNT, (Object)BigInteger.ZERO)).signum() == 0;
    }

    @Override
    public void setFilter(class_1799 stack, ItemVariant newFilter) {
        class_1792 baseNew = CompressionManager.followDown(newFilter.getItem()).item();
        stack.put(ITEM, (Object)baseNew);
        stack.put(LOCKED, (Object)(baseNew != class_1802.field_8162 ? 1 : 0));
    }

    @Override
    public boolean locked(class_1799 stack) {
        return (Boolean)stack.getOr(LOCKED, (Object)false);
    }

    @Override
    public void setLocked(class_1799 stack, boolean locked) {
        stack.put(LOCKED, (Object)locked);
        if (!locked && ((BigInteger)stack.getOr(COUNT, (Object)BigInteger.ZERO)).equals(BigInteger.ZERO)) {
            stack.put(ITEM, (Object)class_1802.field_8162);
        }
    }

    @Override
    public List<BlockButton> listButtons(DrawerFrameBlockEntity drawerFrame, class_2350 side, class_1799 stack) {
        ArrayList<BlockButton> returned = new ArrayList<BlockButton>();
        ArrayList<class_1799> stacks = new ArrayList<class_1799>();
        stacks.add(new class_1799((class_1935)stack.getOr(ITEM, (Object)class_1802.field_8162)));
        CompressionManager.Node node = CompressionManager.getOrCreateNode((class_1792)stack.getOr(ITEM, (Object)class_1802.field_8162));
        while (node.next != null) {
            node = node.next;
            stacks.add(node.item.method_7854());
        }
        double gridSize = Math.ceil(Math.sqrt(stacks.size()));
        int i = 0;
        while ((double)i < gridSize * gridSize) {
            double scale = 12.0 / gridSize;
            float x = (float)(scale * ((double)i % gridSize));
            float y = (float)(scale * (gridSize - 1.0 - (double)((int)((double)i / gridSize))));
            int finalI = i++;
            returned.add(PanelItem.buttonBuilder(2.0f + x, 2.0f + y, (float)((double)(2.0f + x) + scale), (float)((double)(2.0f + y) + scale)).onUse((world, frame, useSide, useStack, player, hand) -> {
                class_1799 stackInHand = player.method_5998(hand);
                if (stackInHand.method_7960()) {
                    return class_1269.field_5811;
                }
                class_1792 patt0$temp = stack.method_7909();
                if (!(patt0$temp instanceof PanelItem)) {
                    return class_1269.field_5811;
                }
                PanelItem panel = (PanelItem)patt0$temp;
                if (world.field_9236) {
                    return class_1269.field_5812;
                }
                SlottedStorage<ItemVariant> storage = panel.getStorage(PanelStorageContext.from(frame, side));
                try (Transaction tx = Transaction.openOuter();){
                    long moved = StorageUtil.move((Storage)PlayerInventoryStorage.of((class_1657)player).getHandSlot(hand), storage, variant -> true, (long)stackInHand.method_7947(), (TransactionContext)tx);
                    player.method_7339(ChowlRegistry.ITEMS_INSERTED_STAT, (int)moved);
                    tx.commit();
                }
                return class_1269.field_5812;
            }).onAttack((world, attackedDrawerFrame, attackedSide, attackedStack, player) -> {
                if (stacks.size() <= finalI) {
                    return class_1269.field_5814;
                }
                if (this.canExtractFromButton()) {
                    SlottedStorage<ItemVariant> storage = this.getStorage(PanelStorageContext.from(drawerFrame, side));
                    if (storage == null) {
                        return class_1269.field_5814;
                    }
                    if (world.field_9236) {
                        return class_1269.field_5812;
                    }
                    try (Transaction tx = Transaction.openOuter();){
                        long extracted;
                        ItemVariant resource = ItemVariant.of((class_1799)((class_1799)stacks.get(finalI)));
                        if (resource != null && (extracted = storage.extract((Object)resource, player.method_5715() ? (long)resource.toStack().method_7914() : 1L, (TransactionContext)tx)) > 0L) {
                            PlayerInventoryStorage.of((class_1657)player).offerOrDrop(resource, extracted, (TransactionContext)tx);
                            player.method_7339(ChowlRegistry.ITEMS_EXTRACTED_STAT, (int)extracted);
                            tx.commit();
                            class_1269 class_12692 = class_1269.field_5812;
                            return class_12692;
                        }
                    }
                    if (((BigInteger)stack.getOr(COUNT, (Object)BigInteger.ZERO)).compareTo(BigInteger.ZERO) > 0) {
                        return class_1269.field_5814;
                    }
                }
                player.method_31548().method_7398(stack);
                drawerFrame.stacks.set(side.method_10146(), DrawerFrameBlockEntity.SideState.empty());
                drawerFrame.method_5431();
                return class_1269.field_5812;
            }).onDoubleClick((world, clickedFrame, clickedSide, clickedStack, player) -> {
                SlottedStorage<ItemVariant> storage = this.getStorage(PanelStorageContext.from(clickedFrame, side));
                if (storage == null) {
                    return class_1269.field_5814;
                }
                if (this.currentFilter(stack).isBlank()) {
                    return class_1269.field_5814;
                }
                if (world.field_9236) {
                    return class_1269.field_5812;
                }
                try (Transaction tx = Transaction.openOuter();){
                    long moved = StorageUtil.move((Storage)PlayerInventoryStorage.of((class_1657)player), storage, variant -> true, (long)Long.MAX_VALUE, (TransactionContext)tx);
                    player.method_7339(ChowlRegistry.ITEMS_INSERTED_STAT, (int)moved);
                    tx.commit();
                    class_1269 class_12692 = class_1269.field_5812;
                    return class_12692;
                }
            }).build());
        }
        return returned;
    }

    @Override
    @Nullable
    public SlottedStorage<ItemVariant> getStorage(PanelStorageContext ctx) {
        ArrayList<Object> storages = new ArrayList<Object>();
        BaseStorage base = new BaseStorage(ctx);
        storages.add(base);
        int steps = CompressionManager.followUp(base.getResource().getItem()).totalSteps();
        for (int i = 0; i < steps; ++i) {
            storages.add(new CompressingStorage(base, i + 1));
        }
        if (steps == 0) {
            storages.add(new InitialCompressingStorage(base));
        }
        return new CombinedSlottedStorage(storages);
    }

    @Override
    public boolean hasConfig() {
        return true;
    }

    @Override
    public boolean hasComparatorOutput() {
        return true;
    }

    @Override
    public BigInteger baseCapacity() {
        return new BigInteger(Chowl.CHOWL_CONFIG.base_compressing_panel_capacity());
    }

    @Override
    public BigInteger capacity(class_1799 panel) {
        return StoragePanelItem.super.capacity(panel);
    }

    @Override
    public BigInteger fullCapacity(class_1799 stack) {
        return this.capacity(stack).multiply(CompressionManager.followUp((class_1792)stack.getOr(ITEM, (Object)class_1802.field_8162)).totalMultiplier());
    }

    @Override
    public BigInteger count(class_1799 stack) {
        return (BigInteger)stack.getOr(COUNT, (Object)BigInteger.ZERO);
    }

    @Override
    public void setCount(class_1799 stack, BigInteger count) {
        stack.put(COUNT, (Object)count);
    }

    private class BaseStorage
    extends PanelStorage
    implements BigSingleSlotStorage<ItemVariant> {
        public BaseStorage(PanelStorageContext ctx) {
            super(ctx);
        }

        @Override
        public BigInteger bigInsert(ItemVariant resource, BigInteger maxAmount, TransactionContext transaction) {
            if (VariantUtils.hasNbt(resource)) {
                return BigInteger.ZERO;
            }
            if (CompressionManager.getOrCreateNode((class_1792)resource.getItem()).previous != null) {
                return BigInteger.ZERO;
            }
            class_1792 contained = (class_1792)this.ctx.stack().getOr(ITEM, (Object)class_1802.field_8162);
            if (contained == class_1802.field_8162) {
                contained = resource.getItem();
            }
            if (contained != resource.getItem()) {
                return BigInteger.ZERO;
            }
            this.updateSnapshots(transaction);
            this.ctx.stack().put(ITEM, (Object)contained);
            BigInteger currentCount = (BigInteger)this.ctx.stack().getOr(COUNT, (Object)BigInteger.ZERO);
            BigInteger capacity = this.bigCapacity();
            BigInteger spaceLeft = capacity.subtract(currentCount).max(BigInteger.ZERO);
            BigInteger inserted = spaceLeft.min(maxAmount);
            this.ctx.stack().put(COUNT, (Object)currentCount.add(inserted));
            class_1792 finalContained = contained;
            if (CompressingPanelItem.this.hasUpgrade(this.ctx.stack(), upgrade -> upgrade.method_31573(Chowl.VOID_UPGRADE_TAG) || !finalContained.method_24358() && upgrade.method_31573(Chowl.LAVA_UPGRADE_TAG))) {
                return maxAmount;
            }
            return inserted;
        }

        @Override
        public BigInteger bigExtract(ItemVariant resource, BigInteger maxAmount, TransactionContext tx) {
            if (VariantUtils.hasNbt(resource)) {
                return BigInteger.ZERO;
            }
            class_1792 contained = (class_1792)this.ctx.stack().getOr(ITEM, (Object)class_1802.field_8162);
            if (contained == class_1802.field_8162) {
                return BigInteger.ZERO;
            }
            if (contained != resource.getItem()) {
                return BigInteger.ZERO;
            }
            BigInteger currentCount = (BigInteger)this.ctx.stack().getOr(COUNT, (Object)BigInteger.ZERO);
            BigInteger removed = currentCount.min(maxAmount);
            BigInteger newCount = currentCount.subtract(removed);
            this.updateSnapshots(tx);
            this.ctx.stack().put(COUNT, (Object)newCount);
            if (newCount.equals(BigInteger.ZERO)) {
                if (!((Boolean)this.ctx.stack().getOr(LOCKED, (Object)false)).booleanValue()) {
                    this.ctx.stack().put(ITEM, (Object)class_1802.field_8162);
                }
                this.needsEmptiedEvent = true;
            }
            return removed;
        }

        public boolean isResourceBlank() {
            return this.getResource().isBlank();
        }

        public ItemVariant getResource() {
            return ItemVariant.of((class_1935)((class_1935)this.ctx.stack().getOr(ITEM, (Object)class_1802.field_8162)));
        }

        @Override
        public BigInteger bigAmount() {
            return (BigInteger)this.ctx.stack().getOr(COUNT, (Object)BigInteger.ZERO);
        }

        @Override
        public BigInteger bigCapacity() {
            return CompressingPanelItem.this.fullCapacity(this.ctx.stack());
        }
    }
}

