/*
 * Decompiled with CFR 0.152.
 */
package com.chyzman.chowl.item;

import com.chyzman.chowl.Chowl;
import com.chyzman.chowl.block.DrawerFrameBlockEntity;
import com.chyzman.chowl.block.button.BlockButton;
import com.chyzman.chowl.item.BasePanelItem;
import com.chyzman.chowl.item.component.DisplayingPanelItem;
import com.chyzman.chowl.item.component.FilteringPanelItem;
import com.chyzman.chowl.item.component.LockablePanelItem;
import com.chyzman.chowl.item.component.PanelItem;
import com.chyzman.chowl.item.component.StoragePanelItem;
import com.chyzman.chowl.item.component.UpgradeablePanelItem;
import com.chyzman.chowl.transfer.BigSingleSlotStorage;
import com.chyzman.chowl.transfer.PanelStorage;
import com.chyzman.chowl.transfer.PanelStorageContext;
import com.chyzman.chowl.util.NbtKeyTypes;
import io.wispforest.owo.nbt.NbtKey;
import java.math.BigInteger;
import java.util.List;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.SlottedStorage;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2350;
import org.jetbrains.annotations.Nullable;

public class DrawerPanelItem
extends BasePanelItem
implements PanelItem,
FilteringPanelItem,
LockablePanelItem,
DisplayingPanelItem,
UpgradeablePanelItem,
StoragePanelItem {
    public static final NbtKey<ItemVariant> VARIANT = new NbtKey("Variant", NbtKeyTypes.ITEM_VARIANT);
    public static final NbtKey<BigInteger> COUNT = new NbtKey("Count", NbtKeyTypes.BIG_INTEGER);
    public static final NbtKey<Boolean> LOCKED = new NbtKey("Locked", NbtKey.Type.BOOLEAN);

    public DrawerPanelItem(class_1792.class_1793 settings) {
        super(settings);
    }

    @Override
    @Nullable
    public SlottedStorage<ItemVariant> getStorage(PanelStorageContext ctx) {
        return new Storage(ctx);
    }

    @Override
    public List<BlockButton> listButtons(DrawerFrameBlockEntity drawerFrame, class_2350 side, class_1799 stack) {
        return List.of(STORAGE_BUTTON);
    }

    @Override
    public boolean hasConfig() {
        return true;
    }

    @Override
    public ItemVariant currentFilter(class_1799 stack) {
        return (ItemVariant)stack.getOr(VARIANT, (Object)ItemVariant.blank());
    }

    @Override
    public boolean canSetFilter(class_1799 stack, ItemVariant to) {
        return ((BigInteger)stack.getOr(COUNT, (Object)BigInteger.ZERO)).signum() == 0;
    }

    @Override
    public void setFilter(class_1799 stack, ItemVariant newFilter) {
        stack.put(VARIANT, (Object)newFilter);
        stack.put(LOCKED, (Object)(!newFilter.equals((Object)ItemVariant.blank()) ? 1 : 0));
    }

    @Override
    public boolean locked(class_1799 stack) {
        return (Boolean)stack.getOr(LOCKED, (Object)false);
    }

    @Override
    public void setLocked(class_1799 stack, boolean locked) {
        stack.put(LOCKED, (Object)locked);
        if (!locked && ((BigInteger)stack.getOr(COUNT, (Object)BigInteger.ZERO)).equals(BigInteger.ZERO)) {
            stack.put(VARIANT, (Object)ItemVariant.blank());
        }
    }

    @Override
    public boolean hasComparatorOutput() {
        return true;
    }

    @Override
    public BigInteger baseCapacity() {
        return new BigInteger(Chowl.CHOWL_CONFIG.base_panel_capacity());
    }

    @Override
    public BigInteger count(class_1799 stack) {
        return (BigInteger)stack.getOr(COUNT, (Object)BigInteger.ZERO);
    }

    @Override
    public void setCount(class_1799 stack, BigInteger count) {
        stack.put(COUNT, (Object)count);
    }

    private class Storage
    extends PanelStorage
    implements BigSingleSlotStorage<ItemVariant> {
        public Storage(PanelStorageContext ctx) {
            super(ctx);
        }

        @Override
        public BigInteger bigInsert(ItemVariant resource, BigInteger maxAmount, TransactionContext transaction) {
            ItemVariant contained = (ItemVariant)this.ctx.stack().getOr(VARIANT, (Object)ItemVariant.blank());
            if (contained.isBlank()) {
                contained = resource;
            }
            if (!contained.equals((Object)resource)) {
                return BigInteger.ZERO;
            }
            BigInteger currentCount = (BigInteger)this.ctx.stack().getOr(COUNT, (Object)BigInteger.ZERO);
            BigInteger capacity = DrawerPanelItem.this.capacity(this.ctx.stack());
            BigInteger spaceLeft = capacity.subtract(currentCount).max(BigInteger.ZERO);
            BigInteger inserted = spaceLeft.min(maxAmount);
            this.updateSnapshots(transaction);
            this.ctx.stack().put(VARIANT, (Object)contained);
            this.ctx.stack().put(COUNT, (Object)currentCount.add(inserted));
            ItemVariant finalContained = contained;
            if (DrawerPanelItem.this.hasUpgrade(this.ctx.stack(), upgrade -> upgrade.method_31573(Chowl.VOID_UPGRADE_TAG) || !finalContained.getItem().method_24358() && upgrade.method_31573(Chowl.LAVA_UPGRADE_TAG))) {
                return maxAmount;
            }
            return inserted;
        }

        @Override
        public BigInteger bigExtract(ItemVariant resource, BigInteger maxAmount, TransactionContext tx) {
            ItemVariant contained = (ItemVariant)this.ctx.stack().getOr(VARIANT, (Object)ItemVariant.blank());
            if (contained.isBlank()) {
                return BigInteger.ZERO;
            }
            if (!contained.equals((Object)resource)) {
                return BigInteger.ZERO;
            }
            BigInteger currentCount = (BigInteger)this.ctx.stack().getOr(COUNT, (Object)BigInteger.ZERO);
            BigInteger removed = currentCount.min(maxAmount);
            BigInteger newCount = currentCount.subtract(removed);
            this.updateSnapshots(tx);
            this.ctx.stack().put(COUNT, (Object)newCount);
            if (newCount.compareTo(BigInteger.ZERO) <= 0) {
                if (!((Boolean)this.ctx.stack().getOr(LOCKED, (Object)false)).booleanValue()) {
                    this.ctx.stack().put(VARIANT, (Object)ItemVariant.blank());
                }
                this.needsEmptiedEvent = true;
            }
            return removed;
        }

        public boolean isResourceBlank() {
            return this.getResource().isBlank();
        }

        public ItemVariant getResource() {
            return (ItemVariant)this.ctx.stack().getOr(VARIANT, (Object)ItemVariant.blank());
        }

        @Override
        public BigInteger bigAmount() {
            return (BigInteger)this.ctx.stack().getOr(COUNT, (Object)BigInteger.ZERO);
        }

        @Override
        public BigInteger bigCapacity() {
            return DrawerPanelItem.this.capacity(this.ctx.stack());
        }
    }
}

