/*
 * Decompiled with CFR 0.152.
 */
package com.chyzman.chowl.item.component;

import com.chyzman.chowl.block.DrawerFrameBlockEntity;
import com.chyzman.chowl.block.button.BlockButton;
import com.chyzman.chowl.block.button.BlockButtonBuilder;
import com.chyzman.chowl.block.button.ButtonRenderCondition;
import com.chyzman.chowl.block.button.ButtonRenderer;
import com.chyzman.chowl.registry.ChowlRegistry;
import com.chyzman.chowl.screen.PanelConfigSreenHandler;
import com.chyzman.chowl.transfer.PanelStorageContext;
import com.chyzman.chowl.util.BlockSideUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import net.fabricmc.fabric.api.screenhandler.v1.ExtendedScreenHandlerFactory;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.item.PlayerInventoryStorage;
import net.fabricmc.fabric.api.transfer.v1.storage.SlottedStorage;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageUtil;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageView;
import net.fabricmc.fabric.api.transfer.v1.storage.base.CombinedSlottedStorage;
import net.fabricmc.fabric.api.transfer.v1.storage.base.SingleSlotStorage;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3222;
import net.minecraft.class_3908;
import net.minecraft.class_3965;
import org.jetbrains.annotations.Nullable;

public interface PanelItem {
    public static final BlockButton STORAGE_BUTTON = new ButtonBuilder(2.0f, 2.0f, 14.0f, 14.0f).onUse((world, frame, side, stack, player, hand) -> {
        class_1799 stackInHand = player.method_5998(hand);
        if (stackInHand.method_7960()) {
            return class_1269.field_5811;
        }
        class_1792 patt0$temp = stack.method_7909();
        if (!(patt0$temp instanceof PanelItem)) {
            return class_1269.field_5811;
        }
        PanelItem panel = (PanelItem)patt0$temp;
        if (world.field_9236) {
            return class_1269.field_5812;
        }
        SlottedStorage<ItemVariant> storage = panel.getStorage(PanelStorageContext.from(frame, side));
        try (Transaction tx = Transaction.openOuter();){
            long moved = StorageUtil.move((Storage)PlayerInventoryStorage.of((class_1657)player).getHandSlot(hand), storage, variant -> true, (long)stackInHand.method_7947(), (TransactionContext)tx);
            player.method_7339(ChowlRegistry.ITEMS_INSERTED_STAT, (int)moved);
            tx.commit();
        }
        return class_1269.field_5812;
    }).onAttack((world, drawerFrame, side, stack, player) -> {
        PanelItem panel = (PanelItem)stack.method_7909();
        if (panel.canExtractFromButton()) {
            SlottedStorage<ItemVariant> storage = panel.getStorage(PanelStorageContext.from(drawerFrame, side));
            if (storage == null) {
                return class_1269.field_5814;
            }
            if (world.field_9236) {
                return class_1269.field_5812;
            }
            try (Transaction tx = Transaction.openOuter();){
                long extracted;
                ItemVariant resource = (ItemVariant)StorageUtil.findExtractableResource(storage, (TransactionContext)tx);
                if (resource != null && (extracted = storage.extract((Object)resource, player.method_5715() ? (long)resource.toStack().method_7914() : 1L, (TransactionContext)tx)) > 0L) {
                    PlayerInventoryStorage.of((class_1657)player).offerOrDrop(resource, extracted, (TransactionContext)tx);
                    player.method_7339(ChowlRegistry.ITEMS_EXTRACTED_STAT, (int)extracted);
                    tx.commit();
                    class_1269 class_12692 = class_1269.field_5812;
                    return class_12692;
                }
            }
        }
        player.method_31548().method_7398(stack);
        drawerFrame.stacks.set(side.method_10146(), DrawerFrameBlockEntity.SideState.empty());
        drawerFrame.method_5431();
        return class_1269.field_5812;
    }).onDoubleClick((world, frame, side, stack, player) -> {
        PanelItem panel = (PanelItem)stack.method_7909();
        SlottedStorage<ItemVariant> storage = panel.getStorage(PanelStorageContext.from(frame, side));
        if (storage == null) {
            return class_1269.field_5814;
        }
        ArrayList<SingleSlotStorage> slots = new ArrayList<SingleSlotStorage>(storage.getSlots());
        slots.removeIf(StorageView::isResourceBlank);
        if (slots.isEmpty()) {
            return class_1269.field_5814;
        }
        if (world.field_9236) {
            return class_1269.field_5812;
        }
        try (Transaction tx = Transaction.openOuter();){
            long moved = StorageUtil.move((Storage)PlayerInventoryStorage.of((class_1657)player), (Storage)new CombinedSlottedStorage(slots), variant -> true, (long)Long.MAX_VALUE, (TransactionContext)tx);
            player.method_7339(ChowlRegistry.ITEMS_INSERTED_STAT, (int)moved);
            tx.commit();
            class_1269 class_12692 = class_1269.field_5812;
            return class_12692;
        }
    }).build();

    @Nullable
    public SlottedStorage<ItemVariant> getStorage(PanelStorageContext var1);

    @Nullable
    default public SlottedStorage<ItemVariant> getNetworkStorage(PanelStorageContext ctx) {
        return this.getStorage(ctx);
    }

    default public List<BlockButton> listButtons(DrawerFrameBlockEntity drawerFrame, class_2350 side, class_1799 stack) {
        return Collections.emptyList();
    }

    default public boolean canExtractFromButton() {
        return true;
    }

    default public boolean hasConfig() {
        return false;
    }

    default public boolean hasComparatorOutput() {
        return false;
    }

    default public void openConfig(final class_1799 stack, class_1657 user, final @Nullable Consumer<class_1799> updater) {
        ExtendedScreenHandlerFactory factory = new ExtendedScreenHandlerFactory(){

            public class_1703 createMenu(int syncId, class_1661 playerInventory, class_1657 player) {
                return new PanelConfigSreenHandler(syncId, playerInventory, stack, updater);
            }

            public class_2561 method_5476() {
                return class_2561.method_43471((String)"container.chowl.panel_config.title");
            }

            public void writeScreenOpeningData(class_3222 player, class_2540 buf) {
                buf.method_10793(stack);
            }
        };
        user.method_17355((class_3908)factory);
    }

    public static ButtonBuilder buttonBuilder(float minX, float minY, float maxX, float maxY) {
        return new ButtonBuilder(minX, minY, maxX, maxY);
    }

    public static class ButtonBuilder {
        private final BlockButtonBuilder wrapped;

        ButtonBuilder(float minX, float minY, float maxX, float maxY) {
            this.wrapped = BlockButton.builder(minX, minY, maxX, maxY);
        }

        public ButtonBuilder onUse(UseFunction use) {
            this.wrapped.onUse((class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) -> {
                class_2586 patt0$temp = world.method_8321(pos);
                if (!(patt0$temp instanceof DrawerFrameBlockEntity)) {
                    return class_1269.field_5811;
                }
                DrawerFrameBlockEntity drawerFrame = (DrawerFrameBlockEntity)patt0$temp;
                class_2350 side = BlockSideUtils.getSide(hit);
                return use.onUse(world, drawerFrame, side, drawerFrame.stacks.get((int)side.method_10146()).stack, player, hand);
            });
            return this;
        }

        public ButtonBuilder onAttack(AttackFunction attack) {
            this.wrapped.onAttack((class_1937 world, class_2680 state, class_3965 hit, class_1657 player) -> {
                class_2338 pos = hit.method_17777();
                class_2350 side = BlockSideUtils.getSide(hit);
                class_2586 patt0$temp = world.method_8321(pos);
                if (!(patt0$temp instanceof DrawerFrameBlockEntity)) {
                    return class_1269.field_5811;
                }
                DrawerFrameBlockEntity drawerFrame = (DrawerFrameBlockEntity)patt0$temp;
                return attack.onAttack(world, drawerFrame, side, drawerFrame.stacks.get((int)side.method_10146()).stack, player);
            });
            return this;
        }

        public ButtonBuilder onDoubleClick(DoubleClickFunction doubleClick) {
            this.wrapped.onDoubleClick((class_1937 world, class_2680 state, class_3965 hit, class_1657 player) -> {
                class_2338 pos = hit.method_17777();
                class_2350 side = BlockSideUtils.getSide(hit);
                class_2586 patt0$temp = world.method_8321(pos);
                if (!(patt0$temp instanceof DrawerFrameBlockEntity)) {
                    return class_1269.field_5811;
                }
                DrawerFrameBlockEntity drawerFrame = (DrawerFrameBlockEntity)patt0$temp;
                return doubleClick.onDoubleClick(world, drawerFrame, side, drawerFrame.stacks.get((int)side.method_10146()).stack, player);
            });
            return this;
        }

        public ButtonBuilder renderWhen(ButtonRenderCondition condition) {
            this.wrapped.renderWhen(condition);
            return this;
        }

        public ButtonBuilder renderer(ButtonRenderer renderer) {
            this.wrapped.renderer(renderer);
            return this;
        }

        public BlockButton build() {
            return this.wrapped.build();
        }

        @FunctionalInterface
        public static interface UseFunction {
            public class_1269 onUse(class_1937 var1, DrawerFrameBlockEntity var2, class_2350 var3, class_1799 var4, class_1657 var5, class_1268 var6);
        }

        @FunctionalInterface
        public static interface AttackFunction {
            public class_1269 onAttack(class_1937 var1, DrawerFrameBlockEntity var2, class_2350 var3, class_1799 var4, class_1657 var5);
        }

        @FunctionalInterface
        public static interface DoubleClickFunction {
            public class_1269 onDoubleClick(class_1937 var1, DrawerFrameBlockEntity var2, class_2350 var3, class_1799 var4, class_1657 var5);
        }
    }
}

