/*
 * Decompiled with CFR 0.152.
 */
package com.chyzman.chowl.item.renderer;

import com.chyzman.chowl.Chowl;
import com.chyzman.chowl.client.RenderGlobals;
import com.chyzman.chowl.item.component.DisplayingPanelItem;
import com.chyzman.chowl.item.component.UpgradeablePanelItem;
import com.chyzman.chowl.transfer.BigStorageView;
import com.chyzman.chowl.transfer.FakeStorageView;
import com.chyzman.chowl.transfer.PanelStorageContext;
import com.chyzman.chowl.upgrade.LabelingUpgrade;
import com.chyzman.chowl.util.FormatUtil;
import com.chyzman.chowl.util.InfallibleCloseable;
import com.chyzman.chowl.util.ItemScalingUtil;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import java.util.ArrayList;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.rendering.v1.BuiltinItemRendererRegistry;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.SlottedStorage;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageView;
import net.minecraft.class_1087;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_7833;
import net.minecraft.class_811;

@Environment(value=EnvType.CLIENT)
public class GenericPanelItemRenderer
implements BuiltinItemRendererRegistry.DynamicItemRenderer {
    public static final float MAX_WIDTH = 30.0f;
    private final class_2960 baseModelId;

    public GenericPanelItemRenderer(class_2960 baseModelId) {
        this.baseModelId = baseModelId;
    }

    public void render(class_1799 stack, class_811 mode, class_4587 matrices, class_4597 vertexConsumers, int light, int overlay) {
        if (!RenderGlobals.shouldRender()) {
            return;
        }
        try (InfallibleCloseable ignored = RenderGlobals.enterRender();){
            class_1087 baseModel;
            class_1792 class_17922;
            class_310 client = class_310.method_1551();
            matrices.method_22904(0.5, 0.5, 0.5);
            matrices.method_22907(class_7833.field_40715.rotationDegrees(180.0f));
            if (!RenderGlobals.IN_FRAME && (class_17922 = stack.method_7909()) instanceof UpgradeablePanelItem) {
                UpgradeablePanelItem upgradeable = (UpgradeablePanelItem)class_17922;
                int orientation = LabelingUpgrade.rotateOrientationForEasterEggs(0, upgradeable.upgrades(stack));
                matrices.method_22907(class_7833.field_40718.rotationDegrees((float)(90 * orientation)));
            }
            if ((baseModel = client.method_1554().getModel(this.baseModelId)) != null && RenderGlobals.BAKED.get() != Boolean.TRUE) {
                client.method_1480().method_23179(stack, class_811.field_4319, false, matrices, vertexConsumers, light, overlay, baseModel);
            }
            this.drawDisplay(stack, mode, matrices, vertexConsumers, light, overlay);
        }
    }

    protected void drawDisplay(class_1799 stack, class_811 mode, class_4587 matrices, class_4597 vertexConsumers, int light, int overlay) {
        UpgradeablePanelItem upgradeable;
        class_310 client = class_310.method_1551();
        class_1792 class_17922 = stack.method_7909();
        if (!(class_17922 instanceof DisplayingPanelItem)) {
            return;
        }
        DisplayingPanelItem panel = (DisplayingPanelItem)class_17922;
        SlottedStorage<ItemVariant> storage = panel.getStorage(PanelStorageContext.forRendering(stack));
        if (storage == null) {
            return;
        }
        matrices.method_22904(0.0, 0.0, -0.0635);
        matrices.method_22903();
        ArrayList<StorageView> slots = new ArrayList<StorageView>(storage.getSlots());
        slots.removeIf(x -> {
            FakeStorageView fake;
            return x instanceof FakeStorageView && !(fake = (FakeStorageView)x).countInDisplay();
        });
        matrices.method_22905(0.75f, 0.75f, 0.75f);
        double renderScale = 1.0 / Math.ceil(Math.sqrt(slots.size()));
        matrices.method_22904(0.5, 0.5, 0.0);
        matrices.method_22904(-renderScale * 1.5, -renderScale * 1.5, 0.0);
        matrices.method_22905((float)renderScale, (float)renderScale, (float)renderScale);
        DisplayingPanelItem.Config customization = DisplayingPanelItem.getConfig(stack);
        boolean glowing = false;
        class_1792 class_17923 = stack.method_7909();
        if (class_17923 instanceof UpgradeablePanelItem && (upgradeable = (UpgradeablePanelItem)class_17923).hasUpgrade(stack, upgrade -> upgrade.method_31573(Chowl.GLOWING_UPGRADE_TAG))) {
            glowing = true;
        }
        for (int i = 0; i < slots.size(); ++i) {
            StorageView slot = (StorageView)slots.get(i);
            matrices.method_22903();
            matrices.method_22904(1.0 - (double)i % (1.0 / renderScale), (double)(1.0f - (float)((int)((double)i / (1.0 / renderScale)))), 0.0);
            if (slots.size() <= 1) {
                matrices.method_22905(1.3333334f, 1.3333334f, 1.3333334f);
            } else {
                float number = 1.25f;
                matrices.method_22905(number, number, number);
            }
            BigInteger count = BigStorageView.bigAmount(slot);
            if (!slot.isResourceBlank()) {
                class_1799 displayStack = ((ItemVariant)slot.getResource()).toStack();
                ItemScalingUtil.ItemModelProperties properties = ItemScalingUtil.getItemModelProperties(displayStack);
                if (!customization.hideName()) {
                    int titleWidth;
                    UpgradeablePanelItem upgradeable2;
                    matrices.method_22903();
                    matrices.method_22907(class_7833.field_40717.rotationDegrees(180.0f));
                    matrices.method_46416(0.0f, 0.375f, 0.0f);
                    matrices.method_22905(0.025f, 0.025f, 0.025f);
                    AtomicReference<class_5250> title = new AtomicReference<class_5250>((class_5250)displayStack.method_7964());
                    class_1792 class_17924 = stack.method_7909();
                    if (class_17924 instanceof UpgradeablePanelItem && (upgradeable2 = (UpgradeablePanelItem)class_17924).hasUpgrade(stack, upgrade -> upgrade.method_31573(Chowl.LABELING_UPGRADE_TAG))) {
                        upgradeable2.upgrades(stack).stream().filter(upgradeStack -> upgradeStack.method_31573(Chowl.LABELING_UPGRADE_TAG) && upgradeStack.method_7938()).findFirst().ifPresent(upgradeStack -> title.set((class_5250)upgradeStack.method_7964()));
                    }
                    if ((float)(titleWidth = client.field_1772.method_27525((class_5348)title.get())) > 30.0f) {
                        matrices.method_22905(30.0f / (float)titleWidth, 30.0f / (float)titleWidth, 30.0f / (float)titleWidth);
                    }
                    Objects.requireNonNull(client.field_1772);
                    matrices.method_46416(0.0f, (float)(-9) + 1.0f, 0.0f);
                    client.field_1772.method_30882(panel.styleText(stack, (class_2561)title.get()), (float)(-titleWidth) / 2.0f + 0.5f, 0.0f, -1, false, matrices.method_23760().method_23761(), vertexConsumers, class_327.class_6415.field_33993, 0, glowing ? 0xF000F0 : light);
                    matrices.method_22909();
                }
                if (!(count.compareTo(BigInteger.ZERO) <= 0 || customization.hideCount() && customization.hideCapacity())) {
                    int amountWidth;
                    matrices.method_22903();
                    matrices.method_22907(class_7833.field_40717.rotationDegrees(180.0f));
                    matrices.method_46416(0.0f, -0.375f, 0.0f);
                    matrices.method_22905(0.025f, 0.025f, 0.025f);
                    StringBuilder countText = new StringBuilder();
                    if (!customization.hideCount()) {
                        countText.append(count);
                    }
                    if (!customization.hideCapacity()) {
                        if (!customization.hideCount()) {
                            countText.append("/");
                        }
                        countText.append(FormatUtil.formatCount(BigStorageView.bigCapacity(slot)));
                    }
                    if ((float)(amountWidth = client.field_1772.method_1727(countText.toString())) > 30.0f) {
                        matrices.method_22905(30.0f / (float)amountWidth, 30.0f / (float)amountWidth, 30.0f / (float)amountWidth);
                    }
                    client.field_1772.method_30882(panel.styleText(stack, (class_2561)class_2561.method_43470((String)countText.toString())), (float)(-amountWidth) / 2.0f + 0.5f, 0.0f, -1, false, matrices.method_23760().method_23761(), vertexConsumers, class_327.class_6415.field_33993, 0, glowing ? 0xF000F0 : light);
                    matrices.method_22909();
                }
                if (!customization.hideItem()) {
                    float scale = (float)Math.min(2.0, 1.0 / Math.max(properties.size().field_1352, Math.max(properties.size().field_1351, properties.size().field_1350)));
                    matrices.method_22903();
                    matrices.method_22905(scale, scale, scale);
                    scale = 0.75f;
                    matrices.method_22905(scale, scale, scale);
                    if (!customization.hideName()) {
                        matrices.method_46416(0.0f, 0.0078125f, 0.0f);
                    }
                    scale = mode == class_811.field_4317 ? 0.47f : 0.4f;
                    matrices.method_22905(scale, scale, scale);
                    matrices.method_22904(-properties.offset().field_1352, -properties.offset().field_1351, Math.abs(properties.offset().field_1350) > 0.5 ? -properties.offset().field_1350 : 0.0);
                    matrices.method_22903();
                    boolean framed = RenderGlobals.IN_FRAME;
                    RenderGlobals.IN_FRAME = false;
                    client.method_1480().method_23179(displayStack, class_811.field_4319, false, matrices, vertexConsumers, glowing ? 0xF000F0 : light, overlay, client.method_1480().method_4012().method_3308(displayStack));
                    RenderGlobals.IN_FRAME = framed;
                    matrices.method_22909();
                    matrices.method_22909();
                }
            }
            matrices.method_22909();
        }
        matrices.method_22909();
        if (customization.showPercentage() && RenderGlobals.IN_FRAME) {
            double fullPercent = new BigDecimal(BigStorageView.bigAmount((StorageView)slots.get(0))).divide(new BigDecimal(BigStorageView.bigCapacity((StorageView)slots.get(0)).max(BigInteger.ONE)), MathContext.DECIMAL32).multiply(BigDecimal.valueOf(100L)).doubleValue();
            Double roundedPercent = (double)Math.round(fullPercent * 100.0) / 100.0;
            String percent = roundedPercent + "%";
            this.drawPercent(stack, panel, matrices, vertexConsumers, client, percent, glowing, light, overlay);
        }
    }

    protected void drawPercent(class_1799 stack, DisplayingPanelItem panel, class_4587 matrices, class_4597 vertexConsumers, class_310 client, String percent, boolean glowing, int light, int overlay) {
        matrices.method_22903();
        matrices.method_22907(class_7833.field_40717.rotationDegrees(180.0f));
        matrices.method_46416(0.0f, -0.5f, 0.0f);
        matrices.method_22905(0.020833334f, 0.020833334f, 0.020833334f);
        matrices.method_22905(0.5f, 0.5f, 0.5f);
        int percentWidth = client.field_1772.method_1727(percent);
        Objects.requireNonNull(client.field_1772);
        matrices.method_46416(0.0f, 9.0f * 0.25f, 0.0f);
        client.field_1772.method_30882(panel.styleText(stack, (class_2561)class_2561.method_43470((String)percent)), (float)(-percentWidth) / 2.0f + 0.5f, 0.0f, -1, false, matrices.method_23760().method_23761(), vertexConsumers, class_327.class_6415.field_33993, 0, glowing ? 0xF000F0 : light);
        matrices.method_22909();
    }
}

