/*
 * Decompiled with CFR 0.152.
 */
package com.chyzman.chowl.screen;

import com.chyzman.chowl.client.AutoGridLayout;
import com.chyzman.chowl.client.DisableableCheckboxComponent;
import com.chyzman.chowl.item.component.DisplayingPanelItem;
import com.chyzman.chowl.item.component.FilteringPanelItem;
import com.chyzman.chowl.item.component.LockablePanelItem;
import com.chyzman.chowl.item.component.UpgradeablePanelItem;
import com.chyzman.chowl.screen.PanelConfigSreenHandler;
import com.chyzman.chowl.util.ChowlRegistryHelper;
import io.wispforest.owo.ui.base.BaseOwoHandledScreen;
import io.wispforest.owo.ui.component.Components;
import io.wispforest.owo.ui.component.ItemComponent;
import io.wispforest.owo.ui.component.SmallCheckboxComponent;
import io.wispforest.owo.ui.container.Containers;
import io.wispforest.owo.ui.container.FlowLayout;
import io.wispforest.owo.ui.container.GridLayout;
import io.wispforest.owo.ui.core.Component;
import io.wispforest.owo.ui.core.HorizontalAlignment;
import io.wispforest.owo.ui.core.Insets;
import io.wispforest.owo.ui.core.OwoUIAdapter;
import io.wispforest.owo.ui.core.Positioning;
import io.wispforest.owo.ui.core.Sizing;
import io.wispforest.owo.ui.core.Surface;
import io.wispforest.owo.ui.core.VerticalAlignment;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_437;
import org.jetbrains.annotations.NotNull;

public class PanelConfigScreen
extends BaseOwoHandledScreen<FlowLayout, PanelConfigSreenHandler> {
    private FakeSlotComponent filterSlot;
    private DisableableCheckboxComponent lockedCheckbox;
    private SmallCheckboxComponent showCountCheckBox;
    private SmallCheckboxComponent showCapacityCheckBox;
    private SmallCheckboxComponent showItemCheckBox;
    private SmallCheckboxComponent showNameCheckBox;
    private SmallCheckboxComponent showPercentageCheckBox;
    private SmallCheckboxComponent hideUpgradesCheckBox;
    private SmallCheckboxComponent hideButtonsCheckBox;
    private SmallCheckboxComponent ignoreTemplatingCheckBox;
    private boolean ignoreChanges = false;

    public PanelConfigScreen(PanelConfigSreenHandler screenHandler, class_1661 inventory, class_2561 title) {
        super((class_1703)screenHandler, inventory, title);
    }

    @NotNull
    protected OwoUIAdapter<FlowLayout> createAdapter() {
        return OwoUIAdapter.create((class_437)this, Containers::verticalFlow);
    }

    protected void build(FlowLayout rootComponent) {
        Object lockable;
        class_1799 stack = (class_1799)((PanelConfigSreenHandler)this.field_2797).stack.get();
        class_1792 class_17922 = stack.method_7909();
        if (class_17922 instanceof FilteringPanelItem) {
            FilteringPanelItem filtering = (FilteringPanelItem)class_17922;
            this.filterSlot = new FakeSlotComponent(filtering.currentFilter(stack).toStack());
            this.filterSlot.mouseDown().subscribe((mouseX, mouseY, button) -> {
                if (button == 0) {
                    ((PanelConfigSreenHandler)this.field_2797).sendMessage(new PanelConfigSreenHandler.ConfigFilter(((PanelConfigSreenHandler)this.field_2797).method_34255()));
                }
                return true;
            });
            this.filterSlot.setTooltipFromStack(true);
            this.filterSlot.id("filter-slot");
            class_1792 class_17923 = stack.method_7909();
            if (class_17923 instanceof LockablePanelItem) {
                lockable = (LockablePanelItem)class_17923;
                this.lockedCheckbox = new DisableableCheckboxComponent((class_2561)class_2561.method_43471((String)"ui.chowl-industries.config_panel.locked"));
                this.lockedCheckbox.checked(lockable.locked(stack));
                this.lockedCheckbox.onChanged().subscribe(nowChecked -> this.resendConfig());
                this.lockedCheckbox.disabled(filtering.currentFilter(stack).isBlank());
            }
        }
        if ((lockable = stack.method_7909()) instanceof DisplayingPanelItem) {
            DisplayingPanelItem displaying = (DisplayingPanelItem)lockable;
            DisplayingPanelItem.Config config = DisplayingPanelItem.getConfig(stack);
            this.showCountCheckBox = Components.smallCheckbox((class_2561)class_2561.method_43471((String)"ui.chowl-industries.config_panel.show_count"));
            this.showCountCheckBox.checked(!config.hideCount());
            this.showCountCheckBox.onChanged().subscribe(nowChecked -> this.resendConfig());
            this.showCapacityCheckBox = Components.smallCheckbox((class_2561)class_2561.method_43471((String)"ui.chowl-industries.config_panel.show_capacity"));
            this.showCapacityCheckBox.checked(!config.hideCapacity());
            this.showCapacityCheckBox.onChanged().subscribe(nowChecked -> this.resendConfig());
            if (displaying.supportsHideItem()) {
                this.showItemCheckBox = Components.smallCheckbox((class_2561)class_2561.method_43471((String)"ui.chowl-industries.config_panel.show_item"));
                this.showItemCheckBox.checked(!config.hideItem());
                this.showItemCheckBox.onChanged().subscribe(nowChecked -> this.resendConfig());
            }
            if (displaying.supportsHideName()) {
                this.showNameCheckBox = Components.smallCheckbox((class_2561)class_2561.method_43471((String)"ui.chowl-industries.config_panel.show_name"));
                this.showNameCheckBox.checked(!config.hideName());
                this.showNameCheckBox.onChanged().subscribe(nowChecked -> this.resendConfig());
            }
            this.showPercentageCheckBox = Components.smallCheckbox((class_2561)class_2561.method_43471((String)"ui.chowl-industries.config_panel.show_percentage"));
            this.showPercentageCheckBox.checked(config.showPercentage());
            this.showPercentageCheckBox.onChanged().subscribe(nowChecked -> this.resendConfig());
            if (stack.method_7909() instanceof UpgradeablePanelItem) {
                this.hideUpgradesCheckBox = Components.smallCheckbox((class_2561)class_2561.method_43471((String)"ui.chowl-industries.config_panel.hide_upgrades"));
                this.hideUpgradesCheckBox.checked(config.hideUpgrades());
                this.hideUpgradesCheckBox.onChanged().subscribe(nowChecked -> this.resendConfig());
            }
            this.hideButtonsCheckBox = Components.smallCheckbox((class_2561)class_2561.method_43471((String)"ui.chowl-industries.config_panel.hide_buttons"));
            this.hideButtonsCheckBox.checked(config.hideButtons());
            this.hideButtonsCheckBox.onChanged().subscribe(nowChecked -> this.resendConfig());
            this.ignoreTemplatingCheckBox = Components.smallCheckbox((class_2561)class_2561.method_43471((String)"ui.chowl-industries.config_panel.ignore_templating"));
            this.ignoreTemplatingCheckBox.checked(config.ignoreTemplating());
            this.ignoreTemplatingCheckBox.onChanged().subscribe(nowChecked -> this.resendConfig());
        }
        GridLayout inventoryFlow = (GridLayout)Containers.grid((Sizing)Sizing.content(), (Sizing)Sizing.content(), (int)4, (int)9).configure(gridLayout -> {
            gridLayout.margins(Insets.top((int)7));
            for (int i = 0; i < ((PanelConfigSreenHandler)this.field_2797).inventory.field_7547.size(); ++i) {
                BaseOwoHandledScreen.SlotComponent slot = this.slotAsComponent(i);
                slot.margins(Insets.of((int)1));
                if (i > 26) {
                    slot.margins(Insets.of((int)1).withTop(5));
                }
                gridLayout.child((Component)slot, i / 9, i % 9);
                gridLayout.surface(Surface.tiled((class_2960)ChowlRegistryHelper.id("textures/gui/container/inventory.png"), (int)162, (int)76));
            }
        });
        FlowLayout verticalFlow = (FlowLayout)Containers.verticalFlow((Sizing)Sizing.fixed((int)225), (Sizing)Sizing.content()).configure(flowLayout -> {
            flowLayout.surface(Surface.PANEL);
            flowLayout.padding(Insets.of((int)7));
            AutoGridLayout grid = new AutoGridLayout(Sizing.fill((int)100), Sizing.content(), 5, 2);
            flowLayout.child((Component)grid);
            if (this.filterSlot != null) {
                FlowLayout slotFlow = Containers.horizontalFlow((Sizing)Sizing.fill((int)100), (Sizing)Sizing.fixed((int)18));
                slotFlow.margins(Insets.bottom((int)1)).verticalAlignment(VerticalAlignment.CENTER);
                slotFlow.child((Component)this.filterSlot.margins(Insets.of((int)1).withRight(3))).child((Component)Components.texture((class_2960)ChowlRegistryHelper.id("textures/gui/container/slot.png"), (int)0, (int)0, (int)18, (int)18, (int)18, (int)18).positioning(Positioning.absolute((int)0, (int)0))).child((Component)Components.label((class_2561)class_2561.method_43471((String)"ui.chowl-industries.config_panel.filter")));
                grid.child((Component)slotFlow);
            }
            if (this.lockedCheckbox != null) {
                grid.child((Component)((FlowLayout)Containers.horizontalFlow((Sizing)Sizing.fill((int)100), (Sizing)Sizing.fixed((int)18)).configure(flow -> {
                    flow.margins(Insets.bottom((int)1));
                    flow.verticalAlignment(VerticalAlignment.CENTER);
                })).child((Component)this.lockedCheckbox));
            }
            if (this.showCountCheckBox != null) {
                grid.child((Component)((FlowLayout)Containers.horizontalFlow((Sizing)Sizing.fill((int)100), (Sizing)Sizing.fixed((int)18)).configure(flow -> {
                    flow.margins(Insets.bottom((int)1));
                    flow.verticalAlignment(VerticalAlignment.CENTER);
                })).child((Component)this.showCountCheckBox));
            }
            if (this.showCapacityCheckBox != null) {
                grid.child((Component)((FlowLayout)Containers.horizontalFlow((Sizing)Sizing.fill((int)100), (Sizing)Sizing.fixed((int)18)).configure(flow -> {
                    flow.margins(Insets.bottom((int)1));
                    flow.verticalAlignment(VerticalAlignment.CENTER);
                })).child((Component)this.showCapacityCheckBox));
            }
            if (this.showItemCheckBox != null) {
                grid.child((Component)((FlowLayout)Containers.horizontalFlow((Sizing)Sizing.fill((int)100), (Sizing)Sizing.fixed((int)18)).configure(flow -> {
                    flow.margins(Insets.bottom((int)1));
                    flow.verticalAlignment(VerticalAlignment.CENTER);
                })).child((Component)this.showItemCheckBox));
            }
            if (this.showNameCheckBox != null) {
                grid.child((Component)((FlowLayout)Containers.horizontalFlow((Sizing)Sizing.fill((int)100), (Sizing)Sizing.fixed((int)18)).configure(flow -> {
                    flow.margins(Insets.bottom((int)1));
                    flow.verticalAlignment(VerticalAlignment.CENTER);
                })).child((Component)this.showNameCheckBox));
            }
            if (this.showPercentageCheckBox != null) {
                grid.child((Component)((FlowLayout)Containers.horizontalFlow((Sizing)Sizing.fill((int)100), (Sizing)Sizing.fixed((int)18)).configure(flow -> {
                    flow.margins(Insets.bottom((int)1));
                    flow.verticalAlignment(VerticalAlignment.CENTER);
                })).child((Component)this.showPercentageCheckBox));
            }
            if (this.hideUpgradesCheckBox != null) {
                grid.child((Component)((FlowLayout)Containers.horizontalFlow((Sizing)Sizing.fill((int)100), (Sizing)Sizing.fixed((int)18)).configure(flow -> {
                    flow.margins(Insets.bottom((int)1));
                    flow.verticalAlignment(VerticalAlignment.CENTER);
                })).child((Component)this.hideUpgradesCheckBox));
            }
            if (this.hideButtonsCheckBox != null) {
                grid.child((Component)((FlowLayout)Containers.horizontalFlow((Sizing)Sizing.fill((int)100), (Sizing)Sizing.fixed((int)18)).configure(flow -> {
                    flow.margins(Insets.bottom((int)1));
                    flow.verticalAlignment(VerticalAlignment.CENTER);
                })).child((Component)this.hideButtonsCheckBox));
            }
            if (this.ignoreTemplatingCheckBox != null) {
                grid.child((Component)((FlowLayout)Containers.horizontalFlow((Sizing)Sizing.fill((int)100), (Sizing)Sizing.fixed((int)18)).configure(flow -> {
                    flow.margins(Insets.bottom((int)1));
                    flow.verticalAlignment(VerticalAlignment.CENTER);
                })).child((Component)this.ignoreTemplatingCheckBox));
            }
            flowLayout.child((Component)Containers.horizontalFlow((Sizing)Sizing.fill((int)100), (Sizing)Sizing.content()).child((Component)inventoryFlow).horizontalAlignment(HorizontalAlignment.CENTER));
        });
        ((PanelConfigSreenHandler)this.field_2797).stack.observe(newStack -> {
            try {
                this.ignoreChanges = true;
                class_1792 patt0$temp = newStack.method_7909();
                if (patt0$temp instanceof FilteringPanelItem) {
                    FilteringPanelItem filtering = (FilteringPanelItem)patt0$temp;
                    this.filterSlot.stack(filtering.currentFilter((class_1799)newStack).toStack());
                    class_1792 patt1$temp = newStack.method_7909();
                    if (patt1$temp instanceof LockablePanelItem) {
                        LockablePanelItem lockable = (LockablePanelItem)patt1$temp;
                        this.lockedCheckbox.checked(lockable.locked((class_1799)newStack));
                        this.lockedCheckbox.disabled(filtering.currentFilter((class_1799)newStack).isBlank());
                    }
                }
                if (stack.method_7909() instanceof DisplayingPanelItem) {
                    DisplayingPanelItem.Config newConfig = DisplayingPanelItem.getConfig(newStack);
                    this.showCountCheckBox.checked(!newConfig.hideCount());
                    this.showCapacityCheckBox.checked(!newConfig.hideCapacity());
                    this.showItemCheckBox.checked(!newConfig.hideItem());
                    this.showNameCheckBox.checked(!newConfig.hideName());
                    this.showPercentageCheckBox.checked(newConfig.showPercentage());
                    this.hideUpgradesCheckBox.checked(newConfig.hideUpgrades());
                    this.hideButtonsCheckBox.checked(newConfig.hideButtons());
                    this.ignoreTemplatingCheckBox.checked(newConfig.ignoreTemplating());
                }
            }
            finally {
                this.ignoreChanges = false;
            }
        });
        rootComponent.child((Component)Containers.verticalFlow((Sizing)Sizing.fill((int)100), (Sizing)Sizing.fill((int)100)).child((Component)Components.label((class_2561)class_2561.method_43471((String)"ui.chowl-industries.config_panel.title"))).child((Component)verticalFlow).surface(Surface.VANILLA_TRANSLUCENT).verticalAlignment(VerticalAlignment.CENTER).horizontalAlignment(HorizontalAlignment.CENTER));
    }

    private void resendConfig() {
        if (this.ignoreChanges) {
            return;
        }
        DisplayingPanelItem.Config displayConfig = new DisplayingPanelItem.Config();
        boolean locked = false;
        if (this.lockedCheckbox != null) {
            locked = this.lockedCheckbox.checked();
        }
        if (this.showCountCheckBox != null) {
            displayConfig.hideCount(!this.showCountCheckBox.checked());
        }
        if (this.showCapacityCheckBox != null) {
            displayConfig.hideCapacity(!this.showCapacityCheckBox.checked());
        }
        if (this.showItemCheckBox != null) {
            displayConfig.hideItem(!this.showItemCheckBox.checked());
        }
        if (this.showNameCheckBox != null) {
            displayConfig.hideName(!this.showNameCheckBox.checked());
        }
        if (this.showPercentageCheckBox != null) {
            displayConfig.showPercentage(this.showPercentageCheckBox.checked());
        }
        if (this.hideUpgradesCheckBox != null) {
            displayConfig.hideUpgrades(this.hideUpgradesCheckBox.checked());
        }
        if (this.hideButtonsCheckBox != null) {
            displayConfig.hideButtons(this.hideButtonsCheckBox.checked());
        }
        if (this.ignoreTemplatingCheckBox != null) {
            displayConfig.ignoreTemplating(this.ignoreTemplatingCheckBox.checked());
        }
        ((PanelConfigSreenHandler)this.field_2797).sendMessage(new PanelConfigSreenHandler.ConfigConfig(displayConfig, locked));
    }

    public boolean method_25421() {
        return false;
    }

    protected boolean method_2381(double mouseX, double mouseY, int left, int top, int button) {
        ItemComponent filter = (ItemComponent)this.component(ItemComponent.class, "filter-slot");
        if (filter != null && filter.isInBoundingBox(mouseX, mouseY)) {
            return false;
        }
        return super.method_2381(mouseX, mouseY, left, top, button);
    }

    public void method_25432() {
    }

    public class FakeSlotComponent
    extends ItemComponent {
        protected FakeSlotComponent(class_1799 stack) {
            super(stack);
        }

        public boolean shouldDrawTooltip(double mouseX, double mouseY) {
            return ((PanelConfigSreenHandler)PanelConfigScreen.this.field_2797).method_34255().method_7960() && super.shouldDrawTooltip(mouseX, mouseY);
        }
    }
}

