/*
 * Decompiled with CFR 0.152.
 */
package com.chyzman.chowl.transfer;

import com.chyzman.chowl.transfer.BigSingleSlotStorage;
import com.chyzman.chowl.util.BigIntUtils;
import java.math.BigInteger;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageView;
import net.fabricmc.fabric.api.transfer.v1.storage.base.SingleSlotStorage;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;

public interface BigStorageView<T>
extends StorageView<T> {
    public BigInteger bigExtract(T var1, BigInteger var2, TransactionContext var3);

    public BigInteger bigAmount();

    public BigInteger bigCapacity();

    public static BigInteger bigAmount(StorageView<?> view) {
        if (view instanceof BigStorageView) {
            BigStorageView big = (BigStorageView)view;
            return big.bigAmount();
        }
        return BigInteger.valueOf(view.getAmount());
    }

    public static BigInteger bigCapacity(StorageView<?> view) {
        if (view instanceof BigStorageView) {
            BigStorageView big = (BigStorageView)view;
            return big.bigCapacity();
        }
        return BigInteger.valueOf(view.getCapacity());
    }

    public static <T> BigInteger bigExtract(SingleSlotStorage<T> storage, T resource, BigInteger maxAmount, TransactionContext tx) {
        if (storage instanceof BigSingleSlotStorage) {
            BigSingleSlotStorage big = (BigSingleSlotStorage)storage;
            return big.bigExtract(resource, maxAmount, tx);
        }
        return BigInteger.valueOf(storage.extract(resource, BigIntUtils.longValueSaturating(maxAmount), tx));
    }

    default public long extract(T resource, long maxAmount, TransactionContext transaction) {
        return BigIntUtils.longValueSaturating(this.bigExtract(resource, BigInteger.valueOf(maxAmount), transaction));
    }

    default public long getAmount() {
        return BigIntUtils.longValueSaturating(this.bigAmount());
    }

    default public long getCapacity() {
        return BigIntUtils.longValueSaturating(this.bigCapacity());
    }
}

