/*
 * Decompiled with CFR 0.152.
 */
package com.chyzman.chowl.transfer;

import com.chyzman.chowl.transfer.BigSingleSlotStorage;
import com.chyzman.chowl.transfer.BigStorageView;
import java.math.BigInteger;
import java.util.Iterator;
import java.util.List;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.base.SingleSlotStorage;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;

public class CombinedSingleSlotStorage<T>
implements BigSingleSlotStorage<T> {
    private final List<SingleSlotStorage<T>> components;
    private final T ofVariant;

    public CombinedSingleSlotStorage(List<SingleSlotStorage<T>> components, T ofVariant) {
        this.components = components;
        this.ofVariant = ofVariant;
    }

    @Override
    public BigInteger bigInsert(T resource, BigInteger maxAmount, TransactionContext transaction) {
        SingleSlotStorage<T> component;
        BigInteger remaining = maxAmount;
        Iterator<SingleSlotStorage<T>> iterator = this.components.iterator();
        while (iterator.hasNext() && !(remaining = remaining.subtract(BigSingleSlotStorage.bigInsert(component = iterator.next(), resource, remaining, transaction))).equals(BigInteger.ZERO)) {
        }
        return maxAmount.subtract(remaining);
    }

    @Override
    public long insert(T resource, long maxAmount, TransactionContext transaction) {
        long amount = 0L;
        for (SingleSlotStorage<T> component : this.components) {
            if ((amount += component.insert(resource, maxAmount - amount, transaction)) == maxAmount) break;
        }
        return amount;
    }

    @Override
    public BigInteger bigExtract(T resource, BigInteger maxAmount, TransactionContext transaction) {
        SingleSlotStorage<T> component;
        BigInteger remaining = maxAmount;
        Iterator<SingleSlotStorage<T>> iterator = this.components.iterator();
        while (iterator.hasNext() && !(remaining = remaining.subtract(BigStorageView.bigExtract(component = iterator.next(), resource, remaining, transaction))).equals(BigInteger.ZERO)) {
        }
        return maxAmount.subtract(remaining);
    }

    @Override
    public long extract(T resource, long maxAmount, TransactionContext transaction) {
        long amount = 0L;
        for (SingleSlotStorage<T> component : this.components) {
            if ((amount += component.extract(resource, maxAmount - amount, transaction)) == maxAmount) break;
        }
        return amount;
    }

    public boolean isResourceBlank() {
        return this.getResource().equals(ItemVariant.blank());
    }

    public T getResource() {
        return this.ofVariant;
    }

    @Override
    public BigInteger bigAmount() {
        BigInteger amount = BigInteger.ZERO;
        for (SingleSlotStorage<T> component : this.components) {
            if (component instanceof BigStorageView) {
                BigStorageView bigView = (BigStorageView)component;
                amount = amount.add(bigView.bigAmount());
                continue;
            }
            amount = amount.add(BigInteger.valueOf(component.getAmount()));
        }
        return amount;
    }

    @Override
    public BigInteger bigCapacity() {
        BigInteger amount = BigInteger.ZERO;
        for (SingleSlotStorage<T> component : this.components) {
            if (component instanceof BigStorageView) {
                BigStorageView bigView = (BigStorageView)component;
                amount = amount.add(bigView.bigCapacity());
                continue;
            }
            amount = amount.add(BigInteger.valueOf(component.getCapacity()));
        }
        return amount;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CombinedSingleSlotStorage that = (CombinedSingleSlotStorage)o;
        return this.components.equals(that.components);
    }

    public int hashCode() {
        return this.components.hashCode();
    }
}

