/*
 * Decompiled with CFR 0.152.
 */
package com.chyzman.chowl.transfer;

import com.chyzman.chowl.transfer.BigSingleSlotStorage;
import com.chyzman.chowl.transfer.BigStorageView;
import com.chyzman.chowl.transfer.FakeStorageView;
import com.chyzman.chowl.util.CompressionManager;
import com.chyzman.chowl.util.VariantUtils;
import java.math.BigInteger;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1935;

public class CompressingStorage
implements BigSingleSlotStorage<ItemVariant>,
FakeStorageView {
    private final BigSingleSlotStorage<ItemVariant> base;
    private final int times;

    public CompressingStorage(BigSingleSlotStorage<ItemVariant> base, int times) {
        this.base = base;
        this.times = times;
    }

    @Override
    public BigInteger bigInsert(ItemVariant resource, BigInteger maxAmount, TransactionContext transaction) {
        BigInteger insertable;
        if (VariantUtils.hasNbt(resource)) {
            return BigInteger.ZERO;
        }
        CompressionManager.ScendResult res = CompressionManager.downBy(resource.getItem(), this.times);
        if (res == null) {
            return BigInteger.ZERO;
        }
        try (Transaction nested = transaction.openNested();){
            insertable = this.base.bigInsert(ItemVariant.of((class_1935)res.item()), maxAmount.multiply(res.totalMultiplier()), (TransactionContext)nested);
        }
        insertable = insertable.divide(res.totalMultiplier()).multiply(res.totalMultiplier());
        return this.base.bigInsert(ItemVariant.of((class_1935)res.item()), insertable, transaction).divide(res.totalMultiplier());
    }

    @Override
    public BigInteger bigExtract(ItemVariant resource, BigInteger maxAmount, TransactionContext transaction) {
        BigInteger extractable;
        if (VariantUtils.hasNbt(resource)) {
            return BigInteger.ZERO;
        }
        CompressionManager.ScendResult res = CompressionManager.downBy(resource.getItem(), this.times);
        if (res == null) {
            return BigInteger.ZERO;
        }
        if (res.item() != ((ItemVariant)this.base.getResource()).getItem()) {
            return BigInteger.ZERO;
        }
        try (Transaction nested = transaction.openNested();){
            extractable = this.base.bigExtract(ItemVariant.of((class_1935)res.item()), maxAmount.multiply(res.totalMultiplier()), (TransactionContext)nested);
        }
        extractable = extractable.divide(res.totalMultiplier()).multiply(res.totalMultiplier());
        return this.base.bigExtract(ItemVariant.of((class_1935)res.item()), extractable, transaction).divide(res.totalMultiplier());
    }

    public boolean isResourceBlank() {
        return this.getResource().isBlank();
    }

    public ItemVariant getResource() {
        CompressionManager.ScendResult res = CompressionManager.upBy(((ItemVariant)this.base.getResource()).getItem(), this.times);
        if (res == null) {
            return ItemVariant.blank();
        }
        return ItemVariant.of((class_1935)res.item());
    }

    @Override
    public BigInteger bigAmount() {
        CompressionManager.ScendResult res = CompressionManager.upBy(((ItemVariant)this.base.getResource()).getItem(), this.times);
        if (res == null) {
            return BigInteger.ZERO;
        }
        return BigStorageView.bigAmount(this.base).divide(res.totalMultiplier());
    }

    @Override
    public BigInteger bigCapacity() {
        CompressionManager.ScendResult res = CompressionManager.upBy(((ItemVariant)this.base.getResource()).getItem(), this.times);
        if (res == null) {
            return BigInteger.ZERO;
        }
        return BigStorageView.bigCapacity(this.base).divide(res.totalMultiplier());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CompressingStorage that = (CompressingStorage)o;
        if (this.times != that.times) {
            return false;
        }
        return this.base.equals(that.base);
    }

    public int hashCode() {
        int result = this.base.hashCode();
        result = 31 * result + this.times;
        return result;
    }

    @Override
    public boolean countInDisplay() {
        return true;
    }
}

