/*
 * Decompiled with CFR 0.152.
 */
package com.chyzman.chowl.util;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.math.BigDecimal;
import java.math.BigInteger;
import net.minecraft.class_3545;

public final class BigIntUtils {
    private static final LoadingCache<class_3545<BigInteger, BigInteger>, BigInteger> CAPACITY_CACHE = CacheBuilder.newBuilder().concurrencyLevel(1).maximumSize(200L).build(CacheLoader.from(input -> BigIntUtils.pow(BigInteger.TWO, (BigInteger)input.method_15442()).multiply((BigInteger)input.method_15441())));
    private static final BigDecimal LOG10_OF_2 = BigDecimal.valueOf(Math.log10(2.0));

    private BigIntUtils() {
    }

    public static long longValueSaturating(BigInteger big) {
        try {
            return big.longValueExact();
        }
        catch (ArithmeticException e) {
            if (big.signum() > 0) {
                return Long.MAX_VALUE;
            }
            return Long.MIN_VALUE;
        }
    }

    public static BigInteger powOf2(BigInteger multiplier, BigInteger exponent) {
        return (BigInteger)CAPACITY_CACHE.getUnchecked((Object)new class_3545((Object)exponent, (Object)multiplier));
    }

    public static BigInteger decimalDigitsLog2(BigInteger log2) {
        return new BigDecimal(log2).multiply(LOG10_OF_2).toBigInteger().add(BigInteger.valueOf(1L));
    }

    public static BigInteger pow(BigInteger base, BigInteger exponent) {
        BigInteger result = BigInteger.ONE;
        while (exponent.signum() > 0) {
            if (exponent.testBit(0)) {
                result = result.multiply(base);
            }
            base = base.multiply(base);
            exponent = exponent.shiftRight(1);
        }
        return result;
    }
}

