/*
 * Decompiled with CFR 0.152.
 */
package com.chyzman.chowl.util;

import java.lang.ref.WeakReference;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1703;
import net.minecraft.class_1715;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_3956;
import net.minecraft.class_5455;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompressionManager {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"Chowl/CompressionManager");
    public static final Map<class_1792, Node> NODES = new HashMap<class_1792, Node>();
    private static final class_1715 INVENTORY = new class_1715(new class_1703(null, -1){

        public class_1799 method_7601(class_1657 player, int slot) {
            return null;
        }

        public boolean method_7597(class_1657 player) {
            return false;
        }
    }, 3, 3);
    private static ThreadLocal<WeakReference<class_1937>> world = new ThreadLocal();

    public static void rebuild(class_1937 w) {
        NODES.clear();
        world.set(new WeakReference<class_1937>(w));
    }

    public static String dumpDotGraph() {
        StringBuilder sb = new StringBuilder();
        sb.append("digraph \"Compression Ladder\" {\n");
        for (Node node : NODES.values()) {
            sb.append("    ");
            sb.append('\"').append(class_7923.field_41178.method_10221((Object)node.item)).append("\";\n");
            if (node.next == null) continue;
            sb.append("    ");
            sb.append('\"').append(class_7923.field_41178.method_10221((Object)node.item)).append('\"');
            sb.append(" -> ");
            sb.append('\"').append(class_7923.field_41178.method_10221((Object)node.next.item)).append('\"');
            sb.append(" [label=").append(node.nextAmount).append("];\n");
        }
        sb.append("}");
        return sb.toString();
    }

    public static Node getOrCreateNode(class_1792 item) {
        Node node = NODES.computeIfAbsent(item, Node::new);
        node.tryFill(new HashSet<class_1792>());
        return node;
    }

    public static ScendResult followDown(class_1792 item) {
        Node node = CompressionManager.getOrCreateNode(item);
        BigInteger totalMultiplier = BigInteger.ONE;
        int totalSteps = 0;
        while (node.previous != null) {
            totalMultiplier = totalMultiplier.multiply(BigInteger.valueOf(node.previousAmount));
            ++totalSteps;
            node = node.previous;
        }
        return new ScendResult(node.item, totalMultiplier, totalSteps);
    }

    @Nullable
    public static ScendResult downBy(class_1792 item, int amount) {
        Node node = CompressionManager.getOrCreateNode(item);
        BigInteger totalMultiplier = BigInteger.ONE;
        int totalSteps = 0;
        for (int i = 0; i < amount; ++i) {
            if (node.previous == null) {
                return null;
            }
            totalMultiplier = totalMultiplier.multiply(BigInteger.valueOf(node.previousAmount));
            ++totalSteps;
            node = node.previous;
        }
        return new ScendResult(node.item, totalMultiplier, totalSteps);
    }

    public static ScendResult followUp(class_1792 item) {
        Node node = CompressionManager.getOrCreateNode(item);
        BigInteger totalMultiplier = BigInteger.ONE;
        int totalSteps = 0;
        while (node.next != null) {
            totalMultiplier = totalMultiplier.multiply(BigInteger.valueOf(node.nextAmount));
            ++totalSteps;
            node = node.next;
        }
        return new ScendResult(node.item, totalMultiplier, totalSteps);
    }

    @Nullable
    public static ScendResult upBy(class_1792 item, int amount) {
        Node node = CompressionManager.getOrCreateNode(item);
        BigInteger totalMultiplier = BigInteger.ONE;
        int totalSteps = 0;
        for (int i = 0; i < amount; ++i) {
            if (node.next == null) {
                return null;
            }
            totalMultiplier = totalMultiplier.multiply(BigInteger.valueOf(node.nextAmount));
            ++totalSteps;
            node = node.next;
        }
        return new ScendResult(node.item, totalMultiplier, totalSteps);
    }

    public static class Node {
        public final class_1792 item;
        public Node next = null;
        public int nextAmount = -1;
        public Node previous = null;
        public int previousAmount = -1;
        private boolean initialized = false;

        public Node(class_1792 item) {
            this.item = item;
        }

        private void tryFill(Set<class_1792> visited) {
            class_1799 backStack;
            Node toNode;
            if (this.initialized) {
                return;
            }
            this.initialized = true;
            visited.add(this.item);
            class_1799 stack = this.item.method_7854();
            class_1799 toStack = Node.try3x3(stack);
            if (toStack != null && !visited.contains(toStack.method_7909())) {
                toNode = NODES.get(toStack.method_7909());
                if ((toNode == null || toNode.previous == null) && (backStack = Node.try1x1(toStack)) != null && backStack.method_7909() == this.item && backStack.method_7947() == 9) {
                    this.next = toNode = NODES.computeIfAbsent(toStack.method_7909(), Node::new);
                    this.nextAmount = 9;
                    toNode.previous = this;
                    toNode.previousAmount = 9;
                    LOGGER.debug("Linked {} -> {} ({})", new Object[]{this.item, toNode.item, 9});
                    toNode.tryFill(visited);
                }
            } else {
                toStack = Node.try2x2(stack);
                if (!(toStack == null || visited.contains(toStack.method_7909()) || (toNode = NODES.get(toStack.method_7909())) != null && toNode.previous != null || (backStack = Node.try1x1(toStack)) == null || backStack.method_7909() != this.item || backStack.method_7947() != 4)) {
                    this.next = toNode = NODES.computeIfAbsent(toStack.method_7909(), Node::new);
                    this.nextAmount = 4;
                    toNode.previous = this;
                    toNode.previousAmount = 4;
                    LOGGER.debug("Linked {} -> {} ({})", new Object[]{this.item, toNode.item, 4});
                    toNode.tryFill(visited);
                }
            }
            toStack = Node.try1x1(stack);
            if (!(toStack == null || visited.contains(toStack.method_7909()) || (toNode = NODES.get(toStack.method_7909())) != null && toNode.next != null)) {
                backStack = Node.try3x3(toStack);
                int amount = 9;
                if (backStack == null) {
                    backStack = Node.try2x2(toStack);
                    amount = 4;
                }
                if (backStack != null && backStack.method_7909() == this.item && backStack.method_7947() == 1) {
                    this.previous = toNode = NODES.computeIfAbsent(toStack.method_7909(), Node::new);
                    this.previousAmount = amount;
                    toNode.next = this;
                    toNode.nextAmount = amount;
                    LOGGER.debug("Linked {} -> {} ({})", new Object[]{toNode.item, this.item, amount});
                    toNode.tryFill(visited);
                }
            }
        }

        @Nullable
        private static class_1799 try3x3(class_1799 of) {
            INVENTORY.method_5448();
            for (int i = 0; i < 9; ++i) {
                INVENTORY.method_5447(i, of);
            }
            class_1937 w = (class_1937)world.get().get();
            Optional recipe = w.method_8433().method_8132(class_3956.field_17545, (class_1263)INVENTORY, w);
            return recipe.map(craftingRecipe -> craftingRecipe.method_8116((class_1263)INVENTORY, (class_5455)class_5455.field_40585)).orElse(null);
        }

        @Nullable
        private static class_1799 try1x1(class_1799 of) {
            INVENTORY.method_5448();
            INVENTORY.method_5447(0, of);
            class_1937 w = (class_1937)world.get().get();
            Optional recipe = w.method_8433().method_8132(class_3956.field_17545, (class_1263)INVENTORY, w);
            return recipe.map(craftingRecipe -> craftingRecipe.method_8116((class_1263)INVENTORY, (class_5455)class_5455.field_40585)).orElse(null);
        }

        @Nullable
        private static class_1799 try2x2(class_1799 of) {
            INVENTORY.method_5448();
            INVENTORY.method_5447(0, of);
            INVENTORY.method_5447(1, of);
            INVENTORY.method_5447(3, of);
            INVENTORY.method_5447(4, of);
            class_1937 w = (class_1937)world.get().get();
            Optional recipe = w.method_8433().method_8132(class_3956.field_17545, (class_1263)INVENTORY, w);
            return recipe.map(craftingRecipe -> craftingRecipe.method_8116((class_1263)INVENTORY, (class_5455)class_5455.field_40585)).orElse(null);
        }
    }

    public record ScendResult(class_1792 item, BigInteger totalMultiplier, int totalSteps) {
    }
}

