/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.lavender.book;

import com.google.common.collect.ImmutableSet;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import io.wispforest.lavender.Lavender;
import io.wispforest.lavender.book.Book;
import io.wispforest.lavender.book.BookLoader;
import io.wispforest.lavender.book.Category;
import io.wispforest.lavender.book.Entry;
import io.wispforest.owo.ui.component.Components;
import io.wispforest.owo.ui.container.Containers;
import io.wispforest.owo.ui.core.Component;
import io.wispforest.owo.ui.core.Sizing;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.fabricmc.fabric.api.resource.conditions.v1.ResourceCondition;
import net.minecraft.class_1058;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2291;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3264;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_3518;
import net.minecraft.class_4013;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_6885;
import net.minecraft.class_7225;
import net.minecraft.class_7654;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import org.apache.commons.io.IOUtils;
import org.jetbrains.annotations.Nullable;

public class BookContentLoader
implements class_4013,
IdentifiableResourceReloadListener {
    private static final class_7654 ENTRY_FINDER = new class_7654("lavender/entries", ".md");
    private static final class_7654 CATEGORY_FINDER = new class_7654("lavender/categories", ".md");
    private static final Gson GSON = new GsonBuilder().setLenient().disableHtmlEscaping().create();

    public static void initialize() {
        ResourceManagerHelper.get((class_3264)class_3264.field_14188).registerReloadListener((IdentifiableResourceReloadListener)new BookContentLoader());
    }

    public class_2960 getFabricId() {
        return Lavender.id("book_content_loader");
    }

    public void method_14491(class_3300 manager) {
        if (class_310.method_1551().field_1687 == null) {
            return;
        }
        BookContentLoader.reloadContents(manager);
    }

    public static void reloadContents(class_3300 manager) {
        Map<String, Map<String, class_3298>> entries = BookContentLoader.findResources(manager, ENTRY_FINDER);
        Map<String, Map<String, class_3298>> categories = BookContentLoader.findResources(manager, CATEGORY_FINDER);
        for (Book book : BookLoader.allBooks()) {
            BookContentLoader.forResourceOfBook(categories, book, "category", (identifier, resource) -> {
                MarkdownResource markdown = BookContentLoader.parseMarkdown(book, identifier, resource);
                if (markdown == null) {
                    return;
                }
                String parentCategory = class_3518.method_15253((JsonObject)markdown.meta, (String)"parent", null);
                class_2960 parentCategoryId = parentCategory != null ? (parentCategory.indexOf(58) > 0 ? class_2960.method_12829((String)parentCategory) : class_2960.method_60655((String)identifier.method_12836(), (String)parentCategory)) : null;
                book.addCategory(new Category((class_2960)identifier, parentCategoryId, class_3518.method_15265((JsonObject)markdown.meta, (String)"title"), BookContentLoader.getIcon(markdown.meta), class_3518.method_15258((JsonObject)markdown.meta, (String)"secret", (boolean)false), class_3518.method_15282((JsonObject)markdown.meta, (String)"ordinal", (int)Integer.MAX_VALUE), markdown.content));
            });
        }
        for (Book book : BookLoader.allBooks()) {
            BookContentLoader.forResourceOfBook(entries, book, "entry", (identifier, resource) -> {
                MarkdownResource markdown = BookContentLoader.parseMarkdown(book, identifier, resource);
                if (markdown == null) {
                    return;
                }
                ArrayList<class_2960> entryCategories = new ArrayList<class_2960>();
                for (JsonElement categoryElement : class_3518.method_15292((JsonObject)markdown.meta, (String)"categories", (JsonArray)new JsonArray())) {
                    String categoryString = categoryElement.getAsString();
                    entryCategories.add(categoryString.indexOf(58) > 0 ? class_2960.method_12829((String)categoryString) : class_2960.method_60655((String)identifier.method_12836(), (String)categoryString));
                }
                String legacyCategory = class_3518.method_15253((JsonObject)markdown.meta, (String)"category", null);
                if (legacyCategory != null) {
                    entryCategories.add(legacyCategory.indexOf(58) > 0 ? class_2960.method_12829((String)legacyCategory) : class_2960.method_60655((String)identifier.method_12836(), (String)legacyCategory));
                }
                String title = class_3518.method_15265((JsonObject)markdown.meta, (String)"title");
                Function<Sizing, Component> icon = BookContentLoader.getIcon(markdown.meta);
                boolean secret = class_3518.method_15258((JsonObject)markdown.meta, (String)"secret", (boolean)false);
                int ordinal = class_3518.method_15282((JsonObject)markdown.meta, (String)"ordinal", (int)Integer.MAX_VALUE);
                ImmutableSet.Builder associatedItems = new ImmutableSet.Builder();
                for (Object itemElement : class_3518.method_15292((JsonObject)markdown.meta, (String)"associated_items", (JsonArray)new JsonArray())) {
                    associatedItems.addAll(BookContentLoader.itemsFromString(itemElement.getAsString()));
                }
                ImmutableSet.Builder requiredAdvancements = new ImmutableSet.Builder();
                for (JsonElement advancementElement : class_3518.method_15292((JsonObject)markdown.meta, (String)"required_advancements", (JsonArray)new JsonArray())) {
                    if (!advancementElement.isJsonPrimitive()) continue;
                    class_2960 advancementId = class_2960.method_12829((String)advancementElement.getAsString());
                    if (advancementId == null) {
                        Lavender.LOGGER.warn("Did not add advancement '{}' as requirement to entry '{}' as it is not a valid advancement identifier", (Object)advancementElement.getAsString(), identifier);
                        continue;
                    }
                    requiredAdvancements.add((Object)advancementId);
                }
                Entry entry = new Entry((class_2960)identifier, (List<class_2960>)entryCategories, title, icon, secret, ordinal, (ImmutableSet<class_2960>)requiredAdvancements.build(), (ImmutableSet<class_1799>)associatedItems.build(), markdown.content);
                if (entry.id().method_12832().equals("landing_page")) {
                    book.setLandingPage(entry);
                } else {
                    book.addEntry(entry);
                }
            });
        }
    }

    private static Map<String, Map<String, class_3298>> findResources(class_3300 manager, class_7654 finder) {
        HashMap<String, Map<String, class_3298>> resources = new HashMap<String, Map<String, class_3298>>();
        finder.method_45113(manager).forEach((identifier, resource) -> {
            class_2960 resourceId = finder.method_45115(identifier);
            resources.computeIfAbsent(resourceId.method_12836(), s -> new HashMap()).put(resourceId.method_12832(), resource);
        });
        return resources;
    }

    private static void forResourceOfBook(Map<String, Map<String, class_3298>> resources, Book book, String resourceType, BiConsumer<class_2960, class_3298> action) {
        if (!resources.containsKey(book.id().method_12836())) {
            return;
        }
        String targetBook = book.id().method_12832();
        String activeLanguage = class_310.method_1551().method_1526().method_4669();
        HashMap<class_2960, class_3298> discoveredResources = new HashMap<class_2960, class_3298>();
        resources.get(book.id().method_12836()).forEach((path, resource) -> {
            String bookResourcePath = BookContentLoader.getBookResourcePath(path, targetBook, null);
            if (bookResourcePath == null) {
                return;
            }
            discoveredResources.put(class_2960.method_60655((String)book.id().method_12836(), (String)bookResourcePath), (class_3298)resource);
        });
        resources.get(book.id().method_12836()).forEach((path, resource) -> {
            String bookResourcePath = BookContentLoader.getBookResourcePath(path, targetBook, activeLanguage);
            if (bookResourcePath == null) {
                return;
            }
            discoveredResources.put(class_2960.method_60655((String)book.id().method_12836(), (String)bookResourcePath), (class_3298)resource);
        });
        discoveredResources.forEach((resourceId, resource) -> {
            try {
                action.accept((class_2960)resourceId, (class_3298)resource);
            }
            catch (RuntimeException e) {
                Lavender.LOGGER.warn("Could not load {} '{}'", new Object[]{resourceType, resourceId, e});
            }
        });
    }

    @Nullable
    private static String getBookResourcePath(String resourcePath, String bookName, @Nullable String activeLanguage) {
        String book = null;
        String language = null;
        if (resourcePath.indexOf(47) != -1) {
            book = resourcePath.substring(0, resourcePath.indexOf(47));
            resourcePath = resourcePath.substring(resourcePath.indexOf(47) + 1);
        }
        if (resourcePath.indexOf(47) != -1) {
            language = resourcePath.substring(0, resourcePath.indexOf(47));
            if (class_310.method_1551().method_1526().method_4665().keySet().contains(language)) {
                resourcePath = resourcePath.substring(resourcePath.indexOf(47) + 1);
            } else {
                language = null;
            }
        }
        if (!bookName.equals(book) || !Objects.equals(activeLanguage, language)) {
            return null;
        }
        return resourcePath;
    }

    @Nullable
    private static MarkdownResource parseMarkdown(Book book, class_2960 resourceId, class_3298 resource) {
        try {
            String content = IOUtils.toString((InputStream)resource.method_14482(), (Charset)StandardCharsets.UTF_8).strip();
            if (content.startsWith("```json")) {
                DataResult conditions;
                int frontmatterEnd = (content = content.substring("```json".length())).indexOf("```");
                if (frontmatterEnd == -1) {
                    throw new RuntimeException("Unterminated markdown meta");
                }
                JsonObject meta = (JsonObject)GSON.fromJson(content.substring(0, frontmatterEnd), JsonObject.class);
                content = content.substring(frontmatterEnd + 3).stripLeading();
                if (meta.has("fabric:load_conditions") && (conditions = ResourceCondition.CONDITION_CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)meta.get("fabric:load_conditions"))).isSuccess() && !((ResourceCondition)conditions.getOrThrow()).test((class_7225.class_7874)class_310.method_1551().field_1687.method_30349())) {
                    return null;
                }
                return new MarkdownResource(meta, book.expandMacros(resourceId, content.replaceAll("\\r\\n?", "\n")));
            }
            throw new RuntimeException("Missing markdown meta");
        }
        catch (Exception e) {
            Lavender.LOGGER.warn("Could not load markdown file {}", (Object)resourceId, (Object)e);
            return null;
        }
    }

    private static Function<Sizing, Component> getIcon(JsonObject meta) {
        if (meta.has("icon")) {
            class_1799 stack = BookContentLoader.itemStackFromString(class_3518.method_15265((JsonObject)meta, (String)"icon"));
            return sizing -> Components.item((class_1799)stack).sizing(sizing);
        }
        if (meta.has("icon_sprite")) {
            class_2960 id = class_2960.method_12829((String)class_3518.method_15265((JsonObject)meta, (String)"icon_sprite"));
            if (id == null) {
                return null;
            }
            return sizing -> Components.sprite((class_1058)class_310.method_1551().method_52699().method_18667(id)).sizing(sizing);
        }
        return sizing -> Containers.stack((Sizing)sizing, (Sizing)sizing);
    }

    private static Collection<class_1799> itemsFromString(String itemsString) {
        if (!itemsString.startsWith("#")) {
            return List.of(BookContentLoader.itemStackFromString(itemsString));
        }
        class_2960 tagId = class_2960.method_12829((String)itemsString.substring(1));
        if (tagId == null) {
            Lavender.LOGGER.warn("Could not parse tag ID '" + itemsString + "'");
            return List.of();
        }
        Optional entryList = class_7923.field_41178.method_40266(class_6862.method_40092((class_5321)class_7924.field_41197, (class_2960)tagId));
        if (entryList.isEmpty()) {
            Lavender.LOGGER.warn("Unknown item tag: '" + itemsString + "'");
            return List.of();
        }
        return ((class_6885.class_6888)entryList.get()).method_40239().map(class_6880::comp_349).map(class_1792::method_7854).toList();
    }

    private static class_1799 itemStackFromString(String stackString) {
        try {
            class_2291.class_7215 parsed = new class_2291((class_7225.class_7874)class_310.method_1551().field_1687.method_30349()).method_9789(new StringReader(stackString));
            class_1799 stack = ((class_1792)parsed.comp_628().comp_349()).method_7854();
            if (parsed.comp_2439() != null) {
                stack.method_57366(parsed.comp_2439());
            }
            return stack;
        }
        catch (CommandSyntaxException e) {
            throw new JsonSyntaxException("Invalid item stack: '" + stackString + "'", (Throwable)e);
        }
    }

    private record MarkdownResource(JsonObject meta, String content) {
    }
}

