/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.lavender.client;

import com.google.common.base.Suppliers;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import io.wispforest.lavender.Lavender;
import io.wispforest.lavender.client.BasicVertexConsumerProvider;
import io.wispforest.lavender.client.LavenderClient;
import io.wispforest.lavender.pond.LavenderFramebufferExtension;
import io.wispforest.lavender.structure.BlockStatePredicate;
import io.wispforest.lavender.structure.LavenderStructures;
import io.wispforest.lavender.structure.StructureTemplate;
import io.wispforest.owo.ui.component.Components;
import io.wispforest.owo.ui.container.Containers;
import io.wispforest.owo.ui.container.FlowLayout;
import io.wispforest.owo.ui.core.Component;
import io.wispforest.owo.ui.core.Easing;
import io.wispforest.owo.ui.core.HorizontalAlignment;
import io.wispforest.owo.ui.core.Insets;
import io.wispforest.owo.ui.core.Positioning;
import io.wispforest.owo.ui.core.Sizing;
import io.wispforest.owo.ui.event.WindowResizeCallback;
import io.wispforest.owo.ui.hud.Hud;
import io.wispforest.owo.ui.util.Delta;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderEvents;
import net.fabricmc.fabric.api.event.player.UseBlockCallback;
import net.minecraft.class_1041;
import net.minecraft.class_1088;
import net.minecraft.class_1269;
import net.minecraft.class_156;
import net.minecraft.class_1920;
import net.minecraft.class_1921;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_239;
import net.minecraft.class_2470;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_276;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3417;
import net.minecraft.class_3965;
import net.minecraft.class_4583;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_6367;
import net.minecraft.class_9779;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.opengl.GL30C;

public class StructureOverlayRenderer {
    private static final Supplier<class_276> FRAMEBUFFER = Suppliers.memoize(() -> {
        class_1041 window = class_310.method_1551().method_22683();
        class_6367 framebuffer = new class_6367(window.method_4489(), window.method_4506(), true, class_310.field_1703);
        ((LavenderFramebufferExtension)framebuffer).lavender$setBlitProgram(() -> {
            LavenderClient.BLIT_ALPHA_PROGRAM.setAlpha(0.5f);
            return LavenderClient.BLIT_ALPHA_PROGRAM.program();
        });
        framebuffer.method_1236(0.0f, 0.0f, 0.0f, 0.0f);
        return framebuffer;
    });
    private static final Map<class_2338, OverlayEntry> ACTIVE_OVERLAYS = new HashMap<class_2338, OverlayEntry>();
    private static final BasicVertexConsumerProvider CONSUMERS = new BasicVertexConsumerProvider(4096);
    @Nullable
    private static OverlayEntry PENDING_OVERLAY = null;
    private static final class_2960 HUD_COMPONENT_ID = Lavender.id("structure_overlay");
    private static final class_2960 BARS_TEXTURE = Lavender.id("textures/gui/structure_overlay_bars.png");

    public static void addPendingOverlay(class_2960 structure) {
        PENDING_OVERLAY = new OverlayEntry(structure, class_2470.field_11467);
    }

    public static void addOverlay(class_2338 anchorPoint, class_2960 structure, class_2470 rotation) {
        ACTIVE_OVERLAYS.put(anchorPoint, new OverlayEntry(structure, rotation));
    }

    public static boolean isShowingOverlay(class_2960 structure) {
        if (PENDING_OVERLAY != null && structure.equals((Object)StructureOverlayRenderer.PENDING_OVERLAY.structureId)) {
            return true;
        }
        for (OverlayEntry entry : ACTIVE_OVERLAYS.values()) {
            if (!structure.equals((Object)entry.structureId)) continue;
            return true;
        }
        return false;
    }

    public static void removeAllOverlays(class_2960 structure) {
        if (PENDING_OVERLAY != null && structure.equals((Object)StructureOverlayRenderer.PENDING_OVERLAY.structureId)) {
            StructureOverlayRenderer.addPendingOverlay(null);
        }
        ACTIVE_OVERLAYS.values().removeIf(entry -> structure.equals((Object)entry.structureId));
    }

    public static int getLayerRestriction(class_2960 structure) {
        for (OverlayEntry entry : ACTIVE_OVERLAYS.values()) {
            if (entry.visibleLayer == -1) continue;
            return entry.visibleLayer;
        }
        return -1;
    }

    public static void restrictVisibleLayer(class_2960 structure, int visibleLayer) {
        if (PENDING_OVERLAY != null && structure.equals((Object)StructureOverlayRenderer.PENDING_OVERLAY.structureId)) {
            StructureOverlayRenderer.PENDING_OVERLAY.visibleLayer = visibleLayer;
        }
        for (OverlayEntry entry : ACTIVE_OVERLAYS.values()) {
            if (!structure.equals((Object)entry.structureId)) continue;
            entry.visibleLayer = visibleLayer;
        }
    }

    public static void clearOverlays() {
        ACTIVE_OVERLAYS.clear();
    }

    public static void rotatePending(boolean clockwise) {
        if (PENDING_OVERLAY == null) {
            return;
        }
        StructureOverlayRenderer.PENDING_OVERLAY.rotation = StructureOverlayRenderer.PENDING_OVERLAY.rotation.method_10501(clockwise ? class_2470.field_11463 : class_2470.field_11465);
    }

    public static boolean hasPending() {
        return PENDING_OVERLAY != null;
    }

    public static void initialize() {
        Hud.add((class_2960)HUD_COMPONENT_ID, () -> Containers.verticalFlow((Sizing)Sizing.content(), (Sizing)Sizing.content()).gap(15).positioning(Positioning.relative((int)5, (int)100)));
        WorldRenderEvents.LAST.register(context -> RenderSystem.runAsFancy(() -> {
            Component patt0$temp = Hud.getComponent((class_2960)HUD_COMPONENT_ID);
            if (!(patt0$temp instanceof FlowLayout)) {
                return;
            }
            FlowLayout hudComponent = (FlowLayout)patt0$temp;
            class_4587 matrices = context.matrixStack();
            matrices.method_22903();
            matrices.method_22904(-context.camera().method_19326().field_1352, -context.camera().method_19326().field_1351, -context.camera().method_19326().field_1350);
            class_310 client = class_310.method_1551();
            class_4597.class_4598 effectConsumers = client.method_22940().method_23001();
            class_2338.class_2339 testPos = new class_2338.class_2339();
            class_276 framebuffer = FRAMEBUFFER.get();
            framebuffer.method_1230(class_310.field_1703);
            framebuffer.method_1235(false);
            GL30C.glBindFramebuffer((int)36008, (int)client.method_1522().field_1476);
            GL30C.glBlitFramebuffer((int)0, (int)0, (int)framebuffer.field_1482, (int)framebuffer.field_1481, (int)0, (int)0, (int)client.method_1522().field_1482, (int)client.method_1522().field_1481, (int)256, (int)9728);
            hudComponent.configure(layout -> {
                layout.clearChildren().padding(Insets.bottom((int)((client.method_22683().method_4486() - 182) / 2 < 200 ? 50 : 5)));
                ACTIVE_OVERLAYS.keySet().removeIf(anchor -> {
                    OverlayEntry entry = ACTIVE_OVERLAYS.get(anchor);
                    StructureTemplate structure = entry.fetchStructure();
                    if (structure == null) {
                        return true;
                    }
                    MutableBoolean hasInvalidBlock = new MutableBoolean();
                    if (entry.decayTime < 0.0f) {
                        class_4583 overlayConsumer = new class_4583(effectConsumers.getBuffer((class_1921)class_1088.field_21772.get(5 + (int)(Math.sin((double)System.currentTimeMillis() / 200.0) * 5.0))), matrices.method_23760(), 1.0f);
                        matrices.method_22903();
                        matrices.method_46416((float)anchor.method_10263(), (float)anchor.method_10264(), (float)anchor.method_10260());
                        structure.forEachPredicate((pos, predicate) -> {
                            class_2680 state = context.world().method_8320((class_2338)testPos.method_10101((class_2382)anchor).method_30927((class_2382)pos)).method_26186(StructureTemplate.inverse(entry.rotation));
                            BlockStatePredicate.Result result = predicate.test(state);
                            if (result == BlockStatePredicate.Result.STATE_MATCH) {
                                return;
                            }
                            if (!state.method_26215() && result == BlockStatePredicate.Result.NO_MATCH) {
                                hasInvalidBlock.setTrue();
                                matrices.method_22903();
                                matrices.method_46416((float)pos.method_10263(), (float)pos.method_10264(), (float)pos.method_10260());
                                client.method_1541().method_23071(state, (class_2338)testPos, (class_1920)context.world(), matrices, (class_4588)overlayConsumer);
                                matrices.method_22909();
                            }
                            if (entry.visibleLayer != -1 && pos.method_10264() != entry.visibleLayer) {
                                return;
                            }
                            StructureOverlayRenderer.renderOverlayBlock(matrices, (class_4597)CONSUMERS, pos, predicate, entry.rotation);
                        }, entry.rotation);
                        matrices.method_22909();
                    }
                    int valid = structure.countValidStates((class_1937)client.field_1687, (class_2338)anchor, entry.rotation, BlockStatePredicate.MatchCategory.NON_AIR);
                    int total = structure.predicatesOfType(BlockStatePredicate.MatchCategory.NON_AIR);
                    boolean complete = structure.validate((class_1937)client.field_1687, (class_2338)anchor, entry.rotation);
                    if (entry.decayTime >= 0.0f) {
                        valid = total;
                    }
                    int barTextureOffset = 0;
                    if (hasInvalidBlock.booleanValue()) {
                        barTextureOffset = 20;
                    }
                    if (complete) {
                        barTextureOffset = 10;
                    }
                    class_9779 renderTickCounter = client.method_60646();
                    entry.visualCompleteness += Delta.compute((float)entry.visualCompleteness, (float)((float)valid / (float)total), (float)renderTickCounter.method_60636());
                    layout.child(Containers.verticalFlow((Sizing)Sizing.content(), (Sizing)Sizing.content()).child((Component)Components.label((class_2561)class_2561.method_43469((String)"text.lavender.structure_hud.completion", (Object[])new Object[]{class_2561.method_43471((String)class_156.method_646((String)"structure", (class_2960)entry.structureId)), valid, total})).shadow(true)).child((Component)Containers.verticalFlow((Sizing)Sizing.content(), (Sizing)Sizing.content()).child((Component)Components.texture((class_2960)BARS_TEXTURE, (int)0, (int)barTextureOffset, (int)182, (int)5, (int)256, (int)48)).child((Component)Components.texture((class_2960)BARS_TEXTURE, (int)0, (int)(barTextureOffset + 5), (int)Math.round(182.0f * entry.visualCompleteness), (int)5, (int)256, (int)48).positioning(Positioning.absolute((int)0, (int)0))).child((Component)Components.texture((class_2960)BARS_TEXTURE, (int)0, (int)30, (int)182, (int)5, (int)256, (int)48).blend(true).positioning(Positioning.absolute((int)0, (int)0)))).gap(2).horizontalAlignment(HorizontalAlignment.CENTER).margins(Insets.bottom((int)((int)(Easing.CUBIC.apply((Math.max(0.0f, entry.decayTime - 30.0f) + renderTickCounter.method_60637(false)) / 20.0f) * -32.0f)))));
                    if (entry.decayTime < 0.0f && complete) {
                        entry.decayTime = 0.0f;
                        client.field_1724.method_5783(class_3417.field_14627, 1.0f, 1.0f);
                    } else if (entry.decayTime >= 0.0f) {
                        entry.decayTime += renderTickCounter.method_60636();
                    }
                    return entry.decayTime >= 50.0f;
                });
            });
            if (PENDING_OVERLAY != null) {
                StructureTemplate structure = PENDING_OVERLAY.fetchStructure();
                if (structure != null) {
                    class_239 patt1$temp = client.field_1724.method_5745(5.0, client.method_60646().method_60637(false), false);
                    if (patt1$temp instanceof class_3965) {
                        class_3965 target = (class_3965)patt1$temp;
                        class_2338 targetPos = target.method_17777().method_10081(StructureOverlayRenderer.getPendingOffset(structure));
                        if (!client.field_1724.method_5715()) {
                            targetPos = targetPos.method_10093(target.method_17780());
                        }
                        matrices.method_46416((float)targetPos.method_10263(), (float)targetPos.method_10264(), (float)targetPos.method_10260());
                        structure.forEachPredicate((pos, predicate) -> StructureOverlayRenderer.renderOverlayBlock(matrices, (class_4597)CONSUMERS, pos, predicate, StructureOverlayRenderer.PENDING_OVERLAY.rotation), StructureOverlayRenderer.PENDING_OVERLAY.rotation);
                    }
                } else {
                    PENDING_OVERLAY = null;
                }
            }
            matrices.method_22909();
            GlStateManager._depthMask((boolean)true);
            CONSUMERS.method_22993();
            effectConsumers.method_22993();
            client.method_1522().method_1235(false);
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            RenderSystem.backupProjectionMatrix();
            framebuffer.method_22594(framebuffer.field_1482, framebuffer.field_1481, false);
            RenderSystem.restoreProjectionMatrix();
        }));
        WindowResizeCallback.EVENT.register((client, window) -> FRAMEBUFFER.get().method_1234(window.method_4489(), window.method_4506(), class_310.field_1703));
        UseBlockCallback.EVENT.register((player, world, hand, hitResult) -> {
            if (PENDING_OVERLAY == null) {
                return class_1269.field_5811;
            }
            StructureTemplate structure = PENDING_OVERLAY.fetchStructure();
            class_2338 targetPos = hitResult.method_17777().method_10081(StructureOverlayRenderer.getPendingOffset(structure));
            if (!player.method_5715()) {
                targetPos = targetPos.method_10093(hitResult.method_17780());
            }
            ACTIVE_OVERLAYS.put(targetPos, PENDING_OVERLAY);
            PENDING_OVERLAY = null;
            player.method_6104(hand);
            return class_1269.field_5814;
        });
    }

    private static class_2382 getPendingOffset(StructureTemplate structure) {
        if (PENDING_OVERLAY == null) {
            return class_2382.field_11176;
        }
        return switch (StructureOverlayRenderer.PENDING_OVERLAY.rotation) {
            default -> throw new MatchException(null, null);
            case class_2470.field_11467 -> new class_2382(-structure.anchor().method_10263(), -structure.anchor().method_10264(), -structure.anchor().method_10260());
            case class_2470.field_11463 -> new class_2382(-structure.anchor().method_10260(), -structure.anchor().method_10264(), -structure.anchor().method_10263());
            case class_2470.field_11464 -> new class_2382(-structure.xSize + structure.anchor.method_10263() + 1, -structure.anchor().method_10264(), -structure.zSize + structure.anchor.method_10260() + 1);
            case class_2470.field_11465 -> new class_2382(-structure.zSize + structure.anchor.method_10260() + 1, -structure.anchor().method_10264(), -structure.xSize + structure.anchor.method_10263() + 1);
        };
    }

    private static void renderOverlayBlock(class_4587 matrices, class_4597 consumers, class_2338 offsetInStructure, BlockStatePredicate block, class_2470 rotation) {
        matrices.method_22903();
        matrices.method_46416((float)offsetInStructure.method_10263(), (float)offsetInStructure.method_10264(), (float)offsetInStructure.method_10260());
        matrices.method_22904(0.5, 0.5, 0.5);
        matrices.method_22905(1.0001f, 1.0001f, 1.0001f);
        matrices.method_22904(-0.5, -0.5, -0.5);
        class_310.method_1551().method_1541().method_3353(block.preview().method_26186(rotation), matrices, consumers, 240, class_4608.field_21444);
        matrices.method_22909();
    }

    private static class OverlayEntry {
        public final class_2960 structureId;
        public class_2470 rotation;
        public int visibleLayer = -1;
        public float decayTime = -1.0f;
        public float visualCompleteness = 0.0f;

        public OverlayEntry(class_2960 structureId, class_2470 rotation) {
            this.structureId = structureId;
            this.rotation = rotation;
        }

        @Nullable
        public StructureTemplate fetchStructure() {
            return LavenderStructures.get(this.structureId);
        }
    }
}

