/*
 * Decompiled with CFR 0.152.
 */
package dev.tocraft.skinshifter;

import dev.tocraft.craftedcore.config.Config;
import dev.tocraft.craftedcore.config.ConfigLoader;
import dev.tocraft.craftedcore.event.common.CommandEvents;
import dev.tocraft.craftedcore.platform.VersionChecker;
import dev.tocraft.craftedcore.registration.PlayerDataRegistry;
import dev.tocraft.skinshifter.SkinShifterConfig;
import dev.tocraft.skinshifter.command.SkinShifterCommand;
import dev.tocraft.skinshifter.data.SkinPlayerData;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.NotNull;

public class SkinShifter {
    public static final String MODID = "skinshifter";
    public static final SkinShifterConfig CONFIG = (SkinShifterConfig)ConfigLoader.register((String)"skinshifter", (Config[])new SkinShifterConfig[0]);

    public void initialize() {
        SkinPlayerData.initialize();
        VersionChecker.registerModrinthChecker((String)MODID, (String)MODID, (Component)Component.literal((String)"SkinShifter"));
        CommandEvents.REGISTRATION.register((Object)new SkinShifterCommand());
    }

    public static void setSkin(@NotNull ServerPlayer player, UUID skinPlayer) {
        if (Objects.equals(player.getUUID(), skinPlayer)) {
            SkinPlayerData.setSkin(player, null);
        } else {
            SkinPlayerData.setSkin(player, skinPlayer);
        }
    }

    public static void setSkinURI(@NotNull ServerPlayer player, String uri, boolean slim) {
        SkinPlayerData.setSkinURI(player, uri, slim);
    }

    public static UUID getCurrentSkin(Player player) {
        String currentSkin = (String)PlayerDataRegistry.readTag((Player)player, (String)"CurrentSkin");
        if (currentSkin != null) {
            try {
                return UUID.fromString(currentSkin);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return player.getUUID();
    }
}

