/*
 * Decompiled with CFR 0.152.
 */
package dev.tocraft.skinshifter.command;

import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import dev.tocraft.craftedcore.event.common.CommandEvents;
import dev.tocraft.skinshifter.SkinShifter;
import dev.tocraft.skinshifter.command.ListPermissionsCommand;
import dev.tocraft.skinshifter.data.SkinPlayerData;
import dev.tocraft.skinshifter.permission.ShifterPermissions;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.MessageArgument;
import net.minecraft.commands.arguments.UuidArgument;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.server.level.ServerPlayer;
import org.jetbrains.annotations.NotNull;

public class SkinShifterCommand
implements CommandEvents.CommandRegistration {
    public void register(CommandDispatcher<CommandSourceStack> dispatcher, CommandBuildContext registry, Commands.CommandSelection selection) {
        this.onRegister(dispatcher);
    }

    private void onRegister(@NotNull CommandDispatcher<CommandSourceStack> dispatcher) {
        LiteralCommandNode rootNode = ((LiteralArgumentBuilder)Commands.literal((String)"skinshifter").requires(source -> source.hasPermission(0))).build();
        LiteralCommandNode set = ((LiteralArgumentBuilder)Commands.literal((String)"set").then(((RequiredArgumentBuilder)Commands.argument((String)"player", (ArgumentType)EntityArgument.player()).then(Commands.argument((String)"playerUUID", (ArgumentType)UuidArgument.uuid()).executes(context -> {
            ServerPlayer sender;
            ServerPlayer player = EntityArgument.getPlayer((CommandContext)context, (String)"player");
            try {
                sender = ((CommandSourceStack)context.getSource()).getPlayerOrException();
            }
            catch (CommandSyntaxException e) {
                sender = null;
            }
            if (SkinShifter.CONFIG.usePermissions && sender != null ? !ShifterPermissions.canUseCommandOnTarget(sender, player, "set") : (sender != null && sender.getUUID() == player.getUUID() ? !((CommandSourceStack)context.getSource()).hasPermission(SkinShifter.CONFIG.selfCommandOPLevel) : !((CommandSourceStack)context.getSource()).hasPermission(SkinShifter.CONFIG.baseCommandOPLevel))) {
                throw new SimpleCommandExceptionType((Message)Component.translatable((String)"craftedcore.command.invalid_perms")).create();
            }
            UUID playerUUID = UuidArgument.getUuid((CommandContext)context, (String)"playerUUID");
            SkinShifter.setSkinURI(player, null, false);
            SkinShifter.setSkin(player, playerUUID);
            Optional<GameProfile> profile = SkinPlayerData.getSkinProfile(((CommandSourceStack)context.getSource()).getServer().services().profileResolver(), playerUUID);
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.translatable((String)"skinshifter.command.set", (Object[])new Object[]{player.getName(), profile.orElse(player.getGameProfile()).name()}), true);
            return 1;
        }))).then(Commands.argument((String)"playerName", (ArgumentType)MessageArgument.message()).executes(context -> {
            ServerPlayer sender;
            ServerPlayer player = EntityArgument.getPlayer((CommandContext)context, (String)"player");
            try {
                sender = ((CommandSourceStack)context.getSource()).getPlayerOrException();
            }
            catch (CommandSyntaxException e) {
                sender = null;
            }
            if (SkinShifter.CONFIG.usePermissions && sender != null ? !ShifterPermissions.canUseCommandOnTarget(sender, player, "set") : (sender != null && sender.getUUID() == player.getUUID() ? !((CommandSourceStack)context.getSource()).hasPermission(SkinShifter.CONFIG.selfCommandOPLevel) : !((CommandSourceStack)context.getSource()).hasPermission(SkinShifter.CONFIG.baseCommandOPLevel))) {
                throw new SimpleCommandExceptionType((Message)Component.translatable((String)"craftedcore.command.invalid_perms")).create();
            }
            String playerName = MessageArgument.getMessage((CommandContext)context, (String)"playerName").getString();
            @NotNull Optional<GameProfile> profile = SkinPlayerData.getSkinProfile(((CommandSourceStack)context.getSource()).getServer().services().profileResolver(), playerName);
            if (profile.isEmpty()) {
                ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.translatable((String)"skinshifter.invalid_player", (Object[])new Object[]{playerName}), true);
            } else {
                SkinShifter.setSkin(player, profile.get().id());
                ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.translatable((String)"skinshifter.command.set", (Object[])new Object[]{player.getName(), playerName}), true);
            }
            return 1;
        })))).build();
        LiteralCommandNode reset = ((LiteralArgumentBuilder)Commands.literal((String)"reset").then(Commands.argument((String)"player", (ArgumentType)EntityArgument.player()).executes(context -> {
            ServerPlayer sender;
            ServerPlayer player = EntityArgument.getPlayer((CommandContext)context, (String)"player");
            try {
                sender = ((CommandSourceStack)context.getSource()).getPlayerOrException();
            }
            catch (CommandSyntaxException e) {
                sender = null;
            }
            if (SkinShifter.CONFIG.usePermissions && sender != null ? !ShifterPermissions.canUseCommandOnTarget(sender, player, "reset") : (sender != null && sender.getUUID() == player.getUUID() ? !((CommandSourceStack)context.getSource()).hasPermission(SkinShifter.CONFIG.selfCommandOPLevel) : !((CommandSourceStack)context.getSource()).hasPermission(SkinShifter.CONFIG.baseCommandOPLevel))) {
                throw new SimpleCommandExceptionType((Message)Component.translatable((String)"craftedcore.command.invalid_perms")).create();
            }
            SkinShifter.setSkin(player, null);
            SkinShifter.setSkinURI(player, null, false);
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.translatable((String)"skinshifter.command.reset", (Object[])new Object[]{player.getName()}), true);
            return 1;
        }))).build();
        LiteralCommandNode changeChatName = ((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"changeChatName").requires(source -> {
            if (source.getPlayer() != null) {
                if (SkinShifter.CONFIG.usePermissions && source.getPlayer() != null) {
                    return ShifterPermissions.canUseCommand(source.getPlayer(), "reset");
                }
                return source.hasPermission(SkinShifter.CONFIG.baseCommandOPLevel);
            }
            return true;
        })).executes(context -> {
            boolean bool = SkinShifter.CONFIG.changeName;
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.translatable((String)"craftedcore.config.get", (Object[])new Object[]{"changeChatName", String.valueOf(bool)}), true);
            return 1;
        })).then(Commands.argument((String)"value", (ArgumentType)BoolArgumentType.bool()).executes(context -> {
            boolean bool;
            SkinShifter.CONFIG.changeName = bool = BoolArgumentType.getBool((CommandContext)context, (String)"value");
            SkinShifter.CONFIG.save();
            SkinShifter.CONFIG.sendToAllPlayers(((CommandSourceStack)context.getSource()).getLevel());
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.translatable((String)"craftedcore.config.set", (Object[])new Object[]{"changeChatName", String.valueOf(bool)}), true);
            return 1;
        }))).build();
        LiteralCommandNode setURI = ((LiteralArgumentBuilder)Commands.literal((String)"url").then(Commands.argument((String)"player", (ArgumentType)EntityArgument.player()).then(Commands.argument((String)"slim", (ArgumentType)BoolArgumentType.bool()).then(Commands.argument((String)"uri", (ArgumentType)StringArgumentType.greedyString()).executes(SkinShifterCommand::setByURI))))).build();
        rootNode.addChild(ListPermissionsCommand.createNode());
        rootNode.addChild((CommandNode)set);
        rootNode.addChild((CommandNode)reset);
        rootNode.addChild((CommandNode)changeChatName);
        rootNode.addChild((CommandNode)setURI);
        dispatcher.getRoot().addChild((CommandNode)rootNode);
    }

    private static int setByURI(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer sender;
        ServerPlayer player = EntityArgument.getPlayer(context, (String)"player");
        try {
            sender = ((CommandSourceStack)context.getSource()).getPlayerOrException();
        }
        catch (CommandSyntaxException e) {
            sender = null;
        }
        if (SkinShifter.CONFIG.usePermissions && sender != null ? !ShifterPermissions.canUseCommandOnTarget(sender, player, "uri") : (sender != null && sender.getUUID() == player.getUUID() ? !((CommandSourceStack)context.getSource()).hasPermission(SkinShifter.CONFIG.selfCommandOPLevel) : !((CommandSourceStack)context.getSource()).hasPermission(SkinShifter.CONFIG.baseCommandOPLevel))) {
            throw new SimpleCommandExceptionType((Message)Component.translatable((String)"craftedcore.command.invalid_perms")).create();
        }
        String uriStr = StringArgumentType.getString(context, (String)"uri");
        boolean slim = BoolArgumentType.getBool(context, (String)"slim");
        try {
            URI uri = new URI(uriStr);
            SkinShifter.setSkin(player, null);
            SkinShifter.setSkinURI(player, uriStr, slim);
            MutableComponent uriText = Component.literal((String)uriStr).withStyle(Style.EMPTY.withColor(ChatFormatting.AQUA).withUnderlined(Boolean.valueOf(true)).withClickEvent((ClickEvent)new ClickEvent.OpenUrl(uri)));
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> SkinShifterCommand.lambda$setByURI$13(player, (Component)uriText), true);
            return 1;
        }
        catch (URISyntaxException e) {
            ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.translatable((String)"skinshifter.command.invalid_uri"));
            return 0;
        }
    }

    private static /* synthetic */ Component lambda$setByURI$13(ServerPlayer player, Component uriText) {
        return Component.translatable((String)"skinshifter.command.set", (Object[])new Object[]{player.getName(), uriText});
    }
}

