/*
 * Decompiled with CFR 0.152.
 */
package dev.tocraft.skinshifter.data;

import com.mojang.authlib.GameProfile;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import dev.tocraft.craftedcore.platform.PlatformData;
import dev.tocraft.craftedcore.registration.PlayerDataRegistry;
import dev.tocraft.skinshifter.SkinShifter;
import dev.tocraft.skinshifter.data.TextureCache;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import net.minecraft.client.Minecraft;
import net.minecraft.core.ClientAsset;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.players.ProfileResolver;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.player.PlayerModelType;
import net.minecraft.world.entity.player.PlayerSkin;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class SkinPlayerData {
    public static final String SKIN_TAG_NAME = "CurrentSkin";
    public static final String URI_TAG_NAME = "CurrentSkinURI";

    public static void initialize() {
        PlayerDataRegistry.registerKey((String)SKIN_TAG_NAME, (Codec)Codec.STRING, (boolean)true, (boolean)true);
        PlayerDataRegistry.registerKey((String)URI_TAG_NAME, (Codec)CompoundTag.CODEC, (boolean)true, (boolean)true);
    }

    @NotNull
    public static Optional<GameProfile> getSkinProfile(Player player) {
        ProfileResolver profileResolver = switch (PlatformData.getEnv()) {
            default -> throw new MatchException(null, null);
            case Dist.CLIENT -> Minecraft.getInstance().services().profileResolver();
            case Dist.DEDICATED_SERVER -> ((ServerPlayer)player).level().getServer().services().profileResolver();
        };
        UUID uuid = SkinShifter.getCurrentSkin(player);
        if (uuid != player.getUUID()) {
            return SkinPlayerData.getSkinProfile(profileResolver, uuid);
        }
        return Optional.empty();
    }

    @NotNull
    public static Optional<GameProfile> getSkinProfile(ProfileResolver profileResolver, Player player) {
        UUID uuid = SkinShifter.getCurrentSkin(player);
        if (uuid != player.getUUID()) {
            return SkinPlayerData.getSkinProfile(profileResolver, uuid);
        }
        return Optional.empty();
    }

    @NotNull
    public static Optional<GameProfile> getSkinProfile(ProfileResolver profileResolver, UUID uuid) {
        return profileResolver.fetchById(uuid);
    }

    @NotNull
    public static Optional<GameProfile> getSkinProfile(ProfileResolver profileResolver, String name) {
        return profileResolver.fetchByName(name);
    }

    @OnlyIn(value=Dist.CLIENT)
    @NotNull
    public static CompletableFuture<Optional<PlayerSkin>> getPlayerSkin(ProfileResolver profileResolver, Player player) {
        CompletableFuture<Optional<GameProfile>> profileFuture = CompletableFuture.completedFuture(SkinPlayerData.getSkinProfile(profileResolver, player));
        return profileFuture.thenApply(profile -> {
            Optional<CompoundTag> currentUriTag;
            Optional<PlayerSkin> skin = profile.map(gameProfile -> (PlayerSkin)Minecraft.getInstance().getSkinManager().createLookup(gameProfile, true).get());
            if (skin.isEmpty() && (currentUriTag = Optional.ofNullable((CompoundTag)PlayerDataRegistry.readTag((Player)player, (String)URI_TAG_NAME, CompoundTag.class))).isPresent()) {
                String uri = currentUriTag.get().getStringOr("uri", "");
                boolean slim = currentUriTag.get().getBooleanOr("slim", false);
                if (!uri.isEmpty()) {
                    try {
                        URL url = URI.create(uri).toURL();
                        Optional<ResourceLocation> id = TextureCache.loadSkinTexture(url);
                        if (id.isPresent()) {
                            return Optional.of(new PlayerSkin((ClientAsset.Texture)new ClientAsset.ResourceTexture(id.get()), null, null, slim ? PlayerModelType.SLIM : PlayerModelType.WIDE, true));
                        }
                    }
                    catch (MalformedURLException e) {
                        LogUtils.getLogger().error("Invalid URI specified: {}", (Object)uri, (Object)e);
                    }
                }
            }
            return skin;
        });
    }

    public static void setSkin(ServerPlayer player, @Nullable UUID orgSkinUUID) {
        PlayerDataRegistry.writeTag((Player)player, (String)SKIN_TAG_NAME, (Object)(orgSkinUUID != null ? orgSkinUUID.toString() : ""));
    }

    public static void setSkinURI(ServerPlayer player, @Nullable String uri, boolean slim) {
        if (uri != null) {
            CompoundTag tag = new CompoundTag();
            tag.putString("uri", uri);
            tag.putBoolean("slim", slim);
            PlayerDataRegistry.writeTag((Player)player, (String)URI_TAG_NAME, (Object)tag);
        } else {
            PlayerDataRegistry.writeTag((Player)player, (String)URI_TAG_NAME, (Object)new CompoundTag());
        }
    }
}

