/*
 * Decompiled with CFR 0.152.
 */
package dev.tocraft.skinshifter.data;

import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.logging.LogUtils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class TextureCache {
    private static final Map<String, Optional<ResourceLocation>> LOADED_TEXTURES = new ConcurrentHashMap<String, Optional<ResourceLocation>>();
    private static String failedUrl = "";

    public static Optional<ResourceLocation> loadSkinTexture(@NotNull URL textureURL) {
        ResourceLocation location = ResourceLocation.fromNamespaceAndPath((String)"skinshifter", (String)("textures/player/skin_" + textureURL.hashCode() + ".png"));
        return LOADED_TEXTURES.computeIfAbsent(location.toString(), url -> {
            Optional<ResourceLocation> optional;
            block10: {
                ResourceLocation id = location.withPath(string -> "textures/" + string + ".png");
                InputStream is = textureURL.openStream();
                try {
                    NativeImage image = NativeImage.read((InputStream)new ByteArrayInputStream(is.readAllBytes()));
                    DynamicTexture dynamicTexture = new DynamicTexture(() -> ((ResourceLocation)id).toString(), image);
                    Minecraft.getInstance().getTextureManager().register(id, (AbstractTexture)dynamicTexture);
                    optional = Optional.of(location);
                    if (is == null) break block10;
                }
                catch (Throwable throwable) {
                    try {
                        if (is != null) {
                            try {
                                is.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        if (!Objects.equals(failedUrl, url)) {
                            LogUtils.getLogger().error("Failed to load texture from URL: {}", url, (Object)e);
                            if (Minecraft.getInstance().player != null) {
                                Minecraft.getInstance().player.displayClientMessage((Component)Component.translatable((String)"skinshifter.command.invalid_uri").withColor(0xFF0000), false);
                            }
                            failedUrl = url;
                        }
                        return Optional.empty();
                    }
                }
                is.close();
            }
            return optional;
        });
    }
}

