/*
 * Decompiled with CFR 0.152.
 */
package dev.tocraft.skinshifter.mixin.client;

import dev.tocraft.skinshifter.data.SkinPlayerData;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.player.PlayerSkin;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@OnlyIn(value=Dist.CLIENT)
@Mixin(value={AbstractClientPlayer.class})
public class AbstractClientPlayerMixin {
    @Inject(method={"getSkin()Lnet/minecraft/world/entity/player/PlayerSkin;"}, at={@At(value="RETURN")}, cancellable=true)
    public void setToNewSkin(@NotNull CallbackInfoReturnable<PlayerSkin> cir) {
        @NotNull CompletableFuture<Optional<PlayerSkin>> skinFuture = SkinPlayerData.getPlayerSkin(Minecraft.getInstance().services().profileResolver(), (Player)this);
        Optional<PlayerSkin> playerSkin = skinFuture.getNow(Optional.empty());
        playerSkin.ifPresent(arg_0 -> cir.setReturnValue(arg_0));
    }
}

