/*
 * Decompiled with CFR 0.152.
 */
package dev.tocraft.skinshifter.permission;

import dev.tocraft.craftedcore.permission.PermissionChecker;
import net.minecraft.server.level.ServerPlayer;
import org.jetbrains.annotations.NotNull;

public class ShifterPermissions {
    public static boolean hasPermission(@NotNull ServerPlayer player, @NotNull String permission) {
        return PermissionChecker.hasPermission((ServerPlayer)player, (String)"skinshifter", (String)permission);
    }

    public static boolean canUseCommand(@NotNull ServerPlayer player, @NotNull String command) {
        return ShifterPermissions.hasPermission(player, "command." + command);
    }

    public static boolean canUseCommandOnSelf(@NotNull ServerPlayer player, @NotNull String command) {
        return ShifterPermissions.hasPermission(player, "command." + command + ".self") || ShifterPermissions.canUseCommand(player, command);
    }

    public static boolean canUseCommandOnOthers(@NotNull ServerPlayer player, @NotNull String command) {
        return ShifterPermissions.hasPermission(player, "command." + command + ".others") || ShifterPermissions.canUseCommand(player, command);
    }

    public static boolean canUseCommandOnTarget(@NotNull ServerPlayer executor, @NotNull ServerPlayer target, @NotNull String command) {
        if (executor.getUUID().equals(target.getUUID())) {
            return ShifterPermissions.canUseCommandOnSelf(executor, command);
        }
        return ShifterPermissions.canUseCommandOnOthers(executor, command);
    }
}

