/*
 * Decompiled with CFR 0.152.
 */
package dev.tocraft.skinshifter.command;

import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import dev.tocraft.craftedcore.event.common.CommandEvents;
import dev.tocraft.skinshifter.SkinShifter;
import dev.tocraft.skinshifter.command.ListPermissionsCommand;
import dev.tocraft.skinshifter.data.SkinPlayerData;
import dev.tocraft.skinshifter.permission.ShifterPermissions;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.class_124;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2186;
import net.minecraft.class_2196;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_3222;
import net.minecraft.class_5242;
import net.minecraft.class_5250;
import net.minecraft.class_7157;
import org.jetbrains.annotations.NotNull;

public class SkinShifterCommand
implements CommandEvents.CommandRegistration {
    public void register(CommandDispatcher<class_2168> dispatcher, class_7157 registry, class_2170.class_5364 selection) {
        this.onRegister(dispatcher);
    }

    private void onRegister(@NotNull CommandDispatcher<class_2168> dispatcher) {
        LiteralCommandNode rootNode = ((LiteralArgumentBuilder)class_2170.method_9247((String)"skinshifter").requires(source -> source.method_9259(0))).build();
        LiteralCommandNode set = ((LiteralArgumentBuilder)class_2170.method_9247((String)"set").then(((RequiredArgumentBuilder)class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).then(class_2170.method_9244((String)"playerUUID", (ArgumentType)class_5242.method_27643()).executes(context -> {
            class_3222 sender;
            class_3222 player = class_2186.method_9315((CommandContext)context, (String)"player");
            try {
                sender = ((class_2168)context.getSource()).method_9207();
            }
            catch (CommandSyntaxException e) {
                sender = null;
            }
            if (SkinShifter.CONFIG.usePermissions && sender != null ? !ShifterPermissions.canUseCommandOnTarget(sender, player, "set") : (sender != null && sender.method_5667() == player.method_5667() ? !((class_2168)context.getSource()).method_9259(SkinShifter.CONFIG.selfCommandOPLevel) : !((class_2168)context.getSource()).method_9259(SkinShifter.CONFIG.baseCommandOPLevel))) {
                throw new SimpleCommandExceptionType((Message)class_2561.method_43471((String)"craftedcore.command.invalid_perms")).create();
            }
            UUID playerUUID = class_5242.method_27645((CommandContext)context, (String)"playerUUID");
            SkinShifter.setSkinURI(player, null, false);
            SkinShifter.setSkin(player, playerUUID);
            Optional<GameProfile> profile = SkinPlayerData.getSkinProfile(((class_2168)context.getSource()).method_9211().method_73550().comp_4624(), playerUUID);
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43469((String)"skinshifter.command.set", (Object[])new Object[]{player.method_5477(), profile.orElse(player.method_7334()).name()}), true);
            return 1;
        }))).then(class_2170.method_9244((String)"playerName", (ArgumentType)class_2196.method_9340()).executes(context -> {
            class_3222 sender;
            class_3222 player = class_2186.method_9315((CommandContext)context, (String)"player");
            try {
                sender = ((class_2168)context.getSource()).method_9207();
            }
            catch (CommandSyntaxException e) {
                sender = null;
            }
            if (SkinShifter.CONFIG.usePermissions && sender != null ? !ShifterPermissions.canUseCommandOnTarget(sender, player, "set") : (sender != null && sender.method_5667() == player.method_5667() ? !((class_2168)context.getSource()).method_9259(SkinShifter.CONFIG.selfCommandOPLevel) : !((class_2168)context.getSource()).method_9259(SkinShifter.CONFIG.baseCommandOPLevel))) {
                throw new SimpleCommandExceptionType((Message)class_2561.method_43471((String)"craftedcore.command.invalid_perms")).create();
            }
            String playerName = class_2196.method_9339((CommandContext)context, (String)"playerName").getString();
            @NotNull Optional<GameProfile> profile = SkinPlayerData.getSkinProfile(((class_2168)context.getSource()).method_9211().method_73550().comp_4624(), playerName);
            if (profile.isEmpty()) {
                ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43469((String)"skinshifter.invalid_player", (Object[])new Object[]{playerName}), true);
            } else {
                SkinShifter.setSkin(player, profile.get().id());
                ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43469((String)"skinshifter.command.set", (Object[])new Object[]{player.method_5477(), playerName}), true);
            }
            return 1;
        })))).build();
        LiteralCommandNode reset = ((LiteralArgumentBuilder)class_2170.method_9247((String)"reset").then(class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).executes(context -> {
            class_3222 sender;
            class_3222 player = class_2186.method_9315((CommandContext)context, (String)"player");
            try {
                sender = ((class_2168)context.getSource()).method_9207();
            }
            catch (CommandSyntaxException e) {
                sender = null;
            }
            if (SkinShifter.CONFIG.usePermissions && sender != null ? !ShifterPermissions.canUseCommandOnTarget(sender, player, "reset") : (sender != null && sender.method_5667() == player.method_5667() ? !((class_2168)context.getSource()).method_9259(SkinShifter.CONFIG.selfCommandOPLevel) : !((class_2168)context.getSource()).method_9259(SkinShifter.CONFIG.baseCommandOPLevel))) {
                throw new SimpleCommandExceptionType((Message)class_2561.method_43471((String)"craftedcore.command.invalid_perms")).create();
            }
            SkinShifter.setSkin(player, null);
            SkinShifter.setSkinURI(player, null, false);
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43469((String)"skinshifter.command.reset", (Object[])new Object[]{player.method_5477()}), true);
            return 1;
        }))).build();
        LiteralCommandNode changeChatName = ((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"changeChatName").requires(source -> {
            if (source.method_44023() != null) {
                if (SkinShifter.CONFIG.usePermissions && source.method_44023() != null) {
                    return ShifterPermissions.canUseCommand(source.method_44023(), "reset");
                }
                return source.method_9259(SkinShifter.CONFIG.baseCommandOPLevel);
            }
            return true;
        })).executes(context -> {
            boolean bool = SkinShifter.CONFIG.changeName;
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43469((String)"craftedcore.config.get", (Object[])new Object[]{"changeChatName", String.valueOf(bool)}), true);
            return 1;
        })).then(class_2170.method_9244((String)"value", (ArgumentType)BoolArgumentType.bool()).executes(context -> {
            boolean bool;
            SkinShifter.CONFIG.changeName = bool = BoolArgumentType.getBool((CommandContext)context, (String)"value");
            SkinShifter.CONFIG.save();
            SkinShifter.CONFIG.sendToAllPlayers(((class_2168)context.getSource()).method_9225());
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43469((String)"craftedcore.config.set", (Object[])new Object[]{"changeChatName", String.valueOf(bool)}), true);
            return 1;
        }))).build();
        LiteralCommandNode setURI = ((LiteralArgumentBuilder)class_2170.method_9247((String)"url").then(class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).then(class_2170.method_9244((String)"slim", (ArgumentType)BoolArgumentType.bool()).then(class_2170.method_9244((String)"uri", (ArgumentType)StringArgumentType.greedyString()).executes(SkinShifterCommand::setByURI))))).build();
        rootNode.addChild(ListPermissionsCommand.createNode());
        rootNode.addChild((CommandNode)set);
        rootNode.addChild((CommandNode)reset);
        rootNode.addChild((CommandNode)changeChatName);
        rootNode.addChild((CommandNode)setURI);
        dispatcher.getRoot().addChild((CommandNode)rootNode);
    }

    private static int setByURI(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_3222 sender;
        class_3222 player = class_2186.method_9315(context, (String)"player");
        try {
            sender = ((class_2168)context.getSource()).method_9207();
        }
        catch (CommandSyntaxException e) {
            sender = null;
        }
        if (SkinShifter.CONFIG.usePermissions && sender != null ? !ShifterPermissions.canUseCommandOnTarget(sender, player, "uri") : (sender != null && sender.method_5667() == player.method_5667() ? !((class_2168)context.getSource()).method_9259(SkinShifter.CONFIG.selfCommandOPLevel) : !((class_2168)context.getSource()).method_9259(SkinShifter.CONFIG.baseCommandOPLevel))) {
            throw new SimpleCommandExceptionType((Message)class_2561.method_43471((String)"craftedcore.command.invalid_perms")).create();
        }
        String uriStr = StringArgumentType.getString(context, (String)"uri");
        boolean slim = BoolArgumentType.getBool(context, (String)"slim");
        try {
            URI uri = new URI(uriStr);
            SkinShifter.setSkin(player, null);
            SkinShifter.setSkinURI(player, uriStr, slim);
            class_5250 uriText = class_2561.method_43470((String)uriStr).method_27696(class_2583.field_24360.method_10977(class_124.field_1075).method_30938(Boolean.valueOf(true)).method_10958((class_2558)new class_2558.class_10608(uri)));
            ((class_2168)context.getSource()).method_9226(() -> SkinShifterCommand.lambda$setByURI$13(player, (class_2561)uriText), true);
            return 1;
        }
        catch (URISyntaxException e) {
            ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43471((String)"skinshifter.command.invalid_uri"));
            return 0;
        }
    }

    private static /* synthetic */ class_2561 lambda$setByURI$13(class_3222 player, class_2561 uriText) {
        return class_2561.method_43469((String)"skinshifter.command.set", (Object[])new Object[]{player.method_5477(), uriText});
    }
}

