/*
 * Decompiled with CFR 0.152.
 */
package dev.tocraft.skinshifter.data;

import com.mojang.authlib.GameProfile;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import dev.tocraft.craftedcore.platform.PlatformData;
import dev.tocraft.craftedcore.registration.PlayerDataRegistry;
import dev.tocraft.skinshifter.SkinShifter;
import dev.tocraft.skinshifter.data.TextureCache;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_11755;
import net.minecraft.class_12079;
import net.minecraft.class_1657;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3222;
import net.minecraft.class_7920;
import net.minecraft.class_8685;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class SkinPlayerData {
    public static final String SKIN_TAG_NAME = "CurrentSkin";
    public static final String URI_TAG_NAME = "CurrentSkinURI";

    public static void initialize() {
        PlayerDataRegistry.registerKey((String)SKIN_TAG_NAME, (Codec)Codec.STRING, (boolean)true, (boolean)true);
        PlayerDataRegistry.registerKey((String)URI_TAG_NAME, (Codec)class_2487.field_25128, (boolean)true, (boolean)true);
    }

    @NotNull
    public static Optional<GameProfile> getSkinProfile(class_1657 player) {
        class_11755 profileResolver = switch (PlatformData.getEnv()) {
            default -> throw new MatchException(null, null);
            case EnvType.CLIENT -> class_310.method_1551().method_73361().comp_4624();
            case EnvType.SERVER -> ((class_3222)player).method_51469().method_8503().method_73550().comp_4624();
        };
        UUID uuid = SkinShifter.getCurrentSkin(player);
        if (uuid != player.method_5667()) {
            return SkinPlayerData.getSkinProfile(profileResolver, uuid);
        }
        return Optional.empty();
    }

    @NotNull
    public static Optional<GameProfile> getSkinProfile(class_11755 profileResolver, class_1657 player) {
        UUID uuid = SkinShifter.getCurrentSkin(player);
        if (uuid != player.method_5667()) {
            return SkinPlayerData.getSkinProfile(profileResolver, uuid);
        }
        return Optional.empty();
    }

    @NotNull
    public static Optional<GameProfile> getSkinProfile(class_11755 profileResolver, UUID uuid) {
        return profileResolver.method_73290(uuid);
    }

    @NotNull
    public static Optional<GameProfile> getSkinProfile(class_11755 profileResolver, String name) {
        return profileResolver.method_73289(name);
    }

    @Environment(value=EnvType.CLIENT)
    @NotNull
    public static CompletableFuture<Optional<class_8685>> getPlayerSkin(class_11755 profileResolver, class_1657 player) {
        CompletableFuture<Optional<GameProfile>> profileFuture = CompletableFuture.completedFuture(SkinPlayerData.getSkinProfile(profileResolver, player));
        return profileFuture.thenApply(profile -> {
            Optional<class_2487> currentUriTag;
            Optional<class_8685> skin = profile.map(gameProfile -> (class_8685)class_310.method_1551().method_1582().method_73544(gameProfile, true).get());
            if (skin.isEmpty() && (currentUriTag = Optional.ofNullable((class_2487)PlayerDataRegistry.readTag((class_1657)player, (String)URI_TAG_NAME, class_2487.class))).isPresent()) {
                String uri = currentUriTag.get().method_68564("uri", "");
                boolean slim = currentUriTag.get().method_68566("slim", false);
                if (!uri.isEmpty()) {
                    try {
                        URL url = URI.create(uri).toURL();
                        Optional<class_2960> id = TextureCache.loadSkinTexture(url);
                        if (id.isPresent()) {
                            return Optional.of(new class_8685((class_12079.class_12081)new class_12079.class_10726(id.get()), null, null, slim ? class_7920.field_41122 : class_7920.field_41123, true));
                        }
                    }
                    catch (MalformedURLException e) {
                        LogUtils.getLogger().error("Invalid URI specified: {}", (Object)uri, (Object)e);
                    }
                }
            }
            return skin;
        });
    }

    public static void setSkin(class_3222 player, @Nullable UUID orgSkinUUID) {
        PlayerDataRegistry.writeTag((class_1657)player, (String)SKIN_TAG_NAME, (Object)(orgSkinUUID != null ? orgSkinUUID.toString() : ""));
    }

    public static void setSkinURI(class_3222 player, @Nullable String uri, boolean slim) {
        if (uri != null) {
            class_2487 tag = new class_2487();
            tag.method_10582("uri", uri);
            tag.method_10556("slim", slim);
            PlayerDataRegistry.writeTag((class_1657)player, (String)URI_TAG_NAME, (Object)tag);
        } else {
            PlayerDataRegistry.writeTag((class_1657)player, (String)URI_TAG_NAME, (Object)new class_2487());
        }
    }
}

