/*
 * Decompiled with CFR 0.152.
 */
package dev.tocraft.skinshifter.data;

import com.mojang.logging.LogUtils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1011;
import net.minecraft.class_1043;
import net.minecraft.class_1044;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import org.jetbrains.annotations.NotNull;

@Environment(value=EnvType.CLIENT)
public class TextureCache {
    private static final Map<String, Optional<class_2960>> LOADED_TEXTURES = new ConcurrentHashMap<String, Optional<class_2960>>();
    private static String failedUrl = "";

    public static Optional<class_2960> loadSkinTexture(@NotNull URL textureURL) {
        class_2960 location = class_2960.method_60655((String)"skinshifter", (String)("textures/player/skin_" + textureURL.hashCode() + ".png"));
        return LOADED_TEXTURES.computeIfAbsent(location.toString(), url -> {
            Optional<class_2960> optional;
            block10: {
                class_2960 id = location.method_45134(string -> "textures/" + string + ".png");
                InputStream is = textureURL.openStream();
                try {
                    class_1011 image = class_1011.method_4309((InputStream)new ByteArrayInputStream(is.readAllBytes()));
                    class_1043 dynamicTexture = new class_1043(() -> ((class_2960)id).toString(), image);
                    class_310.method_1551().method_1531().method_4616(id, (class_1044)dynamicTexture);
                    optional = Optional.of(location);
                    if (is == null) break block10;
                }
                catch (Throwable throwable) {
                    try {
                        if (is != null) {
                            try {
                                is.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        if (!Objects.equals(failedUrl, url)) {
                            LogUtils.getLogger().error("Failed to load texture from URL: {}", url, (Object)e);
                            if (class_310.method_1551().field_1724 != null) {
                                class_310.method_1551().field_1724.method_7353((class_2561)class_2561.method_43471((String)"skinshifter.command.invalid_uri").method_54663(0xFF0000), false);
                            }
                            failedUrl = url;
                        }
                        return Optional.empty();
                    }
                }
                is.close();
            }
            return optional;
        });
    }
}

