/*
 * Decompiled with CFR 0.152.
 */
package net.eternal_tales.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;

public class Modelbeast<T extends Entity>
extends EntityModel<T> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"eternal_tales", (String)"modelbeast"), "main");
    public final ModelPart body;
    public final ModelPart tail;
    public final ModelPart head;
    public final ModelPart rightleg;
    public final ModelPart leftleg;
    public final ModelPart leftlegback;
    public final ModelPart rightlegback;

    public Modelbeast(ModelPart root) {
        this.body = root.getChild("body");
        this.tail = root.getChild("tail");
        this.head = root.getChild("head");
        this.rightleg = root.getChild("rightleg");
        this.leftleg = root.getChild("leftleg");
        this.leftlegback = root.getChild("leftlegback");
        this.rightlegback = root.getChild("rightlegback");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition body = partdefinition.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 12).addBox(-9.0f, -1.0f, -14.0f, 7.0f, 5.0f, 16.0f, new CubeDeformation(0.0f)), PartPose.offset((float)5.0f, (float)15.0f, (float)7.0f));
        PartDefinition tail = partdefinition.addOrReplaceChild("tail", CubeListBuilder.create().texOffs(0, 53).addBox(-3.0f, -1.7621f, -9.017f, 5.0f, 4.0f, 6.0f, new CubeDeformation(0.0f)).texOffs(44, 54).addBox(-2.0f, -0.7621f, -3.017f, 3.0f, 3.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)17.8452f, (float)17.3516f, (float)-0.1745f, (float)0.0f, (float)0.0f));
        PartDefinition head = partdefinition.addOrReplaceChild("head", CubeListBuilder.create().texOffs(17, 0).addBox(-3.0f, -3.242f, -5.6446f, 5.0f, 6.0f, 6.0f, new CubeDeformation(0.0f)).texOffs(0, 0).addBox(-2.0f, -1.242f, -10.6446f, 3.0f, 4.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)17.0f, (float)-7.0f, (float)0.0873f, (float)0.0f, (float)0.0f));
        PartDefinition rightleg = partdefinition.addOrReplaceChild("rightleg", CubeListBuilder.create().texOffs(56, 0).addBox(-1.0f, 0.0f, -1.0f, 2.0f, 5.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-3.0f, (float)19.0f, (float)-6.0f));
        PartDefinition leftleg = partdefinition.addOrReplaceChild("leftleg", CubeListBuilder.create().texOffs(56, 0).addBox(-1.0f, 0.0f, -1.0f, 2.0f, 5.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)2.0f, (float)19.0f, (float)-6.0f));
        PartDefinition leftlegback = partdefinition.addOrReplaceChild("leftlegback", CubeListBuilder.create().texOffs(52, 11).addBox(-1.0f, 0.0f, -2.0f, 2.0f, 3.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)2.0f, (float)19.0f, (float)7.0f));
        PartDefinition bottomleft = leftlegback.addOrReplaceChild("bottomleft", CubeListBuilder.create().texOffs(56, 31).addBox(1.0f, 1.2429f, -7.6601f, 2.0f, 5.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-2.0f, (float)2.0f, (float)6.0f, (float)-0.3927f, (float)0.0f, (float)0.0f));
        PartDefinition rightlegback = partdefinition.addOrReplaceChild("rightlegback", CubeListBuilder.create().texOffs(52, 11).addBox(-1.0f, 0.0f, -2.0f, 2.0f, 3.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-3.0f, (float)19.0f, (float)7.0f));
        PartDefinition bottomright = rightlegback.addOrReplaceChild("bottomright", CubeListBuilder.create().texOffs(56, 31).addBox(-4.0f, -2.0427f, 2.8853f, 2.0f, 5.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)3.0f, (float)1.0f, (float)-5.0f, (float)-0.3927f, (float)0.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, int rgb) {
        this.body.render(poseStack, vertexConsumer, packedLight, packedOverlay, rgb);
        this.tail.render(poseStack, vertexConsumer, packedLight, packedOverlay, rgb);
        this.head.render(poseStack, vertexConsumer, packedLight, packedOverlay, rgb);
        this.rightleg.render(poseStack, vertexConsumer, packedLight, packedOverlay, rgb);
        this.leftleg.render(poseStack, vertexConsumer, packedLight, packedOverlay, rgb);
        this.leftlegback.render(poseStack, vertexConsumer, packedLight, packedOverlay, rgb);
        this.rightlegback.render(poseStack, vertexConsumer, packedLight, packedOverlay, rgb);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.head.yRot = netHeadYaw / 57.295776f;
        this.head.xRot = headPitch / 57.295776f;
        this.rightleg.xRot = Mth.cos((float)(limbSwing * 1.0f)) * 1.0f * limbSwingAmount;
        this.rightlegback.xRot = Mth.cos((float)(limbSwing * 1.0f)) * 1.0f * limbSwingAmount;
        this.leftleg.xRot = Mth.cos((float)(limbSwing * 1.0f)) * -1.0f * limbSwingAmount;
        this.leftlegback.xRot = Mth.cos((float)(limbSwing * 1.0f)) * -1.0f * limbSwingAmount;
    }
}

