/*
 * Decompiled with CFR 0.152.
 */
package net.eternal_tales.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;

public class Modeltropic_elephant<T extends Entity>
extends EntityModel<T> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"eternal_tales", (String)"modeltropic_elephant"), "main");
    public final ModelPart body;
    public final ModelPart leg1;
    public final ModelPart leg2;
    public final ModelPart leg3;
    public final ModelPart leg4;
    public final ModelPart head;

    public Modeltropic_elephant(ModelPart root) {
        this.body = root.getChild("body");
        this.leg1 = root.getChild("leg1");
        this.leg2 = root.getChild("leg2");
        this.leg3 = root.getChild("leg3");
        this.leg4 = root.getChild("leg4");
        this.head = root.getChild("head");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition body = partdefinition.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 0).addBox(-8.0f, -9.0f, -8.0f, 16.0f, 16.0f, 35.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-1.0f, (float)0.0f));
        PartDefinition leg1 = partdefinition.addOrReplaceChild("leg1", CubeListBuilder.create().texOffs(0, 0).addBox(-5.0f, 0.0f, -3.0f, 7.0f, 18.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offset((float)6.0f, (float)6.0f, (float)-5.0f));
        PartDefinition leg2 = partdefinition.addOrReplaceChild("leg2", CubeListBuilder.create().texOffs(0, 0).addBox(-4.0f, 0.0f, -3.0f, 7.0f, 18.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-4.0f, (float)6.0f, (float)-5.0f));
        PartDefinition leg3 = partdefinition.addOrReplaceChild("leg3", CubeListBuilder.create().texOffs(0, 0).addBox(-3.0f, 0.0f, -4.0f, 7.0f, 18.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offset((float)4.0f, (float)6.0f, (float)24.0f));
        PartDefinition leg4 = partdefinition.addOrReplaceChild("leg4", CubeListBuilder.create().texOffs(0, 0).addBox(-3.0f, 0.0f, -6.0f, 7.0f, 18.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-5.0f, (float)6.0f, (float)26.0f));
        PartDefinition head = partdefinition.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 52).addBox(-8.0f, -11.0f, -16.0f, 16.0f, 16.0f, 16.0f, new CubeDeformation(0.0f)).texOffs(68, 0).addBox(-3.0f, -4.0f, -22.0f, 6.0f, 11.0f, 6.0f, new CubeDeformation(0.0f)).texOffs(93, 0).addBox(-2.0f, 7.0f, -21.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-6.0f, (float)-8.0f));
        PartDefinition ear1 = head.addOrReplaceChild("ear1", CubeListBuilder.create().texOffs(0, 106).addBox(-0.4329f, -2.0f, -2.0124f, 1.0f, 11.0f, 11.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)9.0f, (float)-9.0f, (float)-9.0f, (float)0.0f, (float)0.3927f, (float)0.0436f));
        PartDefinition ear3 = head.addOrReplaceChild("ear3", CubeListBuilder.create(), PartPose.offset((float)-10.0f, (float)-9.0f, (float)-9.0f));
        PartDefinition cube_r1 = ear3.addOrReplaceChild("cube_r1", CubeListBuilder.create().texOffs(0, 106).addBox(-8.0f, -9.0f, -3.0f, 1.0f, 11.0f, 11.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)7.5671f, (float)7.0f, (float)2.9876f, (float)0.0f, (float)-0.3927f, (float)-0.0436f));
        PartDefinition ear2 = head.addOrReplaceChild("ear2", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)5.0f, (float)8.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)128, (int)128);
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer buffer, int packedLight, int packedOverlay, int rgb) {
        this.body.render(poseStack, buffer, packedLight, packedOverlay);
        this.leg1.render(poseStack, buffer, packedLight, packedOverlay);
        this.leg2.render(poseStack, buffer, packedLight, packedOverlay);
        this.leg3.render(poseStack, buffer, packedLight, packedOverlay);
        this.leg4.render(poseStack, buffer, packedLight, packedOverlay);
        this.head.render(poseStack, buffer, packedLight, packedOverlay);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.head.yRot = netHeadYaw / 57.295776f;
        this.head.xRot = headPitch / 57.295776f;
        this.leg1.xRot = Mth.cos((float)(limbSwing * 1.0f)) * 1.0f * limbSwingAmount;
        this.leg4.xRot = Mth.cos((float)(limbSwing * 1.0f)) * -1.0f * limbSwingAmount;
        this.leg2.xRot = Mth.cos((float)(limbSwing * 1.0f)) * -1.0f * limbSwingAmount;
        this.leg3.xRot = Mth.cos((float)(limbSwing * 1.0f)) * 1.0f * limbSwingAmount;
    }
}

