/*
 * Decompiled with CFR 0.152.
 */
package net.eternal_tales.network;

import java.util.function.Supplier;
import net.eternal_tales.EternalTalesMod;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.saveddata.SavedData;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.attachment.AttachmentType;
import net.neoforged.neoforge.common.util.INBTSerializable;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.neoforged.neoforge.registries.NeoForgeRegistries;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD)
public class EternalTalesModVariables {
    public static final DeferredRegister<AttachmentType<?>> ATTACHMENT_TYPES = DeferredRegister.create((ResourceKey)NeoForgeRegistries.Keys.ATTACHMENT_TYPES, (String)"eternal_tales");
    public static final Supplier<AttachmentType<PlayerVariables>> PLAYER_VARIABLES = ATTACHMENT_TYPES.register("player_variables", () -> AttachmentType.serializable(() -> new PlayerVariables()).build());

    @SubscribeEvent
    public static void init(FMLCommonSetupEvent event) {
        EternalTalesMod.addNetworkMessage(SavedDataSyncMessage.TYPE, SavedDataSyncMessage.STREAM_CODEC, SavedDataSyncMessage::handleData);
        EternalTalesMod.addNetworkMessage(PlayerVariablesSyncMessage.TYPE, PlayerVariablesSyncMessage.STREAM_CODEC, PlayerVariablesSyncMessage::handleData);
    }

    public record SavedDataSyncMessage(int dataType, SavedData data) implements CustomPacketPayload
    {
        public static final CustomPacketPayload.Type<SavedDataSyncMessage> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"eternal_tales", (String)"saved_data_sync"));
        public static final StreamCodec<RegistryFriendlyByteBuf, SavedDataSyncMessage> STREAM_CODEC = StreamCodec.of((buffer, message) -> {
            buffer.writeInt(message.dataType);
            if (message.data != null) {
                buffer.writeNbt((Tag)message.data.save(new CompoundTag(), (HolderLookup.Provider)buffer.registryAccess()));
            }
        }, buffer -> {
            int dataType = buffer.readInt();
            CompoundTag nbt = buffer.readNbt();
            SavedData data = null;
            if (nbt != null) {
                SavedData savedData = data = dataType == 0 ? new MapVariables() : new WorldVariables();
                if (data instanceof MapVariables) {
                    MapVariables mapVariables = (MapVariables)data;
                    mapVariables.read(nbt, (HolderLookup.Provider)buffer.registryAccess());
                } else if (data instanceof WorldVariables) {
                    WorldVariables worldVariables = (WorldVariables)data;
                    worldVariables.read(nbt, (HolderLookup.Provider)buffer.registryAccess());
                }
            }
            return new SavedDataSyncMessage(dataType, data);
        });

        public CustomPacketPayload.Type<SavedDataSyncMessage> type() {
            return TYPE;
        }

        public static void handleData(SavedDataSyncMessage message, IPayloadContext context) {
            if (context.flow() == PacketFlow.CLIENTBOUND && message.data != null) {
                context.enqueueWork(() -> {
                    if (message.dataType == 0) {
                        MapVariables.clientSide.read(message.data.save(new CompoundTag(), (HolderLookup.Provider)context.player().registryAccess()), (HolderLookup.Provider)context.player().registryAccess());
                    } else {
                        WorldVariables.clientSide.read(message.data.save(new CompoundTag(), (HolderLookup.Provider)context.player().registryAccess()), (HolderLookup.Provider)context.player().registryAccess());
                    }
                }).exceptionally(e -> {
                    context.connection().disconnect((Component)Component.literal((String)e.getMessage()));
                    return null;
                });
            }
        }
    }

    public record PlayerVariablesSyncMessage(PlayerVariables data) implements CustomPacketPayload
    {
        public static final CustomPacketPayload.Type<PlayerVariablesSyncMessage> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"eternal_tales", (String)"player_variables_sync"));
        public static final StreamCodec<RegistryFriendlyByteBuf, PlayerVariablesSyncMessage> STREAM_CODEC = StreamCodec.of((buffer, message) -> buffer.writeNbt((Tag)message.data().serializeNBT((HolderLookup.Provider)buffer.registryAccess())), buffer -> {
            PlayerVariablesSyncMessage message = new PlayerVariablesSyncMessage(new PlayerVariables());
            message.data.deserializeNBT((HolderLookup.Provider)buffer.registryAccess(), buffer.readNbt());
            return message;
        });

        public CustomPacketPayload.Type<PlayerVariablesSyncMessage> type() {
            return TYPE;
        }

        public static void handleData(PlayerVariablesSyncMessage message, IPayloadContext context) {
            if (context.flow() == PacketFlow.CLIENTBOUND && message.data != null) {
                context.enqueueWork(() -> ((PlayerVariables)context.player().getData(PLAYER_VARIABLES)).deserializeNBT((HolderLookup.Provider)context.player().registryAccess(), message.data.serializeNBT((HolderLookup.Provider)context.player().registryAccess()))).exceptionally(e -> {
                    context.connection().disconnect((Component)Component.literal((String)e.getMessage()));
                    return null;
                });
            }
        }
    }

    public static class PlayerVariables
    implements INBTSerializable<CompoundTag> {
        public double skill_digging_level = 0.0;
        public double skill_digging_points = 0.0;
        public double skill_digging_points_need = 5.0;
        public double skill_fishing_level = 0.0;
        public double skill_fishing_points = 0.0;
        public double skill_fishing_points_need = 5.0;
        public double skill_growing_level = 0.0;
        public double skill_growing_points = 0.0;
        public double skill_growing_points_need = 5.0;
        public double skill_sorcery_level = 0.0;
        public double skill_sorcery_points = 0.0;
        public double skill_sorcery_points_need = 5.0;
        public double firstmission = 1.0;
        public boolean show_essence = false;
        public double tefius = 0.0;
        public double isaris = 0.0;
        public double ayeris = 0.0;
        public double tefiusmax = 0.0;
        public double isarismax = 0.0;
        public double ayerismax = 0.0;
        public boolean isaris_boosted = false;
        public boolean ayeris_boosted = false;
        public boolean tefius_boosted = false;
        public boolean truadamantite_boosted = false;
        public boolean dark_mage_boosted = false;
        public double iwa_cooldown = 0.0;
        public double amber_quest_progress = 0.0;
        public boolean chthonic_boosted = false;
        public boolean orichancum_boosted = false;
        public boolean unahzaal_boosted = false;
        public boolean spawn_arky = false;
        public boolean spawn_dylan_moremi = false;
        public boolean otherworldly_eyes_on = false;
        public boolean arsonist_of_lands_on = false;
        public double vivid_kills = 0.0;
        public double martyr_kills = 0.0;
        public double kraken_kills = 0.0;
        public double terribletree_kills = 0.0;
        public double rockblaze_kills = 0.0;
        public double nyetet_kills = 0.0;
        public double jaghax_kills = 0.0;
        public double pterion_kills = 0.0;
        public double arla_kills = 0.0;
        public double haciru_kills = 0.0;
        public double ikkorh_kills = 0.0;
        public double hirots_kills = 0.0;
        public double enicrih_kills = 0.0;
        public double arahulum_kills = 0.0;
        public double volcanicgolem_kills = 0.0;
        public double xaxxasxix_kills = 0.0;
        public double unahzaal_kills = 0.0;
        public double halloweenspirit_kills = 0.0;
        public double brimstoneagaric_kills = 0.0;
        public double areispirit_kills = 0.0;
        public double william_kills = 0.0;
        public double piglinwarlock_kills = 0.0;
        public double tsarofpiglins_kills = 0.0;
        public double khogachi_kills = 0.0;
        public double ravritequeen_kills = 0.0;
        public double skill_fear_level = 0.0;
        public double skill_fear_points = 0.0;
        public double skill_fear_points_need = 5.0;
        public double fear_counting = 0.0;
        public double crimson_tears = 5.0;
        public double humanity = 0.0;
        public double luciden_kills = 0.0;
        public double noxifer_kills = 0.0;
        public boolean destiny_space = false;
        public boolean destiny_power = false;
        public boolean destiny_reality = false;
        public boolean destiny_mind = false;
        public boolean destiny_soul = false;
        public boolean destiny_time = false;
        public double kills = 0.0;
        public boolean great_emblem_fly = false;
        public double ekatebrina_kills = 0.0;
        public boolean show_skills = false;
        public boolean chainsaw_active = false;
        public boolean terra_hammer_active = false;
        public boolean nether_hammer_active = false;
        public double skill_speech_level = 0.0;
        public double skill_speech_points = 0.0;
        public double skill_speech_points_need = 5.0;
        public double level_points = 0.0;
        public double player_level = 0.0;
        public double level_points_need = 5.0;
        public double level_skill_points = 0.0;
        public boolean show_crimson_tears = true;
        public String active_quest = "--";
        public boolean has_active_quest = false;
        public String overworld_quest = "???";
        public String nether_quest = "???";
        public String end_quest = "???";
        public String comets_quest = "???";
        public String purgatorium_quest = "???";
        public String eden_quest = "???";
        public String rayana_quest = "???";
        public String karvat_quest = "???";
        public String volcanech_quest = "???";
        public String amber_quest = "???";
        public double quest_overworld_stage = 0.0;
        public double active_quest_id = 0.0;
        public double quest_nether_stage = 0.0;
        public double quest_end_stage = 0.0;
        public double quest_comets_stage = 0.0;
        public double quest_purgatorium_stage = 0.0;
        public double quest_eden_stage = 0.0;
        public double quest_rayana_stage = 0.0;
        public double quest_karvat_stage = 0.0;
        public double quest_volcanech_stage = 0.0;
        public double quest_amber_stage = 0.0;
        public double comet_fleas_killed = 0.0;
        public double eternal_dawn_kills = 0.0;
        public double celestial_comets_x = 0.0;
        public double celestial_comets_y = 0.0;
        public double celestial_comets_z = 0.0;
        public double celestial_eden_x = 0.0;
        public double celestial_eden_y = 0.0;
        public double celestial_eden_z = 0.0;
        public boolean celestial_comets_binded = false;
        public boolean celestial_eden_binded = false;
        public boolean guitar_skill = false;
        public double guitar_points = 0.0;
        public double ender_dragon_kills = 0.0;
        public double wither_kills = 0.0;
        public double elder_guardian_kills = 0.0;
        public double warden_kills = 0.0;
        public double dice_player = 0.0;
        public double dice_bartender = 0.0;
        public boolean eternity_hammer_active = false;
        public boolean spawn_lenot = false;
        public double skill_catching_level = 0.0;
        public double skill_catching_points = 0.0;
        public double skill_catching_points_need = 5.0;
        public double skill_slaying_level = 0.0;
        public double skill_slaying_points = 0.0;
        public double skill_slaying_points_need = 5.0;
        public boolean order_learned = false;
        public double skill_archaeology_level = 0.0;
        public double skill_archaeology_points = 0.0;
        public double skill_archaeology_poins_need = 5.0;
        public boolean tooltips_enabled = true;
        public double mucunfectio_crab_kills = 0.0;
        public double smuciel_kills = 0.0;
        public double arei_wings_cooldown = 0.0;
        public double ekatebrina_tier_2_kills = 0.0;
        public double ice_dragon_kills = 0.0;
        public boolean calamity_ring_equipped = false;
        public boolean the_ultimate_one_equipped = false;
        public boolean ring_of_the_crimson_tears_equipped = false;
        public boolean watching_sphere_equipped = false;
        public boolean arei_wings_equipped = false;
        public boolean stupid_way_mite = false;
        public boolean stupid_way_nettle = false;
        public boolean stupid_way_unahzaal_cupcake = false;
        public double crabzilla_kills = 0.0;
        public boolean unahzaal_summonings_on = true;
        public String tamed_gultravs = "\"\"";
        public String tamed_raccoons = "\"\"";
        public String tamed_tarkos = "\"\"";
        public double skill_archery_level = 0.0;
        public double skill_archery_points = 0.0;
        public double skill_archery_points_need = 5.0;
        public double ranged_damage_boost = 0.0;
        public double dreadful_sapling_kills = 0.0;
        public double ekatebrina_tier_iii_kills = 0.0;
        public double everfrost_serpent_kills = 0.0;
        public String killed_bosses = "\"\"";
        public double unahzaal_wish_boost = 0.0;
        public boolean unahzaal_wish_activated = false;
        public boolean third_eye_boosted = false;
        public boolean third_eye_equipped = false;
        public double grotesterk_kills = 0.0;
        public double eye_of_unahzaal_kills = 0.0;
        public double blood_moon_mobs_kills = 0.0;
        public double blue_moon_mobs_kills = 0.0;
        public String lunar_event_journal = "\"\"";
        public double abyssaliel_kills = 0.0;
        public boolean lunar_alive = false;
        public double moonworm_kills = 0.0;
        public double fall_distance = 0.0;
        public boolean the_ultimate_two_equipped = false;
        public boolean fort_of_the_undead_equipped = false;
        public boolean storm_necklace_equipped = false;
        public boolean show_ammo_overlay = true;

        public CompoundTag serializeNBT(HolderLookup.Provider lookupProvider) {
            CompoundTag nbt = new CompoundTag();
            nbt.putDouble("skill_digging_level", this.skill_digging_level);
            nbt.putDouble("skill_digging_points", this.skill_digging_points);
            nbt.putDouble("skill_digging_points_need", this.skill_digging_points_need);
            nbt.putDouble("skill_fishing_level", this.skill_fishing_level);
            nbt.putDouble("skill_fishing_points", this.skill_fishing_points);
            nbt.putDouble("skill_fishing_points_need", this.skill_fishing_points_need);
            nbt.putDouble("skill_growing_level", this.skill_growing_level);
            nbt.putDouble("skill_growing_points", this.skill_growing_points);
            nbt.putDouble("skill_growing_points_need", this.skill_growing_points_need);
            nbt.putDouble("skill_sorcery_level", this.skill_sorcery_level);
            nbt.putDouble("skill_sorcery_points", this.skill_sorcery_points);
            nbt.putDouble("skill_sorcery_points_need", this.skill_sorcery_points_need);
            nbt.putDouble("firstmission", this.firstmission);
            nbt.putBoolean("show_essence", this.show_essence);
            nbt.putDouble("tefius", this.tefius);
            nbt.putDouble("isaris", this.isaris);
            nbt.putDouble("ayeris", this.ayeris);
            nbt.putDouble("tefiusmax", this.tefiusmax);
            nbt.putDouble("isarismax", this.isarismax);
            nbt.putDouble("ayerismax", this.ayerismax);
            nbt.putBoolean("isaris_boosted", this.isaris_boosted);
            nbt.putBoolean("ayeris_boosted", this.ayeris_boosted);
            nbt.putBoolean("tefius_boosted", this.tefius_boosted);
            nbt.putBoolean("truadamantite_boosted", this.truadamantite_boosted);
            nbt.putBoolean("dark_mage_boosted", this.dark_mage_boosted);
            nbt.putDouble("iwa_cooldown", this.iwa_cooldown);
            nbt.putDouble("amber_quest_progress", this.amber_quest_progress);
            nbt.putBoolean("chthonic_boosted", this.chthonic_boosted);
            nbt.putBoolean("orichancum_boosted", this.orichancum_boosted);
            nbt.putBoolean("unahzaal_boosted", this.unahzaal_boosted);
            nbt.putBoolean("spawn_arky", this.spawn_arky);
            nbt.putBoolean("spawn_dylan_moremi", this.spawn_dylan_moremi);
            nbt.putBoolean("otherworldly_eyes_on", this.otherworldly_eyes_on);
            nbt.putBoolean("arsonist_of_lands_on", this.arsonist_of_lands_on);
            nbt.putDouble("vivid_kills", this.vivid_kills);
            nbt.putDouble("martyr_kills", this.martyr_kills);
            nbt.putDouble("kraken_kills", this.kraken_kills);
            nbt.putDouble("terribletree_kills", this.terribletree_kills);
            nbt.putDouble("rockblaze_kills", this.rockblaze_kills);
            nbt.putDouble("nyetet_kills", this.nyetet_kills);
            nbt.putDouble("jaghax_kills", this.jaghax_kills);
            nbt.putDouble("pterion_kills", this.pterion_kills);
            nbt.putDouble("arla_kills", this.arla_kills);
            nbt.putDouble("haciru_kills", this.haciru_kills);
            nbt.putDouble("ikkorh_kills", this.ikkorh_kills);
            nbt.putDouble("hirots_kills", this.hirots_kills);
            nbt.putDouble("enicrih_kills", this.enicrih_kills);
            nbt.putDouble("arahulum_kills", this.arahulum_kills);
            nbt.putDouble("volcanicgolem_kills", this.volcanicgolem_kills);
            nbt.putDouble("xaxxasxix_kills", this.xaxxasxix_kills);
            nbt.putDouble("unahzaal_kills", this.unahzaal_kills);
            nbt.putDouble("halloweenspirit_kills", this.halloweenspirit_kills);
            nbt.putDouble("brimstoneagaric_kills", this.brimstoneagaric_kills);
            nbt.putDouble("areispirit_kills", this.areispirit_kills);
            nbt.putDouble("william_kills", this.william_kills);
            nbt.putDouble("piglinwarlock_kills", this.piglinwarlock_kills);
            nbt.putDouble("tsarofpiglins_kills", this.tsarofpiglins_kills);
            nbt.putDouble("khogachi_kills", this.khogachi_kills);
            nbt.putDouble("ravritequeen_kills", this.ravritequeen_kills);
            nbt.putDouble("skill_fear_level", this.skill_fear_level);
            nbt.putDouble("skill_fear_points", this.skill_fear_points);
            nbt.putDouble("skill_fear_points_need", this.skill_fear_points_need);
            nbt.putDouble("fear_counting", this.fear_counting);
            nbt.putDouble("crimson_tears", this.crimson_tears);
            nbt.putDouble("humanity", this.humanity);
            nbt.putDouble("luciden_kills", this.luciden_kills);
            nbt.putDouble("noxifer_kills", this.noxifer_kills);
            nbt.putBoolean("destiny_space", this.destiny_space);
            nbt.putBoolean("destiny_power", this.destiny_power);
            nbt.putBoolean("destiny_reality", this.destiny_reality);
            nbt.putBoolean("destiny_mind", this.destiny_mind);
            nbt.putBoolean("destiny_soul", this.destiny_soul);
            nbt.putBoolean("destiny_time", this.destiny_time);
            nbt.putDouble("kills", this.kills);
            nbt.putBoolean("great_emblem_fly", this.great_emblem_fly);
            nbt.putDouble("ekatebrina_kills", this.ekatebrina_kills);
            nbt.putBoolean("show_skills", this.show_skills);
            nbt.putBoolean("chainsaw_active", this.chainsaw_active);
            nbt.putBoolean("terra_hammer_active", this.terra_hammer_active);
            nbt.putBoolean("nether_hammer_active", this.nether_hammer_active);
            nbt.putDouble("skill_speech_level", this.skill_speech_level);
            nbt.putDouble("skill_speech_points", this.skill_speech_points);
            nbt.putDouble("skill_speech_points_need", this.skill_speech_points_need);
            nbt.putDouble("level_points", this.level_points);
            nbt.putDouble("player_level", this.player_level);
            nbt.putDouble("level_points_need", this.level_points_need);
            nbt.putDouble("level_skill_points", this.level_skill_points);
            nbt.putBoolean("show_crimson_tears", this.show_crimson_tears);
            nbt.putString("active_quest", this.active_quest);
            nbt.putBoolean("has_active_quest", this.has_active_quest);
            nbt.putString("overworld_quest", this.overworld_quest);
            nbt.putString("nether_quest", this.nether_quest);
            nbt.putString("end_quest", this.end_quest);
            nbt.putString("comets_quest", this.comets_quest);
            nbt.putString("purgatorium_quest", this.purgatorium_quest);
            nbt.putString("eden_quest", this.eden_quest);
            nbt.putString("rayana_quest", this.rayana_quest);
            nbt.putString("karvat_quest", this.karvat_quest);
            nbt.putString("volcanech_quest", this.volcanech_quest);
            nbt.putString("amber_quest", this.amber_quest);
            nbt.putDouble("quest_overworld_stage", this.quest_overworld_stage);
            nbt.putDouble("active_quest_id", this.active_quest_id);
            nbt.putDouble("quest_nether_stage", this.quest_nether_stage);
            nbt.putDouble("quest_end_stage", this.quest_end_stage);
            nbt.putDouble("quest_comets_stage", this.quest_comets_stage);
            nbt.putDouble("quest_purgatorium_stage", this.quest_purgatorium_stage);
            nbt.putDouble("quest_eden_stage", this.quest_eden_stage);
            nbt.putDouble("quest_rayana_stage", this.quest_rayana_stage);
            nbt.putDouble("quest_karvat_stage", this.quest_karvat_stage);
            nbt.putDouble("quest_volcanech_stage", this.quest_volcanech_stage);
            nbt.putDouble("quest_amber_stage", this.quest_amber_stage);
            nbt.putDouble("comet_fleas_killed", this.comet_fleas_killed);
            nbt.putDouble("eternal_dawn_kills", this.eternal_dawn_kills);
            nbt.putDouble("celestial_comets_x", this.celestial_comets_x);
            nbt.putDouble("celestial_comets_y", this.celestial_comets_y);
            nbt.putDouble("celestial_comets_z", this.celestial_comets_z);
            nbt.putDouble("celestial_eden_x", this.celestial_eden_x);
            nbt.putDouble("celestial_eden_y", this.celestial_eden_y);
            nbt.putDouble("celestial_eden_z", this.celestial_eden_z);
            nbt.putBoolean("celestial_comets_binded", this.celestial_comets_binded);
            nbt.putBoolean("celestial_eden_binded", this.celestial_eden_binded);
            nbt.putBoolean("guitar_skill", this.guitar_skill);
            nbt.putDouble("guitar_points", this.guitar_points);
            nbt.putDouble("ender_dragon_kills", this.ender_dragon_kills);
            nbt.putDouble("wither_kills", this.wither_kills);
            nbt.putDouble("elder_guardian_kills", this.elder_guardian_kills);
            nbt.putDouble("warden_kills", this.warden_kills);
            nbt.putDouble("dice_player", this.dice_player);
            nbt.putDouble("dice_bartender", this.dice_bartender);
            nbt.putBoolean("eternity_hammer_active", this.eternity_hammer_active);
            nbt.putBoolean("spawn_lenot", this.spawn_lenot);
            nbt.putDouble("skill_catching_level", this.skill_catching_level);
            nbt.putDouble("skill_catching_points", this.skill_catching_points);
            nbt.putDouble("skill_catching_points_need", this.skill_catching_points_need);
            nbt.putDouble("skill_slaying_level", this.skill_slaying_level);
            nbt.putDouble("skill_slaying_points", this.skill_slaying_points);
            nbt.putDouble("skill_slaying_points_need", this.skill_slaying_points_need);
            nbt.putBoolean("order_learned", this.order_learned);
            nbt.putDouble("skill_archaeology_level", this.skill_archaeology_level);
            nbt.putDouble("skill_archaeology_points", this.skill_archaeology_points);
            nbt.putDouble("skill_archaeology_poins_need", this.skill_archaeology_poins_need);
            nbt.putBoolean("tooltips_enabled", this.tooltips_enabled);
            nbt.putDouble("mucunfectio_crab_kills", this.mucunfectio_crab_kills);
            nbt.putDouble("smuciel_kills", this.smuciel_kills);
            nbt.putDouble("arei_wings_cooldown", this.arei_wings_cooldown);
            nbt.putDouble("ekatebrina_tier_2_kills", this.ekatebrina_tier_2_kills);
            nbt.putDouble("ice_dragon_kills", this.ice_dragon_kills);
            nbt.putBoolean("calamity_ring_equipped", this.calamity_ring_equipped);
            nbt.putBoolean("the_ultimate_one_equipped", this.the_ultimate_one_equipped);
            nbt.putBoolean("ring_of_the_crimson_tears_equipped", this.ring_of_the_crimson_tears_equipped);
            nbt.putBoolean("watching_sphere_equipped", this.watching_sphere_equipped);
            nbt.putBoolean("arei_wings_equipped", this.arei_wings_equipped);
            nbt.putBoolean("stupid_way_mite", this.stupid_way_mite);
            nbt.putBoolean("stupid_way_nettle", this.stupid_way_nettle);
            nbt.putBoolean("stupid_way_unahzaal_cupcake", this.stupid_way_unahzaal_cupcake);
            nbt.putDouble("crabzilla_kills", this.crabzilla_kills);
            nbt.putBoolean("unahzaal_summonings_on", this.unahzaal_summonings_on);
            nbt.putString("tamed_gultravs", this.tamed_gultravs);
            nbt.putString("tamed_raccoons", this.tamed_raccoons);
            nbt.putString("tamed_tarkos", this.tamed_tarkos);
            nbt.putDouble("skill_archery_level", this.skill_archery_level);
            nbt.putDouble("skill_archery_points", this.skill_archery_points);
            nbt.putDouble("skill_archery_points_need", this.skill_archery_points_need);
            nbt.putDouble("ranged_damage_boost", this.ranged_damage_boost);
            nbt.putDouble("dreadful_sapling_kills", this.dreadful_sapling_kills);
            nbt.putDouble("ekatebrina_tier_iii_kills", this.ekatebrina_tier_iii_kills);
            nbt.putDouble("everfrost_serpent_kills", this.everfrost_serpent_kills);
            nbt.putString("killed_bosses", this.killed_bosses);
            nbt.putDouble("unahzaal_wish_boost", this.unahzaal_wish_boost);
            nbt.putBoolean("unahzaal_wish_activated", this.unahzaal_wish_activated);
            nbt.putBoolean("third_eye_boosted", this.third_eye_boosted);
            nbt.putBoolean("third_eye_equipped", this.third_eye_equipped);
            nbt.putDouble("grotesterk_kills", this.grotesterk_kills);
            nbt.putDouble("eye_of_unahzaal_kills", this.eye_of_unahzaal_kills);
            nbt.putDouble("blood_moon_mobs_kills", this.blood_moon_mobs_kills);
            nbt.putDouble("blue_moon_mobs_kills", this.blue_moon_mobs_kills);
            nbt.putString("lunar_event_journal", this.lunar_event_journal);
            nbt.putDouble("abyssaliel_kills", this.abyssaliel_kills);
            nbt.putBoolean("lunar_alive", this.lunar_alive);
            nbt.putDouble("moonworm_kills", this.moonworm_kills);
            nbt.putDouble("fall_distance", this.fall_distance);
            nbt.putBoolean("the_ultimate_two_equipped", this.the_ultimate_two_equipped);
            nbt.putBoolean("fort_of_the_undead_equipped", this.fort_of_the_undead_equipped);
            nbt.putBoolean("storm_necklace_equipped", this.storm_necklace_equipped);
            nbt.putBoolean("show_ammo_overlay", this.show_ammo_overlay);
            return nbt;
        }

        public void deserializeNBT(HolderLookup.Provider lookupProvider, CompoundTag nbt) {
            this.skill_digging_level = nbt.getDouble("skill_digging_level");
            this.skill_digging_points = nbt.getDouble("skill_digging_points");
            this.skill_digging_points_need = nbt.getDouble("skill_digging_points_need");
            this.skill_fishing_level = nbt.getDouble("skill_fishing_level");
            this.skill_fishing_points = nbt.getDouble("skill_fishing_points");
            this.skill_fishing_points_need = nbt.getDouble("skill_fishing_points_need");
            this.skill_growing_level = nbt.getDouble("skill_growing_level");
            this.skill_growing_points = nbt.getDouble("skill_growing_points");
            this.skill_growing_points_need = nbt.getDouble("skill_growing_points_need");
            this.skill_sorcery_level = nbt.getDouble("skill_sorcery_level");
            this.skill_sorcery_points = nbt.getDouble("skill_sorcery_points");
            this.skill_sorcery_points_need = nbt.getDouble("skill_sorcery_points_need");
            this.firstmission = nbt.getDouble("firstmission");
            this.show_essence = nbt.getBoolean("show_essence");
            this.tefius = nbt.getDouble("tefius");
            this.isaris = nbt.getDouble("isaris");
            this.ayeris = nbt.getDouble("ayeris");
            this.tefiusmax = nbt.getDouble("tefiusmax");
            this.isarismax = nbt.getDouble("isarismax");
            this.ayerismax = nbt.getDouble("ayerismax");
            this.isaris_boosted = nbt.getBoolean("isaris_boosted");
            this.ayeris_boosted = nbt.getBoolean("ayeris_boosted");
            this.tefius_boosted = nbt.getBoolean("tefius_boosted");
            this.truadamantite_boosted = nbt.getBoolean("truadamantite_boosted");
            this.dark_mage_boosted = nbt.getBoolean("dark_mage_boosted");
            this.iwa_cooldown = nbt.getDouble("iwa_cooldown");
            this.amber_quest_progress = nbt.getDouble("amber_quest_progress");
            this.chthonic_boosted = nbt.getBoolean("chthonic_boosted");
            this.orichancum_boosted = nbt.getBoolean("orichancum_boosted");
            this.unahzaal_boosted = nbt.getBoolean("unahzaal_boosted");
            this.spawn_arky = nbt.getBoolean("spawn_arky");
            this.spawn_dylan_moremi = nbt.getBoolean("spawn_dylan_moremi");
            this.otherworldly_eyes_on = nbt.getBoolean("otherworldly_eyes_on");
            this.arsonist_of_lands_on = nbt.getBoolean("arsonist_of_lands_on");
            this.vivid_kills = nbt.getDouble("vivid_kills");
            this.martyr_kills = nbt.getDouble("martyr_kills");
            this.kraken_kills = nbt.getDouble("kraken_kills");
            this.terribletree_kills = nbt.getDouble("terribletree_kills");
            this.rockblaze_kills = nbt.getDouble("rockblaze_kills");
            this.nyetet_kills = nbt.getDouble("nyetet_kills");
            this.jaghax_kills = nbt.getDouble("jaghax_kills");
            this.pterion_kills = nbt.getDouble("pterion_kills");
            this.arla_kills = nbt.getDouble("arla_kills");
            this.haciru_kills = nbt.getDouble("haciru_kills");
            this.ikkorh_kills = nbt.getDouble("ikkorh_kills");
            this.hirots_kills = nbt.getDouble("hirots_kills");
            this.enicrih_kills = nbt.getDouble("enicrih_kills");
            this.arahulum_kills = nbt.getDouble("arahulum_kills");
            this.volcanicgolem_kills = nbt.getDouble("volcanicgolem_kills");
            this.xaxxasxix_kills = nbt.getDouble("xaxxasxix_kills");
            this.unahzaal_kills = nbt.getDouble("unahzaal_kills");
            this.halloweenspirit_kills = nbt.getDouble("halloweenspirit_kills");
            this.brimstoneagaric_kills = nbt.getDouble("brimstoneagaric_kills");
            this.areispirit_kills = nbt.getDouble("areispirit_kills");
            this.william_kills = nbt.getDouble("william_kills");
            this.piglinwarlock_kills = nbt.getDouble("piglinwarlock_kills");
            this.tsarofpiglins_kills = nbt.getDouble("tsarofpiglins_kills");
            this.khogachi_kills = nbt.getDouble("khogachi_kills");
            this.ravritequeen_kills = nbt.getDouble("ravritequeen_kills");
            this.skill_fear_level = nbt.getDouble("skill_fear_level");
            this.skill_fear_points = nbt.getDouble("skill_fear_points");
            this.skill_fear_points_need = nbt.getDouble("skill_fear_points_need");
            this.fear_counting = nbt.getDouble("fear_counting");
            this.crimson_tears = nbt.getDouble("crimson_tears");
            this.humanity = nbt.getDouble("humanity");
            this.luciden_kills = nbt.getDouble("luciden_kills");
            this.noxifer_kills = nbt.getDouble("noxifer_kills");
            this.destiny_space = nbt.getBoolean("destiny_space");
            this.destiny_power = nbt.getBoolean("destiny_power");
            this.destiny_reality = nbt.getBoolean("destiny_reality");
            this.destiny_mind = nbt.getBoolean("destiny_mind");
            this.destiny_soul = nbt.getBoolean("destiny_soul");
            this.destiny_time = nbt.getBoolean("destiny_time");
            this.kills = nbt.getDouble("kills");
            this.great_emblem_fly = nbt.getBoolean("great_emblem_fly");
            this.ekatebrina_kills = nbt.getDouble("ekatebrina_kills");
            this.show_skills = nbt.getBoolean("show_skills");
            this.chainsaw_active = nbt.getBoolean("chainsaw_active");
            this.terra_hammer_active = nbt.getBoolean("terra_hammer_active");
            this.nether_hammer_active = nbt.getBoolean("nether_hammer_active");
            this.skill_speech_level = nbt.getDouble("skill_speech_level");
            this.skill_speech_points = nbt.getDouble("skill_speech_points");
            this.skill_speech_points_need = nbt.getDouble("skill_speech_points_need");
            this.level_points = nbt.getDouble("level_points");
            this.player_level = nbt.getDouble("player_level");
            this.level_points_need = nbt.getDouble("level_points_need");
            this.level_skill_points = nbt.getDouble("level_skill_points");
            this.show_crimson_tears = nbt.getBoolean("show_crimson_tears");
            this.active_quest = nbt.getString("active_quest");
            this.has_active_quest = nbt.getBoolean("has_active_quest");
            this.overworld_quest = nbt.getString("overworld_quest");
            this.nether_quest = nbt.getString("nether_quest");
            this.end_quest = nbt.getString("end_quest");
            this.comets_quest = nbt.getString("comets_quest");
            this.purgatorium_quest = nbt.getString("purgatorium_quest");
            this.eden_quest = nbt.getString("eden_quest");
            this.rayana_quest = nbt.getString("rayana_quest");
            this.karvat_quest = nbt.getString("karvat_quest");
            this.volcanech_quest = nbt.getString("volcanech_quest");
            this.amber_quest = nbt.getString("amber_quest");
            this.quest_overworld_stage = nbt.getDouble("quest_overworld_stage");
            this.active_quest_id = nbt.getDouble("active_quest_id");
            this.quest_nether_stage = nbt.getDouble("quest_nether_stage");
            this.quest_end_stage = nbt.getDouble("quest_end_stage");
            this.quest_comets_stage = nbt.getDouble("quest_comets_stage");
            this.quest_purgatorium_stage = nbt.getDouble("quest_purgatorium_stage");
            this.quest_eden_stage = nbt.getDouble("quest_eden_stage");
            this.quest_rayana_stage = nbt.getDouble("quest_rayana_stage");
            this.quest_karvat_stage = nbt.getDouble("quest_karvat_stage");
            this.quest_volcanech_stage = nbt.getDouble("quest_volcanech_stage");
            this.quest_amber_stage = nbt.getDouble("quest_amber_stage");
            this.comet_fleas_killed = nbt.getDouble("comet_fleas_killed");
            this.eternal_dawn_kills = nbt.getDouble("eternal_dawn_kills");
            this.celestial_comets_x = nbt.getDouble("celestial_comets_x");
            this.celestial_comets_y = nbt.getDouble("celestial_comets_y");
            this.celestial_comets_z = nbt.getDouble("celestial_comets_z");
            this.celestial_eden_x = nbt.getDouble("celestial_eden_x");
            this.celestial_eden_y = nbt.getDouble("celestial_eden_y");
            this.celestial_eden_z = nbt.getDouble("celestial_eden_z");
            this.celestial_comets_binded = nbt.getBoolean("celestial_comets_binded");
            this.celestial_eden_binded = nbt.getBoolean("celestial_eden_binded");
            this.guitar_skill = nbt.getBoolean("guitar_skill");
            this.guitar_points = nbt.getDouble("guitar_points");
            this.ender_dragon_kills = nbt.getDouble("ender_dragon_kills");
            this.wither_kills = nbt.getDouble("wither_kills");
            this.elder_guardian_kills = nbt.getDouble("elder_guardian_kills");
            this.warden_kills = nbt.getDouble("warden_kills");
            this.dice_player = nbt.getDouble("dice_player");
            this.dice_bartender = nbt.getDouble("dice_bartender");
            this.eternity_hammer_active = nbt.getBoolean("eternity_hammer_active");
            this.spawn_lenot = nbt.getBoolean("spawn_lenot");
            this.skill_catching_level = nbt.getDouble("skill_catching_level");
            this.skill_catching_points = nbt.getDouble("skill_catching_points");
            this.skill_catching_points_need = nbt.getDouble("skill_catching_points_need");
            this.skill_slaying_level = nbt.getDouble("skill_slaying_level");
            this.skill_slaying_points = nbt.getDouble("skill_slaying_points");
            this.skill_slaying_points_need = nbt.getDouble("skill_slaying_points_need");
            this.order_learned = nbt.getBoolean("order_learned");
            this.skill_archaeology_level = nbt.getDouble("skill_archaeology_level");
            this.skill_archaeology_points = nbt.getDouble("skill_archaeology_points");
            this.skill_archaeology_poins_need = nbt.getDouble("skill_archaeology_poins_need");
            this.tooltips_enabled = nbt.getBoolean("tooltips_enabled");
            this.mucunfectio_crab_kills = nbt.getDouble("mucunfectio_crab_kills");
            this.smuciel_kills = nbt.getDouble("smuciel_kills");
            this.arei_wings_cooldown = nbt.getDouble("arei_wings_cooldown");
            this.ekatebrina_tier_2_kills = nbt.getDouble("ekatebrina_tier_2_kills");
            this.ice_dragon_kills = nbt.getDouble("ice_dragon_kills");
            this.calamity_ring_equipped = nbt.getBoolean("calamity_ring_equipped");
            this.the_ultimate_one_equipped = nbt.getBoolean("the_ultimate_one_equipped");
            this.ring_of_the_crimson_tears_equipped = nbt.getBoolean("ring_of_the_crimson_tears_equipped");
            this.watching_sphere_equipped = nbt.getBoolean("watching_sphere_equipped");
            this.arei_wings_equipped = nbt.getBoolean("arei_wings_equipped");
            this.stupid_way_mite = nbt.getBoolean("stupid_way_mite");
            this.stupid_way_nettle = nbt.getBoolean("stupid_way_nettle");
            this.stupid_way_unahzaal_cupcake = nbt.getBoolean("stupid_way_unahzaal_cupcake");
            this.crabzilla_kills = nbt.getDouble("crabzilla_kills");
            this.unahzaal_summonings_on = nbt.getBoolean("unahzaal_summonings_on");
            this.tamed_gultravs = nbt.getString("tamed_gultravs");
            this.tamed_raccoons = nbt.getString("tamed_raccoons");
            this.tamed_tarkos = nbt.getString("tamed_tarkos");
            this.skill_archery_level = nbt.getDouble("skill_archery_level");
            this.skill_archery_points = nbt.getDouble("skill_archery_points");
            this.skill_archery_points_need = nbt.getDouble("skill_archery_points_need");
            this.ranged_damage_boost = nbt.getDouble("ranged_damage_boost");
            this.dreadful_sapling_kills = nbt.getDouble("dreadful_sapling_kills");
            this.ekatebrina_tier_iii_kills = nbt.getDouble("ekatebrina_tier_iii_kills");
            this.everfrost_serpent_kills = nbt.getDouble("everfrost_serpent_kills");
            this.killed_bosses = nbt.getString("killed_bosses");
            this.unahzaal_wish_boost = nbt.getDouble("unahzaal_wish_boost");
            this.unahzaal_wish_activated = nbt.getBoolean("unahzaal_wish_activated");
            this.third_eye_boosted = nbt.getBoolean("third_eye_boosted");
            this.third_eye_equipped = nbt.getBoolean("third_eye_equipped");
            this.grotesterk_kills = nbt.getDouble("grotesterk_kills");
            this.eye_of_unahzaal_kills = nbt.getDouble("eye_of_unahzaal_kills");
            this.blood_moon_mobs_kills = nbt.getDouble("blood_moon_mobs_kills");
            this.blue_moon_mobs_kills = nbt.getDouble("blue_moon_mobs_kills");
            this.lunar_event_journal = nbt.getString("lunar_event_journal");
            this.abyssaliel_kills = nbt.getDouble("abyssaliel_kills");
            this.lunar_alive = nbt.getBoolean("lunar_alive");
            this.moonworm_kills = nbt.getDouble("moonworm_kills");
            this.fall_distance = nbt.getDouble("fall_distance");
            this.the_ultimate_two_equipped = nbt.getBoolean("the_ultimate_two_equipped");
            this.fort_of_the_undead_equipped = nbt.getBoolean("fort_of_the_undead_equipped");
            this.storm_necklace_equipped = nbt.getBoolean("storm_necklace_equipped");
            this.show_ammo_overlay = nbt.getBoolean("show_ammo_overlay");
        }

        public void syncPlayerVariables(Entity entity) {
            if (entity instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)entity;
                PacketDistributor.sendToPlayer((ServerPlayer)serverPlayer, (CustomPacketPayload)new PlayerVariablesSyncMessage(this), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }
    }

    public static class MapVariables
    extends SavedData {
        public static final String DATA_NAME = "eternal_tales_mapvars";
        public double eternaltowngen = 2.0;
        public boolean maze_visited = false;
        public boolean unahzaal_killed = false;
        public boolean arahulum_killed = false;
        public boolean eternity_darkness = false;
        public boolean kraken_killed = false;
        public boolean block_of_worthless = false;
        public String lunar_event = "none";
        public boolean blood_moon = false;
        public boolean blue_moon = false;
        public boolean clown_moon = false;
        public String holiday = "\"\"";
        static MapVariables clientSide = new MapVariables();

        public static MapVariables load(CompoundTag tag, HolderLookup.Provider lookupProvider) {
            MapVariables data = new MapVariables();
            data.read(tag, lookupProvider);
            return data;
        }

        public void read(CompoundTag nbt, HolderLookup.Provider lookupProvider) {
            this.eternaltowngen = nbt.getDouble("eternaltowngen");
            this.maze_visited = nbt.getBoolean("maze_visited");
            this.unahzaal_killed = nbt.getBoolean("unahzaal_killed");
            this.arahulum_killed = nbt.getBoolean("arahulum_killed");
            this.eternity_darkness = nbt.getBoolean("eternity_darkness");
            this.kraken_killed = nbt.getBoolean("kraken_killed");
            this.block_of_worthless = nbt.getBoolean("block_of_worthless");
            this.lunar_event = nbt.getString("lunar_event");
            this.blood_moon = nbt.getBoolean("blood_moon");
            this.blue_moon = nbt.getBoolean("blue_moon");
            this.clown_moon = nbt.getBoolean("clown_moon");
            this.holiday = nbt.getString("holiday");
        }

        public CompoundTag save(CompoundTag nbt, HolderLookup.Provider lookupProvider) {
            nbt.putDouble("eternaltowngen", this.eternaltowngen);
            nbt.putBoolean("maze_visited", this.maze_visited);
            nbt.putBoolean("unahzaal_killed", this.unahzaal_killed);
            nbt.putBoolean("arahulum_killed", this.arahulum_killed);
            nbt.putBoolean("eternity_darkness", this.eternity_darkness);
            nbt.putBoolean("kraken_killed", this.kraken_killed);
            nbt.putBoolean("block_of_worthless", this.block_of_worthless);
            nbt.putString("lunar_event", this.lunar_event);
            nbt.putBoolean("blood_moon", this.blood_moon);
            nbt.putBoolean("blue_moon", this.blue_moon);
            nbt.putBoolean("clown_moon", this.clown_moon);
            nbt.putString("holiday", this.holiday);
            return nbt;
        }

        public void syncData(LevelAccessor world) {
            this.setDirty();
            if (world instanceof Level && !world.isClientSide()) {
                PacketDistributor.sendToAllPlayers((CustomPacketPayload)new SavedDataSyncMessage(0, this), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }

        public static MapVariables get(LevelAccessor world) {
            if (world instanceof ServerLevelAccessor) {
                ServerLevelAccessor serverLevelAcc = (ServerLevelAccessor)world;
                return (MapVariables)serverLevelAcc.getLevel().getServer().getLevel(Level.OVERWORLD).getDataStorage().computeIfAbsent(new SavedData.Factory(MapVariables::new, MapVariables::load), DATA_NAME);
            }
            return clientSide;
        }
    }

    public static class WorldVariables
    extends SavedData {
        public static final String DATA_NAME = "eternal_tales_worldvars";
        public boolean amber_visited = false;
        public boolean unahzaal_visited = false;
        public boolean superduperdarknessmode = false;
        static WorldVariables clientSide = new WorldVariables();

        public static WorldVariables load(CompoundTag tag, HolderLookup.Provider lookupProvider) {
            WorldVariables data = new WorldVariables();
            data.read(tag, lookupProvider);
            return data;
        }

        public void read(CompoundTag nbt, HolderLookup.Provider lookupProvider) {
            this.amber_visited = nbt.getBoolean("amber_visited");
            this.unahzaal_visited = nbt.getBoolean("unahzaal_visited");
            this.superduperdarknessmode = nbt.getBoolean("superduperdarknessmode");
        }

        public CompoundTag save(CompoundTag nbt, HolderLookup.Provider lookupProvider) {
            nbt.putBoolean("amber_visited", this.amber_visited);
            nbt.putBoolean("unahzaal_visited", this.unahzaal_visited);
            nbt.putBoolean("superduperdarknessmode", this.superduperdarknessmode);
            return nbt;
        }

        public void syncData(LevelAccessor world) {
            this.setDirty();
            if (world instanceof ServerLevel) {
                ServerLevel level = (ServerLevel)world;
                PacketDistributor.sendToPlayersInDimension((ServerLevel)level, (CustomPacketPayload)new SavedDataSyncMessage(1, this), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }

        public static WorldVariables get(LevelAccessor world) {
            if (world instanceof ServerLevel) {
                ServerLevel level = (ServerLevel)world;
                return (WorldVariables)level.getDataStorage().computeIfAbsent(new SavedData.Factory(WorldVariables::new, WorldVariables::load), DATA_NAME);
            }
            return clientSide;
        }
    }

    @EventBusSubscriber
    public static class EventBusVariableHandlers {
        @SubscribeEvent
        public static void onPlayerLoggedInSyncPlayerVariables(PlayerEvent.PlayerLoggedInEvent event) {
            Player player = event.getEntity();
            if (player instanceof ServerPlayer) {
                ServerPlayer player2 = (ServerPlayer)player;
                ((PlayerVariables)player2.getData(PLAYER_VARIABLES)).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void onPlayerRespawnedSyncPlayerVariables(PlayerEvent.PlayerRespawnEvent event) {
            Player player = event.getEntity();
            if (player instanceof ServerPlayer) {
                ServerPlayer player2 = (ServerPlayer)player;
                ((PlayerVariables)player2.getData(PLAYER_VARIABLES)).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void onPlayerChangedDimensionSyncPlayerVariables(PlayerEvent.PlayerChangedDimensionEvent event) {
            Player player = event.getEntity();
            if (player instanceof ServerPlayer) {
                ServerPlayer player2 = (ServerPlayer)player;
                ((PlayerVariables)player2.getData(PLAYER_VARIABLES)).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void clonePlayer(PlayerEvent.Clone event) {
            PlayerVariables original = (PlayerVariables)event.getOriginal().getData(PLAYER_VARIABLES);
            PlayerVariables clone = new PlayerVariables();
            clone.skill_digging_level = original.skill_digging_level;
            clone.skill_digging_points = original.skill_digging_points;
            clone.skill_digging_points_need = original.skill_digging_points_need;
            clone.skill_fishing_level = original.skill_fishing_level;
            clone.skill_fishing_points = original.skill_fishing_points;
            clone.skill_fishing_points_need = original.skill_fishing_points_need;
            clone.skill_growing_level = original.skill_growing_level;
            clone.skill_growing_points = original.skill_growing_points;
            clone.skill_growing_points_need = original.skill_growing_points_need;
            clone.skill_sorcery_level = original.skill_sorcery_level;
            clone.skill_sorcery_points = original.skill_sorcery_points;
            clone.skill_sorcery_points_need = original.skill_sorcery_points_need;
            clone.firstmission = original.firstmission;
            clone.show_essence = original.show_essence;
            clone.tefius = original.tefius;
            clone.isaris = original.isaris;
            clone.ayeris = original.ayeris;
            clone.tefiusmax = original.tefiusmax;
            clone.isarismax = original.isarismax;
            clone.ayerismax = original.ayerismax;
            clone.isaris_boosted = original.isaris_boosted;
            clone.ayeris_boosted = original.ayeris_boosted;
            clone.tefius_boosted = original.tefius_boosted;
            clone.truadamantite_boosted = original.truadamantite_boosted;
            clone.dark_mage_boosted = original.dark_mage_boosted;
            clone.amber_quest_progress = original.amber_quest_progress;
            clone.chthonic_boosted = original.chthonic_boosted;
            clone.orichancum_boosted = original.orichancum_boosted;
            clone.unahzaal_boosted = original.unahzaal_boosted;
            clone.spawn_arky = original.spawn_arky;
            clone.spawn_dylan_moremi = original.spawn_dylan_moremi;
            clone.arsonist_of_lands_on = original.arsonist_of_lands_on;
            clone.vivid_kills = original.vivid_kills;
            clone.martyr_kills = original.martyr_kills;
            clone.kraken_kills = original.kraken_kills;
            clone.terribletree_kills = original.terribletree_kills;
            clone.rockblaze_kills = original.rockblaze_kills;
            clone.nyetet_kills = original.nyetet_kills;
            clone.jaghax_kills = original.jaghax_kills;
            clone.pterion_kills = original.pterion_kills;
            clone.arla_kills = original.arla_kills;
            clone.haciru_kills = original.haciru_kills;
            clone.ikkorh_kills = original.ikkorh_kills;
            clone.hirots_kills = original.hirots_kills;
            clone.enicrih_kills = original.enicrih_kills;
            clone.arahulum_kills = original.arahulum_kills;
            clone.volcanicgolem_kills = original.volcanicgolem_kills;
            clone.xaxxasxix_kills = original.xaxxasxix_kills;
            clone.unahzaal_kills = original.unahzaal_kills;
            clone.halloweenspirit_kills = original.halloweenspirit_kills;
            clone.brimstoneagaric_kills = original.brimstoneagaric_kills;
            clone.areispirit_kills = original.areispirit_kills;
            clone.william_kills = original.william_kills;
            clone.piglinwarlock_kills = original.piglinwarlock_kills;
            clone.tsarofpiglins_kills = original.tsarofpiglins_kills;
            clone.khogachi_kills = original.khogachi_kills;
            clone.ravritequeen_kills = original.ravritequeen_kills;
            clone.skill_fear_level = original.skill_fear_level;
            clone.skill_fear_points = original.skill_fear_points;
            clone.skill_fear_points_need = original.skill_fear_points_need;
            clone.crimson_tears = original.crimson_tears;
            clone.humanity = original.humanity;
            clone.luciden_kills = original.luciden_kills;
            clone.noxifer_kills = original.noxifer_kills;
            clone.destiny_space = original.destiny_space;
            clone.destiny_power = original.destiny_power;
            clone.destiny_reality = original.destiny_reality;
            clone.destiny_mind = original.destiny_mind;
            clone.destiny_soul = original.destiny_soul;
            clone.destiny_time = original.destiny_time;
            clone.ekatebrina_kills = original.ekatebrina_kills;
            clone.show_skills = original.show_skills;
            clone.chainsaw_active = original.chainsaw_active;
            clone.terra_hammer_active = original.terra_hammer_active;
            clone.nether_hammer_active = original.nether_hammer_active;
            clone.skill_speech_level = original.skill_speech_level;
            clone.skill_speech_points = original.skill_speech_points;
            clone.skill_speech_points_need = original.skill_speech_points_need;
            clone.level_points = original.level_points;
            clone.player_level = original.player_level;
            clone.level_points_need = original.level_points_need;
            clone.level_skill_points = original.level_skill_points;
            clone.show_crimson_tears = original.show_crimson_tears;
            clone.active_quest = original.active_quest;
            clone.has_active_quest = original.has_active_quest;
            clone.overworld_quest = original.overworld_quest;
            clone.nether_quest = original.nether_quest;
            clone.end_quest = original.end_quest;
            clone.comets_quest = original.comets_quest;
            clone.purgatorium_quest = original.purgatorium_quest;
            clone.eden_quest = original.eden_quest;
            clone.rayana_quest = original.rayana_quest;
            clone.karvat_quest = original.karvat_quest;
            clone.volcanech_quest = original.volcanech_quest;
            clone.amber_quest = original.amber_quest;
            clone.quest_overworld_stage = original.quest_overworld_stage;
            clone.active_quest_id = original.active_quest_id;
            clone.quest_nether_stage = original.quest_nether_stage;
            clone.quest_end_stage = original.quest_end_stage;
            clone.quest_comets_stage = original.quest_comets_stage;
            clone.quest_purgatorium_stage = original.quest_purgatorium_stage;
            clone.quest_eden_stage = original.quest_eden_stage;
            clone.quest_rayana_stage = original.quest_rayana_stage;
            clone.quest_karvat_stage = original.quest_karvat_stage;
            clone.quest_volcanech_stage = original.quest_volcanech_stage;
            clone.quest_amber_stage = original.quest_amber_stage;
            clone.comet_fleas_killed = original.comet_fleas_killed;
            clone.eternal_dawn_kills = original.eternal_dawn_kills;
            clone.celestial_comets_x = original.celestial_comets_x;
            clone.celestial_comets_y = original.celestial_comets_y;
            clone.celestial_comets_z = original.celestial_comets_z;
            clone.celestial_eden_x = original.celestial_eden_x;
            clone.celestial_eden_y = original.celestial_eden_y;
            clone.celestial_eden_z = original.celestial_eden_z;
            clone.celestial_comets_binded = original.celestial_comets_binded;
            clone.celestial_eden_binded = original.celestial_eden_binded;
            clone.guitar_skill = original.guitar_skill;
            clone.guitar_points = original.guitar_points;
            clone.ender_dragon_kills = original.ender_dragon_kills;
            clone.wither_kills = original.wither_kills;
            clone.elder_guardian_kills = original.elder_guardian_kills;
            clone.warden_kills = original.warden_kills;
            clone.dice_player = original.dice_player;
            clone.dice_bartender = original.dice_bartender;
            clone.eternity_hammer_active = original.eternity_hammer_active;
            clone.spawn_lenot = original.spawn_lenot;
            clone.skill_catching_level = original.skill_catching_level;
            clone.skill_catching_points = original.skill_catching_points;
            clone.skill_catching_points_need = original.skill_catching_points_need;
            clone.skill_slaying_level = original.skill_slaying_level;
            clone.skill_slaying_points = original.skill_slaying_points;
            clone.skill_slaying_points_need = original.skill_slaying_points_need;
            clone.order_learned = original.order_learned;
            clone.skill_archaeology_level = original.skill_archaeology_level;
            clone.skill_archaeology_points = original.skill_archaeology_points;
            clone.skill_archaeology_poins_need = original.skill_archaeology_poins_need;
            clone.tooltips_enabled = original.tooltips_enabled;
            clone.mucunfectio_crab_kills = original.mucunfectio_crab_kills;
            clone.smuciel_kills = original.smuciel_kills;
            clone.arei_wings_cooldown = original.arei_wings_cooldown;
            clone.ekatebrina_tier_2_kills = original.ekatebrina_tier_2_kills;
            clone.ice_dragon_kills = original.ice_dragon_kills;
            clone.stupid_way_mite = original.stupid_way_mite;
            clone.stupid_way_nettle = original.stupid_way_nettle;
            clone.stupid_way_unahzaal_cupcake = original.stupid_way_unahzaal_cupcake;
            clone.crabzilla_kills = original.crabzilla_kills;
            clone.unahzaal_summonings_on = original.unahzaal_summonings_on;
            clone.tamed_gultravs = original.tamed_gultravs;
            clone.tamed_raccoons = original.tamed_raccoons;
            clone.tamed_tarkos = original.tamed_tarkos;
            clone.skill_archery_level = original.skill_archery_level;
            clone.skill_archery_points = original.skill_archery_points;
            clone.skill_archery_points_need = original.skill_archery_points_need;
            clone.ranged_damage_boost = original.ranged_damage_boost;
            clone.dreadful_sapling_kills = original.dreadful_sapling_kills;
            clone.ekatebrina_tier_iii_kills = original.ekatebrina_tier_iii_kills;
            clone.everfrost_serpent_kills = original.everfrost_serpent_kills;
            clone.killed_bosses = original.killed_bosses;
            clone.unahzaal_wish_boost = original.unahzaal_wish_boost;
            clone.unahzaal_wish_activated = original.unahzaal_wish_activated;
            clone.third_eye_boosted = original.third_eye_boosted;
            clone.grotesterk_kills = original.grotesterk_kills;
            clone.eye_of_unahzaal_kills = original.eye_of_unahzaal_kills;
            clone.blood_moon_mobs_kills = original.blood_moon_mobs_kills;
            clone.blue_moon_mobs_kills = original.blue_moon_mobs_kills;
            clone.lunar_event_journal = original.lunar_event_journal;
            clone.abyssaliel_kills = original.abyssaliel_kills;
            clone.lunar_alive = original.lunar_alive;
            clone.moonworm_kills = original.moonworm_kills;
            clone.fall_distance = original.fall_distance;
            clone.show_ammo_overlay = original.show_ammo_overlay;
            if (!event.isWasDeath()) {
                clone.iwa_cooldown = original.iwa_cooldown;
                clone.otherworldly_eyes_on = original.otherworldly_eyes_on;
                clone.fear_counting = original.fear_counting;
                clone.kills = original.kills;
                clone.great_emblem_fly = original.great_emblem_fly;
                clone.calamity_ring_equipped = original.calamity_ring_equipped;
                clone.the_ultimate_one_equipped = original.the_ultimate_one_equipped;
                clone.ring_of_the_crimson_tears_equipped = original.ring_of_the_crimson_tears_equipped;
                clone.watching_sphere_equipped = original.watching_sphere_equipped;
                clone.arei_wings_equipped = original.arei_wings_equipped;
                clone.third_eye_equipped = original.third_eye_equipped;
                clone.the_ultimate_two_equipped = original.the_ultimate_two_equipped;
                clone.fort_of_the_undead_equipped = original.fort_of_the_undead_equipped;
                clone.storm_necklace_equipped = original.storm_necklace_equipped;
            }
            event.getEntity().setData(PLAYER_VARIABLES, (Object)clone);
        }

        @SubscribeEvent
        public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
            Player player = event.getEntity();
            if (player instanceof ServerPlayer) {
                ServerPlayer player2 = (ServerPlayer)player;
                MapVariables mapdata = MapVariables.get((LevelAccessor)event.getEntity().level());
                WorldVariables worlddata = WorldVariables.get((LevelAccessor)event.getEntity().level());
                if (mapdata != null) {
                    PacketDistributor.sendToPlayer((ServerPlayer)player2, (CustomPacketPayload)new SavedDataSyncMessage(0, mapdata), (CustomPacketPayload[])new CustomPacketPayload[0]);
                }
                if (worlddata != null) {
                    PacketDistributor.sendToPlayer((ServerPlayer)player2, (CustomPacketPayload)new SavedDataSyncMessage(1, worlddata), (CustomPacketPayload[])new CustomPacketPayload[0]);
                }
            }
        }

        @SubscribeEvent
        public static void onPlayerChangedDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
            Player player = event.getEntity();
            if (player instanceof ServerPlayer) {
                ServerPlayer player2 = (ServerPlayer)player;
                WorldVariables worlddata = WorldVariables.get((LevelAccessor)event.getEntity().level());
                if (worlddata != null) {
                    PacketDistributor.sendToPlayer((ServerPlayer)player2, (CustomPacketPayload)new SavedDataSyncMessage(1, worlddata), (CustomPacketPayload[])new CustomPacketPayload[0]);
                }
            }
        }
    }
}

