/*
 * Decompiled with CFR 0.152.
 */
package net.eternal_tales.procedures;

import net.eternal_tales.init.EternalTalesModItems;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.PlayerInfo;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;

public class UraniumCasingOnBlockDestroyedByPlayerProcedure {
    public static void execute(LevelAccessor world, double x, double y, double z, Entity entity) {
        if (entity == null) {
            return;
        }
        ItemStack result = ItemStack.EMPTY;
        if (UraniumCasingOnBlockDestroyedByPlayerProcedure.getEntityGameType(entity) != GameType.CREATIVE) {
            result = new ItemStack((ItemLike)EternalTalesModItems.TREATED_URANIUM.get()).copy();
            String _tagName = "quality";
            double _tagValue = UraniumCasingOnBlockDestroyedByPlayerProcedure.getBlockNBTNumber(world, BlockPos.containing((double)x, (double)y, (double)z), "quality");
            CustomData.update((DataComponentType)DataComponents.CUSTOM_DATA, (ItemStack)result, tag -> tag.putDouble("quality", _tagValue));
            if (world instanceof ServerLevel) {
                ServerLevel _level = (ServerLevel)world;
                ItemEntity entityToSpawn = new ItemEntity((Level)_level, x + 0.5, y + 0.5, z + 0.5, result);
                entityToSpawn.setPickUpDelay(10);
                _level.addFreshEntity((Entity)entityToSpawn);
            }
        }
    }

    private static GameType getEntityGameType(Entity entity) {
        PlayerInfo playerInfo;
        Player player;
        if (entity instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)entity;
            return serverPlayer.gameMode.getGameModeForPlayer();
        }
        if (entity instanceof Player && (player = (Player)entity).level().isClientSide() && (playerInfo = Minecraft.getInstance().getConnection().getPlayerInfo(player.getGameProfile().getId())) != null) {
            return playerInfo.getGameMode();
        }
        return null;
    }

    private static double getBlockNBTNumber(LevelAccessor world, BlockPos pos, String tag) {
        BlockEntity blockEntity = world.getBlockEntity(pos);
        if (blockEntity != null) {
            return blockEntity.getPersistentData().getDouble(tag);
        }
        return -1.0;
    }
}

