/*
 * Decompiled with CFR 0.152.
 */
package net.eternal_tales.world.teleporter;

import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Comparator;
import java.util.Optional;
import java.util.Set;
import net.eternal_tales.init.EternalTalesModBlocks;
import net.minecraft.BlockUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.ai.village.poi.PoiManager;
import net.minecraft.world.entity.ai.village.poi.PoiRecord;
import net.minecraft.world.entity.ai.village.poi.PoiType;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.NetherPortalBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.border.WorldBorder;
import net.minecraft.world.level.levelgen.Heightmap;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.registries.RegisterEvent;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD)
public class VolcanechTeleporter {
    public static Holder<PoiType> poi = null;
    private final ServerLevel level;

    @SubscribeEvent
    public static void registerPointOfInterest(RegisterEvent event) {
        event.register(Registries.POINT_OF_INTEREST_TYPE, registerHelper -> {
            PoiType poiType = new PoiType((Set)ImmutableSet.copyOf((Collection)((Block)EternalTalesModBlocks.VOLCANECH_PORTAL.get()).getStateDefinition().getPossibleStates()), 0, 1);
            registerHelper.register(ResourceLocation.parse((String)"eternal_tales:volcanech_portal"), (Object)poiType);
            poi = BuiltInRegistries.POINT_OF_INTEREST_TYPE.wrapAsHolder((Object)poiType);
        });
    }

    public VolcanechTeleporter(ServerLevel level) {
        this.level = level;
    }

    public Optional<BlockPos> findClosestPortalPosition(BlockPos p_352378_, boolean p_352309_, WorldBorder p_352374_) {
        PoiManager poimanager = this.level.getPoiManager();
        int i = p_352309_ ? 16 : 128;
        poimanager.ensureLoadedAndValid((LevelReader)this.level, p_352378_, i);
        return poimanager.getInSquare(p_230634_ -> p_230634_.is((ResourceKey)poi.unwrapKey().get()), p_352378_, i, PoiManager.Occupancy.ANY).map(PoiRecord::getPos).filter(arg_0 -> ((WorldBorder)p_352374_).isWithinBounds(arg_0)).filter(p_352047_ -> this.level.getBlockState(p_352047_).hasProperty((Property)BlockStateProperties.HORIZONTAL_AXIS)).min(Comparator.comparingDouble(p_352046_ -> p_352046_.distSqr((Vec3i)p_352378_)).thenComparingInt(Vec3i::getY));
    }

    public Optional<BlockUtil.FoundRectangle> createPortal(BlockPos p_77667_, Direction.Axis p_77668_) {
        Direction direction = Direction.get((Direction.AxisDirection)Direction.AxisDirection.POSITIVE, (Direction.Axis)p_77668_);
        double d0 = -1.0;
        BlockPos blockpos = null;
        double d1 = -1.0;
        BlockPos blockpos1 = null;
        WorldBorder worldborder = this.level.getWorldBorder();
        int i = Math.min(this.level.getMaxBuildHeight(), this.level.getMinBuildHeight() + this.level.getLogicalHeight()) - 1;
        boolean j = true;
        BlockPos.MutableBlockPos blockpos$mutableblockpos = p_77667_.mutable();
        for (BlockPos.MutableBlockPos blockpos$mutableblockpos1 : BlockPos.spiralAround((BlockPos)p_77667_, (int)16, (Direction)Direction.EAST, (Direction)Direction.SOUTH)) {
            int k = Math.min(i, this.level.getHeight(Heightmap.Types.MOTION_BLOCKING, blockpos$mutableblockpos1.getX(), blockpos$mutableblockpos1.getZ()));
            if (!worldborder.isWithinBounds((BlockPos)blockpos$mutableblockpos1) || !worldborder.isWithinBounds((BlockPos)blockpos$mutableblockpos1.move(direction, 1))) continue;
            blockpos$mutableblockpos1.move(direction.getOpposite(), 1);
            for (int l = k; l >= this.level.getMinBuildHeight(); --l) {
                int j1;
                blockpos$mutableblockpos1.setY(l);
                if (!this.canPortalReplaceBlock(blockpos$mutableblockpos1)) continue;
                int i1 = l;
                while (l > this.level.getMinBuildHeight() && this.canPortalReplaceBlock(blockpos$mutableblockpos1.move(Direction.DOWN))) {
                    --l;
                }
                if (l + 4 > i || (j1 = i1 - l) > 0 && j1 < 3) continue;
                blockpos$mutableblockpos1.setY(l);
                if (!this.canHostFrame((BlockPos)blockpos$mutableblockpos1, blockpos$mutableblockpos, direction, 0)) continue;
                double d2 = p_77667_.distSqr((Vec3i)blockpos$mutableblockpos1);
                if (this.canHostFrame((BlockPos)blockpos$mutableblockpos1, blockpos$mutableblockpos, direction, -1) && this.canHostFrame((BlockPos)blockpos$mutableblockpos1, blockpos$mutableblockpos, direction, 1) && (d0 == -1.0 || d0 > d2)) {
                    d0 = d2;
                    blockpos = blockpos$mutableblockpos1.immutable();
                }
                if (d0 != -1.0 || d1 != -1.0 && !(d1 > d2)) continue;
                d1 = d2;
                blockpos1 = blockpos$mutableblockpos1.immutable();
            }
        }
        if (d0 == -1.0 && d1 != -1.0) {
            blockpos = blockpos1;
            d0 = d1;
        }
        if (d0 == -1.0) {
            int i2 = i - 9;
            int k1 = Math.max(this.level.getMinBuildHeight() - -1, 70);
            if (i2 < k1) {
                return Optional.empty();
            }
            blockpos = new BlockPos(p_77667_.getX() - direction.getStepX() * 1, Mth.clamp((int)p_77667_.getY(), (int)k1, (int)i2), p_77667_.getZ() - direction.getStepZ() * 1).immutable();
            blockpos = worldborder.clampToBounds(blockpos);
            Direction direction1 = direction.getClockWise();
            for (int i3 = -1; i3 < 2; ++i3) {
                for (int j3 = 0; j3 < 2; ++j3) {
                    for (int k3 = -1; k3 < 3; ++k3) {
                        BlockState blockstate1 = k3 < 0 ? ((Block)EternalTalesModBlocks.VOLCANECH_BRICKS.get()).defaultBlockState() : Blocks.AIR.defaultBlockState();
                        blockpos$mutableblockpos.setWithOffset((Vec3i)blockpos, j3 * direction.getStepX() + i3 * direction1.getStepX(), k3, j3 * direction.getStepZ() + i3 * direction1.getStepZ());
                        this.level.setBlockAndUpdate((BlockPos)blockpos$mutableblockpos, blockstate1);
                    }
                }
            }
        }
        for (int l1 = -1; l1 < 3; ++l1) {
            for (int j2 = -1; j2 < 4; ++j2) {
                if (l1 != -1 && l1 != 2 && j2 != -1 && j2 != 3) continue;
                blockpos$mutableblockpos.setWithOffset(blockpos, l1 * direction.getStepX(), j2, l1 * direction.getStepZ());
                this.level.setBlock((BlockPos)blockpos$mutableblockpos, ((Block)EternalTalesModBlocks.VOLCANECH_BRICKS.get()).defaultBlockState(), 3);
            }
        }
        BlockState blockstate = (BlockState)((Block)EternalTalesModBlocks.VOLCANECH_PORTAL.get()).defaultBlockState().setValue((Property)NetherPortalBlock.AXIS, (Comparable)p_77668_);
        for (int k2 = 0; k2 < 2; ++k2) {
            for (int l2 = 0; l2 < 3; ++l2) {
                blockpos$mutableblockpos.setWithOffset(blockpos, k2 * direction.getStepX(), l2, k2 * direction.getStepZ());
                this.level.setBlock((BlockPos)blockpos$mutableblockpos, blockstate, 18);
                this.level.getPoiManager().add((BlockPos)blockpos$mutableblockpos, poi);
            }
        }
        return Optional.of(new BlockUtil.FoundRectangle(blockpos.immutable(), 2, 3));
    }

    private boolean canHostFrame(BlockPos p_77662_, BlockPos.MutableBlockPos p_77663_, Direction p_77664_, int p_77665_) {
        Direction direction = p_77664_.getClockWise();
        for (int i = -1; i < 3; ++i) {
            for (int j = -1; j < 4; ++j) {
                p_77663_.setWithOffset((Vec3i)p_77662_, p_77664_.getStepX() * i + direction.getStepX() * p_77665_, j, p_77664_.getStepZ() * i + direction.getStepZ() * p_77665_);
                if (j < 0 && !this.level.getBlockState((BlockPos)p_77663_).isSolid()) {
                    return false;
                }
                if (j < 0 || this.canPortalReplaceBlock(p_77663_)) continue;
                return false;
            }
        }
        return true;
    }

    private boolean canPortalReplaceBlock(BlockPos.MutableBlockPos pos) {
        BlockState blockstate = this.level.getBlockState((BlockPos)pos);
        return blockstate.canBeReplaced() && blockstate.getFluidState().isEmpty();
    }
}

