/*
 * Decompiled with CFR 0.152.
 */
package me.erykczy.colorfullighting.accessors;

import me.erykczy.colorfullighting.accessors.LevelWrapper;
import me.erykczy.colorfullighting.common.accessors.BlockStateAccessor;
import me.erykczy.colorfullighting.common.accessors.LevelAccessor;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.EmptyBlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public class BlockStateWrapper
implements BlockStateAccessor {
    final BlockState blockState;

    public BlockStateWrapper(@NotNull BlockState blockState) {
        this.blockState = blockState;
    }

    @Override
    public ResourceKey<Block> getBlockKey() {
        return this.blockState.getBlockHolder().getKey();
    }

    @Override
    public int getLightEmission() {
        return this.blockState.getLightEmission((BlockGetter)EmptyBlockGetter.INSTANCE, BlockPos.ZERO);
    }

    @Override
    public int getLightBlock() {
        return this.blockState.getLightBlock();
    }

    @Override
    public int getLightEmission(LevelAccessor level, BlockPos pos) {
        if (level instanceof LevelWrapper) {
            LevelWrapper levelWrapper = (LevelWrapper)level;
            return this.blockState.getLightEmission((BlockGetter)levelWrapper.getWrappedLevel(), pos);
        }
        return this.getLightEmission();
    }

    @Override
    public int getLightBlock(LevelAccessor level, BlockPos pos) {
        return this.getLightBlock();
    }
}

