/*
 * Decompiled with CFR 0.152.
 */
package me.erykczy.colorfullighting.resourcemanager;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.ToNumberPolicy;
import com.google.gson.ToNumberStrategy;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import me.erykczy.colorfullighting.ColorfulLighting;
import me.erykczy.colorfullighting.common.ColoredLightEngine;
import me.erykczy.colorfullighting.common.Config;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.ResourceManagerReloadListener;
import org.slf4j.Logger;

public class ConfigResourceManager
implements ResourceManagerReloadListener {
    private static final Gson GSON = new GsonBuilder().setObjectToNumberStrategy((ToNumberStrategy)ToNumberPolicy.LONG_OR_DOUBLE).create();
    private static final Logger LOGGER = ColorfulLighting.LOGGER;

    public void onResourceManagerReload(ResourceManager resourceManager) {
        HashMap<ResourceLocation, Config.ColorEmitter> emitters = new HashMap<ResourceLocation, Config.ColorEmitter>();
        HashMap<ResourceLocation, Config.ColorFilter> filters = new HashMap<ResourceLocation, Config.ColorFilter>();
        resourceManager.listPacks().forEach(pack -> {
            for (String namespace : pack.getNamespaces(PackType.CLIENT_RESOURCES)) {
                ResourceLocation key;
                JsonObject object;
                for (Resource resource : resourceManager.getResourceStack(ResourceLocation.fromNamespaceAndPath((String)namespace, (String)"light/emitters.json"))) {
                    try {
                        object = (JsonObject)GSON.fromJson((Reader)resource.openAsReader(), JsonObject.class);
                        for (Map.Entry entry : object.entrySet()) {
                            try {
                                key = ResourceLocation.parse((String)((String)entry.getKey()));
                                if (!BuiltInRegistries.BLOCK.containsKey(key)) {
                                    throw new IllegalArgumentException("Couldn't find block " + String.valueOf(key));
                                }
                                emitters.put(key, Config.ColorEmitter.fromJsonElement((JsonElement)entry.getValue()));
                            }
                            catch (Exception e) {
                                LOGGER.warn("Failed to load light emitter entry {} from pack {}", new Object[]{entry.toString(), resource.sourcePackId(), e});
                            }
                        }
                    }
                    catch (Exception e) {
                        LOGGER.warn("Failed to load light emitters from pack {}", (Object)resource.sourcePackId(), (Object)e);
                    }
                }
                for (Resource resource : resourceManager.getResourceStack(ResourceLocation.fromNamespaceAndPath((String)namespace, (String)"light/filters.json"))) {
                    try {
                        object = (JsonObject)GSON.fromJson((Reader)resource.openAsReader(), JsonObject.class);
                        for (Map.Entry entry : object.entrySet()) {
                            try {
                                key = ResourceLocation.parse((String)((String)entry.getKey()));
                                if (!BuiltInRegistries.BLOCK.containsKey(key)) {
                                    throw new IllegalArgumentException("Couldn't find block " + String.valueOf(key));
                                }
                                filters.put(key, Config.ColorFilter.fromJsonElement((JsonElement)entry.getValue()));
                            }
                            catch (Exception e) {
                                LOGGER.warn("Failed to load light color filter entry {} from pack {}", new Object[]{entry.toString(), resource.sourcePackId(), e});
                            }
                        }
                    }
                    catch (Exception e) {
                        LOGGER.warn("Failed to load light color filters from pack {}", (Object)resource.sourcePackId(), (Object)e);
                    }
                }
            }
        });
        Config.setColorEmitters(emitters);
        Config.setColorFilters(filters);
        ColoredLightEngine.getInstance().refreshLevel();
    }
}

