/*
 * Decompiled with CFR 0.152.
 */
package me.erykczy.colorfullighting.accessors;

import java.util.function.Consumer;
import me.erykczy.colorfullighting.accessors.BlockStateWrapper;
import me.erykczy.colorfullighting.common.Config;
import me.erykczy.colorfullighting.common.accessors.BlockStateAccessor;
import me.erykczy.colorfullighting.common.accessors.LevelAccessor;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.LevelChunk;
import org.jetbrains.annotations.NotNull;

public class LevelWrapper
implements LevelAccessor {
    private final ClientLevel level;
    private final LevelRenderer levelRenderer;

    public LevelWrapper(@NotNull ClientLevel level, @NotNull LevelRenderer levelRenderer) {
        this.level = level;
        this.levelRenderer = levelRenderer;
    }

    public ClientLevel getWrappedLevel() {
        return this.level;
    }

    @Override
    public int getSectionsCount() {
        return this.level.getSectionsCount();
    }

    @Override
    public int getMinSectionY() {
        return this.level.getMinSection();
    }

    @Override
    public void findLightSources(ChunkPos chunkPos, Consumer<BlockPos> consumer) {
        LevelChunk chunk = this.level.getChunk(chunkPos.x, chunkPos.z);
        chunk.findBlocks(blockState -> blockState.hasDynamicLightEmission() || Config.getEmissionBrightness(new BlockStateWrapper((BlockState)blockState)) != 0, (arg_0, arg_1) -> this.lambda$findLightSources$1((ChunkAccess)chunk, arg_0, arg_1), (blockPos, blockState) -> consumer.accept(new BlockPos((Vec3i)blockPos)));
    }

    @Override
    public BlockStateAccessor getBlockState(BlockPos pos) {
        return new BlockStateWrapper(this.level.getBlockState(pos));
    }

    @Override
    public boolean isInBounds(BlockPos pos) {
        return !this.level.isOutsideBuildHeight(pos);
    }

    @Override
    public void setSectionDirtyWithNeighbours(int x, int y, int z) {
        this.levelRenderer.setSectionDirtyWithNeighbors(x, y, z);
    }

    private /* synthetic */ boolean lambda$findLightSources$1(ChunkAccess chunk, BlockState blockState, BlockPos blockPos) {
        return blockState.getLightEmission((BlockGetter)chunk, blockPos) != 0 || Config.getEmissionBrightness(this, blockPos) != 0;
    }
}

