/*
 * Decompiled with CFR 0.152.
 */
package me.erykczy.colorfullighting.mixin.render;

import me.erykczy.colorfullighting.accessors.BlockStateWrapper;
import me.erykczy.colorfullighting.common.ColoredLightEngine;
import me.erykczy.colorfullighting.common.Config;
import me.erykczy.colorfullighting.common.accessors.LevelAccessor;
import me.erykczy.colorfullighting.common.util.ColorRGB4;
import me.erykczy.colorfullighting.common.util.ColorRGB8;
import me.erykczy.colorfullighting.common.util.PackedLightData;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.state.BlockState;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={LevelRenderer.class})
public class LevelRendererMixin {
    @Inject(method={"getLightColor(Lnet/minecraft/world/level/BlockAndTintGetter;Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/core/BlockPos;)I"}, at={@At(value="HEAD")}, cancellable=true)
    private static void colorfullighting$getLightColor(BlockAndTintGetter level, BlockState state, BlockPos pos, CallbackInfoReturnable<Integer> cir) {
        int skyLight = level.getBrightness(LightLayer.SKY, pos);
        if (state.emissiveRendering((BlockGetter)level, pos)) {
            LevelAccessor levelAccessor = ColoredLightEngine.getInstance().clientAccessor.getLevel();
            BlockStateWrapper stateAccessor = new BlockStateWrapper(state);
            if (levelAccessor != null) {
                ColorRGB4 emission = Config.getLightColor(stateAccessor);
                cir.setReturnValue((Object)PackedLightData.packData(skyLight, ColorRGB8.fromRGB4(emission)));
                return;
            }
            cir.setReturnValue((Object)PackedLightData.packData(15, 255, 255, 255));
            return;
        }
        ColorRGB4 color = ColoredLightEngine.getInstance().sampleLightColor(pos);
        cir.setReturnValue((Object)PackedLightData.packData(skyLight, ColorRGB8.fromRGB4(color)));
    }
}

