/*
 * Decompiled with CFR 0.152.
 */
package me.erykczy.colorfullighting.common;

import me.erykczy.colorfullighting.common.util.ColorRGB4;

public class ColoredLightSection {
    private static final int LAYER_SIZE = 6144;
    public byte[] data;

    public int getColorIndex(int x, int y, int z) {
        return y << 8 | z << 4 | x;
    }

    public ColorRGB4 get(int x, int y, int z) {
        return this.get(this.getColorIndex(x, y, z));
    }

    public ColorRGB4 get(int colorIndex) {
        if (this.data == null) {
            return ColorRGB4.fromRGB4(0, 0, 0);
        }
        int startBit = colorIndex * 12;
        int bitOffset = startBit & 7;
        int byteIndex = startBit >> 3;
        int rawData = this.data[byteIndex] << 8 & 0xFFFF | this.data[byteIndex + 1] & 0xFF;
        int offsetData = rawData << bitOffset;
        int red = offsetData >>> 12 & 0xF;
        int green = offsetData >>> 8 & 0xF;
        int blue = offsetData >>> 4 & 0xF;
        return ColorRGB4.fromRGB4(red, green, blue);
    }

    public void set(int x, int y, int z, ColorRGB4 value) {
        this.set(this.getColorIndex(x, y, z), value);
    }

    public void set(int colorIndex, ColorRGB4 value) {
        if (this.data == null) {
            this.data = new byte[6144];
        }
        if (!value.isInValidState()) {
            throw new IllegalArgumentException("Invalid ColoredLightSection.Entry: " + value);
        }
        int startBit = colorIndex * 12;
        int byteIndex = startBit >> 3;
        int bitOffset = startBit & 7;
        if (bitOffset == 0) {
            this.data[byteIndex] = (byte)(value.red4 << 4 | value.green4);
            this.data[byteIndex + 1] = (byte)(value.blue4 << 4 | this.data[byteIndex + 1] & 0xF);
        } else {
            this.data[byteIndex] = (byte)(this.data[byteIndex] & 0xF0 | value.red4);
            this.data[byteIndex + 1] = (byte)(value.green4 << 4 | value.blue4);
        }
    }

    public void clear() {
        this.data = null;
    }
}

