/*
 * Decompiled with CFR 0.152.
 */
package me.erykczy.colorfullighting.common;

import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;
import me.erykczy.colorfullighting.common.ColoredLightSection;
import me.erykczy.colorfullighting.common.util.ColorRGB4;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;

public class ColoredLightStorage {
    private ConcurrentHashMap<Long, ColoredLightSection> map = new ConcurrentHashMap();

    @Nullable
    public ColorRGB4 getEntry(BlockPos blockPos) {
        return this.getEntry(blockPos.m_123341_(), blockPos.m_123342_(), blockPos.m_123343_());
    }

    @Nullable
    public ColorRGB4 getEntry(int x, int y, int z) {
        long sectionPos = SectionPos.m_123235_((long)BlockPos.m_121882_((int)x, (int)y, (int)z));
        ColoredLightSection layer = this.getSection(sectionPos);
        if (layer == null) {
            return null;
        }
        return layer.get(SectionPos.m_123207_((int)x), SectionPos.m_123207_((int)y), SectionPos.m_123207_((int)z));
    }

    public void setEntry(BlockPos blockPos, ColorRGB4 value) {
        this.setEntry(blockPos.m_123341_(), blockPos.m_123342_(), blockPos.m_123343_(), value);
    }

    public void setEntry(int x, int y, int z, ColorRGB4 value) {
        long sectionPos = SectionPos.m_123235_((long)BlockPos.m_121882_((int)x, (int)y, (int)z));
        ColoredLightSection layer = this.getSection(sectionPos);
        if (layer == null) {
            return;
        }
        layer.set(SectionPos.m_123207_((int)x), SectionPos.m_123207_((int)y), SectionPos.m_123207_((int)z), value);
    }

    public boolean containsEntry(BlockPos blockPos) {
        return this.containsEntry(blockPos.m_123341_(), blockPos.m_123342_(), blockPos.m_123343_());
    }

    public boolean containsEntry(int x, int y, int z) {
        return this.containsSection(SectionPos.m_123235_((long)BlockPos.m_121882_((int)x, (int)y, (int)z)));
    }

    public boolean containsSection(long sectionPos) {
        return this.map.containsKey(sectionPos);
    }

    public ColoredLightSection getSection(long sectionPos) {
        return this.map.get(sectionPos);
    }

    public void addSection(long sectionPos) {
        this.map.put(sectionPos, new ColoredLightSection());
    }

    public void removeSection(long sectionPos) {
        this.map.remove(sectionPos);
    }

    public void clear() {
        this.map.clear();
    }
}

