/*
 * Decompiled with CFR 0.152.
 */
package me.erykczy.colorfullighting.common.util;

import me.erykczy.colorfullighting.common.util.ColorRGB4;
import me.erykczy.colorfullighting.common.util.MathExt;

public class ColorRGB8 {
    public int red;
    public int green;
    public int blue;

    public static ColorRGB8 fromRGB4(ColorRGB4 value) {
        return new ColorRGB8(value.red4 * 17, value.green4 * 17, value.blue4 * 17);
    }

    public static ColorRGB8 fromRGB8(int r, int g, int b) {
        return new ColorRGB8(r, g, b);
    }

    public static ColorRGB8 fromRGBFloat(float r, float g, float b) {
        return new ColorRGB8((int)(r * 255.0f), (int)(g * 255.0f), (int)(b * 255.0f));
    }

    private ColorRGB8(int red, int green, int blue) {
        this.red = red;
        this.green = green;
        this.blue = blue;
    }

    public boolean isInValidState() {
        return this.red >= 0 && this.red < 256 && this.green >= 0 && this.green < 256 && this.blue >= 0 && this.blue < 256;
    }

    public ColorRGB8 clamp() {
        return new ColorRGB8(MathExt.clamp(this.red, 0, 255), MathExt.clamp(this.green, 0, 255), MathExt.clamp(this.blue, 0, 255));
    }

    public boolean isZero() {
        return this.red == 0 && this.green == 0 && this.blue == 0;
    }

    public ColorRGB8 add(ColorRGB8 other) {
        return new ColorRGB8(this.red + other.red, this.green + other.green, this.blue + other.blue);
    }

    public ColorRGB8 sub(ColorRGB8 other) {
        return new ColorRGB8(this.red - other.red, this.green - other.green, this.blue - other.blue);
    }

    public ColorRGB8 intDivide(int scalar) {
        return new ColorRGB8(this.red / scalar, this.green / scalar, this.blue / scalar);
    }

    public ColorRGB8 mul(float scalar) {
        return new ColorRGB8((int)((float)this.red * scalar), (int)((float)this.green * scalar), (int)((float)this.blue * scalar));
    }

    public ColorRGB8 mul(double scalar) {
        return new ColorRGB8((int)((double)this.red * scalar), (int)((double)this.green * scalar), (int)((double)this.blue * scalar));
    }
}

