/*
 * Decompiled with CFR 0.152.
 */
package me.erykczy.colorfullighting.common.util;

import com.google.gson.JsonElement;
import java.awt.Color;
import me.erykczy.colorfullighting.common.util.ColorRGB4;
import net.minecraft.world.item.DyeColor;

public abstract class JsonHelper {
    public static ColorRGB4 getColor4FromString(String string) {
        ColorRGB4 color = JsonHelper.getColor4FromDyeName(string);
        if (color != null) {
            return color;
        }
        color = JsonHelper.getColor4FromHexString(string);
        if (color != null) {
            return color;
        }
        return color;
    }

    public static ColorRGB4 getColor4FromDyeName(String dyeName) {
        DyeColor dyeColor = DyeColor.m_41057_((String)dyeName, null);
        if (dyeColor != null) {
            Color color = new Color(dyeColor.m_41071_());
            return ColorRGB4.fromRGB8(color.getRed(), color.getGreen(), color.getBlue());
        }
        return null;
    }

    public static ColorRGB4 getColor4FromHexString(String string) {
        if (string.length() != 7 || !string.startsWith("#")) {
            return null;
        }
        long colorFromHex = Long.parseLong(string.substring(1), 16);
        long blue = colorFromHex & 0xFFL;
        long green = colorFromHex >> 8 & 0xFFL;
        long red = colorFromHex >> 16 & 0xFFL;
        return ColorRGB4.fromRGB8((int)red, (int)green, (int)blue);
    }

    public static ColorRGB4 getColor4FromJsonElements(JsonElement red, JsonElement green, JsonElement blue) {
        Integer redI = JsonHelper.getInt4FromJsonElement(red);
        Integer greenI = JsonHelper.getInt4FromJsonElement(green);
        Integer blueI = JsonHelper.getInt4FromJsonElement(blue);
        if (redI == null || greenI == null || blueI == null) {
            return null;
        }
        ColorRGB4 color = ColorRGB4.fromRGB4(redI, greenI, blueI);
        if (!color.isInValidState()) {
            return null;
        }
        return color;
    }

    public static Integer getInt4FromJsonElement(JsonElement element) {
        int value;
        try {
            value = element.getAsBigInteger().intValue() / 17;
        }
        catch (NumberFormatException e) {
            value = (int)(element.getAsFloat() * 15.0f);
        }
        if (value >= 0 && value < 16) {
            return value;
        }
        return null;
    }
}

