/*
 * Decompiled with CFR 0.152.
 */
package com.github.eterdelta.crittersandcompanions.entity;

import com.github.eterdelta.crittersandcompanions.CrittersAndCompanions;
import com.github.eterdelta.crittersandcompanions.entity.brain.SprintingFollowParentGoal;
import com.github.eterdelta.crittersandcompanions.entity.brain.TameableFollowParentGoal;
import com.github.eterdelta.crittersandcompanions.platform.Services;
import com.github.eterdelta.crittersandcompanions.registry.CACEntities;
import com.github.eterdelta.crittersandcompanions.registry.CACSounds;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.EnumSet;
import java.util.UUID;
import java.util.function.Predicate;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.SitWhenOrderedToGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Chicken;
import net.minecraft.world.entity.animal.Rabbit;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.Animation;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class FerretEntity
extends TamableAnimal
implements GeoEntity {
    private static final EntityDataAccessor<Boolean> SLEEPING = SynchedEntityData.defineId(FerretEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> DIGGING = SynchedEntityData.defineId(FerretEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Integer> VARIANT = SynchedEntityData.defineId(FerretEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> DATA_COLLAR_COLOR = SynchedEntityData.defineId(FerretEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final TagKey<Item> FOODS_TAG = TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)CrittersAndCompanions.createId("ferret_food"));
    private static final TagKey<Item> TEMPT_TAG = TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)CrittersAndCompanions.createId("ferret_tempt_items"));
    private static final TagKey<Block> DIG_GROUNDS_TAG = TagKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)CrittersAndCompanions.createId("ferret_dig_grounds"));
    private static final ResourceKey<LootTable> DIGGABLES = ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)CrittersAndCompanions.createId("gameplay/digging"));
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    protected BlockState stateToDig;
    protected int digCooldown;

    public FerretEntity(EntityType<? extends FerretEntity> entityType, Level level) {
        super(entityType, level);
        this.moveControl = new FerretMoveControl();
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, 16.0).add(Attributes.MOVEMENT_SPEED, 0.28).add(Attributes.ATTACK_DAMAGE, 3.0);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(SLEEPING, (Object)false);
        builder.define(DIGGING, (Object)false);
        builder.define(VARIANT, (Object)0);
        builder.define(DATA_COLLAR_COLOR, (Object)DyeColor.RED.getId());
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(1, (Goal)new PanicGoal((PathfinderMob)this, 1.5));
        this.goalSelector.addGoal(2, (Goal)new DigGoal());
        this.goalSelector.addGoal(3, (Goal)new SitWhenOrderedToGoal((TamableAnimal)this));
        this.goalSelector.addGoal(4, (Goal)new SleepGoal(200));
        this.goalSelector.addGoal(5, (Goal)new AvoidEntityGoal((PathfinderMob)this, LivingEntity.class, 8.0f, 1.6, 1.4, livingEntity -> livingEntity.is((Entity)this.getLastHurtByMob()) && !livingEntity.is((Entity)this.getOwner())));
        this.goalSelector.addGoal(6, (Goal)new BreedGoal((Animal)this, 1.25));
        this.goalSelector.addGoal(7, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.5, true));
        this.goalSelector.addGoal(8, (Goal)new TemptGoal((PathfinderMob)this, 1.0, (Predicate)Ingredient.of(TEMPT_TAG), false));
        this.goalSelector.addGoal(7, (Goal)new SprintingFollowParentGoal(this, 1.4, 10.0f, 5.0f, 2.0f));
        this.goalSelector.addGoal(10, (Goal)new TameableFollowParentGoal(this, 1.0));
        this.goalSelector.addGoal(11, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.goalSelector.addGoal(12, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.goalSelector.addGoal(13, (Goal)new RandomLookAroundGoal((Mob)this));
        this.targetSelector.addGoal(0, (Goal)new NearestAttackableTargetGoal((Mob)this, Animal.class, 10, false, false, entity -> entity instanceof Chicken || entity instanceof Rabbit));
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putBoolean("Sleeping", this.isSleeping());
        compound.putInt("Variant", this.getVariant());
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        this.setSleeping(compound.getBoolean("Sleeping"));
        this.setVariant(compound.getInt("Variant"));
    }

    public int getBaseExperienceReward() {
        return this.random.nextInt(2, 5);
    }

    protected void customServerAiStep() {
        super.customServerAiStep();
        if (this.digCooldown > 0) {
            --this.digCooldown;
        }
    }

    public AgeableMob getBreedOffspring(ServerLevel level, AgeableMob ageableMob) {
        FerretEntity baby = (FerretEntity)((EntityType)CACEntities.FERRET.get()).create((Level)level);
        if (baby == null) {
            return null;
        }
        UUID uuid = this.getOwnerUUID();
        if (ageableMob instanceof FerretEntity) {
            DyeColor color;
            FerretEntity ferretEntity = (FerretEntity)ageableMob;
            if (this.random.nextBoolean()) {
                baby.setVariant(this.getVariant());
            } else {
                baby.setVariant(ferretEntity.getVariant());
            }
            DyeColor dyeColor = color = this.random.nextBoolean() ? this.getCollarColor() : ferretEntity.getCollarColor();
            if (color != null) {
                baby.setCollarColor(color);
            }
            if (uuid != null) {
                baby.setOwnerUUID(uuid);
                baby.setTame(true, false);
            }
        }
        return baby;
    }

    public boolean doHurtTarget(Entity entity) {
        if (super.doHurtTarget(entity)) {
            this.playSound((SoundEvent)CACSounds.BITE_ATTACK.get(), this.getSoundVolume(), this.getVoicePitch());
            return true;
        }
        return false;
    }

    public InteractionResult mobInteract(Player player, InteractionHand interactionHand) {
        if (this.isSleeping()) {
            return InteractionResult.PASS;
        }
        ItemStack handStack = player.getItemInHand(interactionHand);
        if (handStack.is(TEMPT_TAG) && !this.isTame()) {
            handStack.consume(1, (LivingEntity)player);
            if (!this.level().isClientSide()) {
                if (this.random.nextInt(10) == 0 && Services.EVENTS.canTame((Animal)this, player)) {
                    this.tame(player);
                    this.level().broadcastEntityEvent((Entity)this, (byte)7);
                } else {
                    this.level().broadcastEntityEvent((Entity)this, (byte)6);
                }
            }
            return InteractionResult.sidedSuccess((boolean)this.level().isClientSide());
        }
        if (this.isTame() && this.isOwnedBy((LivingEntity)player)) {
            InteractionResult digResult = this.startDigging(player, handStack);
            if (digResult != InteractionResult.PASS) {
                return digResult;
            }
            Item item = handStack.getItem();
            if (item instanceof DyeItem) {
                DyeItem dyeItem = (DyeItem)item;
                if (this.getCollarColor() != dyeItem.getDyeColor()) {
                    this.setCollarColor(dyeItem.getDyeColor());
                    handStack.consume(1, (LivingEntity)player);
                    return InteractionResult.SUCCESS;
                }
            }
            if (this.isFood(handStack)) {
                if (this.getHealth() < this.getMaxHealth()) {
                    this.gameEvent((Holder)GameEvent.EAT, (Entity)this);
                    FoodProperties food = (FoodProperties)handStack.get(DataComponents.FOOD);
                    if (food != null) {
                        this.heal(food.nutrition());
                    }
                    handStack.consume(1, (LivingEntity)player);
                    return InteractionResult.sidedSuccess((boolean)this.level().isClientSide());
                }
            } else {
                this.setOrderedToSit(!this.isOrderedToSit());
                return InteractionResult.sidedSuccess((boolean)this.level().isClientSide());
            }
        }
        return super.mobInteract(player, interactionHand);
    }

    private InteractionResult startDigging(Player player, ItemStack handStack) {
        if (handStack.is(TEMPT_TAG) && !this.isBaby() && !this.isInSittingPose()) {
            if (this.digCooldown <= 0) {
                this.stateToDig = this.level().getBlockState(this.blockPosition().below());
                if (this.stateToDig.is(DIG_GROUNDS_TAG)) {
                    this.setDigging(true);
                    this.digCooldown = 6000;
                    handStack.consume(1, (LivingEntity)player);
                    return InteractionResult.sidedSuccess((boolean)this.level().isClientSide());
                }
                this.stateToDig = null;
            }
            return InteractionResult.FAIL;
        }
        return InteractionResult.PASS;
    }

    public boolean canFallInLove() {
        return !this.isDigging() && super.canFallInLove();
    }

    public boolean isFood(ItemStack itemStack) {
        return itemStack.is(FOODS_TAG);
    }

    protected SoundEvent getAmbientSound() {
        return this.isSleeping() ? null : (SoundEvent)CACSounds.FERRET_AMBIENT.get();
    }

    protected SoundEvent getHurtSound(DamageSource damageSource) {
        return (SoundEvent)CACSounds.FERRET_HURT.get();
    }

    protected SoundEvent getDeathSound() {
        return (SoundEvent)CACSounds.FERRET_DEATH.get();
    }

    public SpawnGroupData finalizeSpawn(ServerLevelAccessor levelAccessor, DifficultyInstance difficultyInstance, MobSpawnType mobSpawnType, SpawnGroupData spawnGroupData) {
        spawnGroupData = super.finalizeSpawn(levelAccessor, difficultyInstance, mobSpawnType, spawnGroupData);
        if (mobSpawnType.equals((Object)MobSpawnType.SPAWNER) && this.random.nextFloat() <= 0.2f) {
            for (int i = 0; i < this.random.nextInt(1, 4); ++i) {
                FerretEntity baby = (FerretEntity)((EntityType)CACEntities.FERRET.get()).create(this.level());
                baby.setVariant(this.random.nextInt(0, 2));
                baby.moveTo(this.getX(), this.getY(), this.getZ(), this.getYRot(), 0.0f);
                baby.setBaby(true);
                levelAccessor.addFreshEntity((Entity)baby);
            }
        }
        this.setVariant(this.random.nextInt(0, 2));
        return spawnGroupData;
    }

    private PlayState predicate(AnimationState<?> event) {
        if (this.isDigging()) {
            event.getController().setAnimation(RawAnimation.begin().then("dig", Animation.LoopType.PLAY_ONCE));
        } else if (this.isInSittingPose()) {
            event.getController().setAnimation(RawAnimation.begin().thenLoop("sit"));
        } else if (this.isSleeping()) {
            event.getController().setAnimation(RawAnimation.begin().thenLoop("sleep"));
        } else if (this.isInWater()) {
            event.getController().setAnimation(RawAnimation.begin().thenLoop("swim"));
        } else if (event.isMoving()) {
            event.getController().setAnimation(RawAnimation.begin().thenLoop("run"));
        } else {
            event.getController().setAnimation(RawAnimation.begin().thenLoop("idle"));
        }
        return PlayState.CONTINUE;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController((GeoAnimatable)this, "controller", 4, this::predicate));
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public boolean isSleeping() {
        return (Boolean)this.entityData.get(SLEEPING);
    }

    public void setSleeping(boolean sleeping) {
        this.entityData.set(SLEEPING, (Object)sleeping);
    }

    public boolean isDigging() {
        return (Boolean)this.entityData.get(DIGGING);
    }

    public void setDigging(boolean digging) {
        this.entityData.set(DIGGING, (Object)digging);
    }

    public int getVariant() {
        return (Integer)this.entityData.get(VARIANT);
    }

    public void setVariant(int variant) {
        this.entityData.set(VARIANT, (Object)Mth.clamp((int)variant, (int)0, (int)1));
    }

    @Nullable
    public DyeColor getCollarColor() {
        if (!this.isTame()) {
            return null;
        }
        return DyeColor.byId((int)((Integer)this.entityData.get(DATA_COLLAR_COLOR)));
    }

    private void setCollarColor(DyeColor color) {
        this.entityData.set(DATA_COLLAR_COLOR, (Object)color.getId());
    }

    class FerretMoveControl
    extends MoveControl {
        public FerretMoveControl() {
            super((Mob)FerretEntity.this);
        }

        public void tick() {
            if (!FerretEntity.this.isSleeping()) {
                super.tick();
            }
        }
    }

    public class DigGoal
    extends Goal {
        protected int digTime;

        public DigGoal() {
            this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK, Goal.Flag.JUMP));
        }

        public boolean requiresUpdateEveryTick() {
            return true;
        }

        public boolean canUse() {
            return FerretEntity.this.isDigging();
        }

        public void start() {
            this.digTime = 35;
        }

        public void tick() {
            if (this.digTime > 0) {
                --this.digTime;
                if (this.digTime % 5 == 0 && this.digTime >= 10) {
                    FerretEntity.this.level().playSound(null, (Entity)FerretEntity.this, SoundEvents.GRAVEL_HIT, SoundSource.BLOCKS, 0.2f, 1.2f);
                    for (int i = 0; i < 4; ++i) {
                        double d0 = FerretEntity.this.random.nextGaussian() * 0.01;
                        double d1 = FerretEntity.this.random.nextGaussian() * 0.01;
                        double d2 = FerretEntity.this.random.nextGaussian() * 0.01;
                        ((ServerLevel)FerretEntity.this.level()).sendParticles((ParticleOptions)new BlockParticleOption(ParticleTypes.BLOCK, FerretEntity.this.stateToDig), FerretEntity.this.getX(), FerretEntity.this.getY(), FerretEntity.this.getZ(), 2, d0, d1, d2, 0.1);
                    }
                }
                if (this.digTime == 10) {
                    LootTable digTable = FerretEntity.this.level().getServer().reloadableRegistries().getLootTable(DIGGABLES);
                    ObjectArrayList dugItems = digTable.getRandomItems(new LootParams.Builder((ServerLevel)FerretEntity.this.level()).create(LootContextParamSets.EMPTY));
                    if (!dugItems.isEmpty()) {
                        FerretEntity.this.level().playSound(null, (Entity)FerretEntity.this, SoundEvents.ITEM_PICKUP, SoundSource.BLOCKS, 0.1f, 1.2f);
                    }
                    for (ItemStack stack : dugItems) {
                        ItemEntity itemEntity = new ItemEntity(FerretEntity.this.level(), FerretEntity.this.getX(), FerretEntity.this.getY(), FerretEntity.this.getZ(), stack);
                        FerretEntity.this.level().addFreshEntity((Entity)itemEntity);
                    }
                    ExperienceOrb xp = new ExperienceOrb(FerretEntity.this.level(), FerretEntity.this.getX(), FerretEntity.this.getY(), FerretEntity.this.getZ(), FerretEntity.this.random.nextInt(1, 6));
                    FerretEntity.this.level().addFreshEntity((Entity)xp);
                }
            } else {
                this.stop();
            }
        }

        public void stop() {
            FerretEntity.this.setDigging(false);
            FerretEntity.this.stateToDig = null;
            this.digTime = 0;
        }
    }

    public class SleepGoal
    extends Goal {
        private final int countdownTime;
        private int countdown;

        public SleepGoal(int countdownTime) {
            this.countdownTime = countdownTime;
            this.countdown = FerretEntity.this.random.nextInt(SleepGoal.reducedTickDelay((int)countdownTime));
            this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK, Goal.Flag.JUMP));
        }

        public boolean canUse() {
            if (FerretEntity.this.xxa == 0.0f && FerretEntity.this.yya == 0.0f && FerretEntity.this.zza == 0.0f) {
                return this.canSleep() || FerretEntity.this.isSleeping();
            }
            return false;
        }

        public boolean canContinueToUse() {
            return this.canSleep();
        }

        private boolean canSleep() {
            if (this.countdown > 0) {
                --this.countdown;
                return false;
            }
            return FerretEntity.this.level().isNight();
        }

        public void stop() {
            FerretEntity.this.setSleeping(false);
            this.countdown = FerretEntity.this.random.nextInt(this.countdownTime);
        }

        public void start() {
            FerretEntity.this.setInSittingPose(false);
            FerretEntity.this.setJumping(false);
            FerretEntity.this.setSleeping(true);
            FerretEntity.this.getNavigation().stop();
            FerretEntity.this.getMoveControl().setWantedPosition(FerretEntity.this.getX(), FerretEntity.this.getY(), FerretEntity.this.getZ(), 0.0);
        }
    }
}

