/*
 * Decompiled with CFR 0.152.
 */
package com.github.eterdelta.crittersandcompanions.entity;

import com.github.eterdelta.crittersandcompanions.extension.IBubbleState;
import com.github.eterdelta.crittersandcompanions.network.CACPacketHandler;
import com.github.eterdelta.crittersandcompanions.network.ClientboundBubbleStatePacket;
import com.github.eterdelta.crittersandcompanions.registry.CACItems;
import com.github.eterdelta.crittersandcompanions.registry.CACSounds;
import java.util.EnumSet;
import net.minecraft.class_1266;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1313;
import net.minecraft.class_1314;
import net.minecraft.class_1315;
import net.minecraft.class_1332;
import net.minecraft.class_1352;
import net.minecraft.class_1378;
import net.minecraft.class_1408;
import net.minecraft.class_1412;
import net.minecraft.class_1480;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3532;
import net.minecraft.class_3730;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5425;
import net.minecraft.class_5757;
import net.minecraft.class_5761;
import net.minecraft.class_9279;
import net.minecraft.class_9331;
import net.minecraft.class_9334;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class DumboOctopusEntity
extends class_1480
implements GeoEntity,
class_5761 {
    private static final class_2940<Boolean> RESTING = class_2945.method_12791(DumboOctopusEntity.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Integer> VARIANT = class_2945.method_12791(DumboOctopusEntity.class, (class_2941)class_2943.field_13327);
    private static final class_2940<Boolean> FROM_BUCKET = class_2945.method_12791(DumboOctopusEntity.class, (class_2941)class_2943.field_13323);
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    public int restTimer;
    protected boolean bubblingPlayer;
    protected class_3222 bubbledPlayer;

    public DumboOctopusEntity(class_1299<? extends DumboOctopusEntity> entityType, class_1937 level) {
        super(entityType, level);
        this.field_6207 = new DumboOctopusMoveControl(90, 90, 1.0f, 1.0f, false);
        this.field_6206 = new class_1332((class_1308)this, 180);
    }

    public static class_5132.class_5133 createAttributes() {
        return class_1308.method_26828().method_26868(class_5134.field_23716, 14.0).method_26868(class_5134.field_23719, 0.06);
    }

    public boolean method_17326() {
        return super.method_17326() || this.method_6453();
    }

    public boolean method_5974(double distance) {
        return !this.method_6453() && !this.method_16914();
    }

    protected void method_5693(class_2945.class_9222 builder) {
        super.method_5693(builder);
        builder.method_56912(RESTING, (Object)false);
        builder.method_56912(VARIANT, (Object)0);
        builder.method_56912(FROM_BUCKET, (Object)false);
    }

    protected void method_5959() {
        this.field_6201.method_6277(0, (class_1352)new BubblePlayerGoal());
        this.field_6201.method_6277(1, (class_1352)new RandomSwimmingGoal(this, 1.0, 40));
    }

    public void method_5652(class_2487 compound) {
        super.method_5652(compound);
        compound.method_10556("Resting", this.isResting());
        compound.method_10569("Variant", this.getVariant());
        compound.method_10556("FromBucket", this.method_6453());
    }

    public void method_5749(class_2487 compound) {
        super.method_5749(compound);
        this.setResting(compound.method_10577("Resting"));
        this.setVariant(compound.method_10550("Variant"));
        this.method_6454(compound.method_10577("FromBucket"));
    }

    public boolean method_6453() {
        return (Boolean)this.field_6011.method_12789(FROM_BUCKET);
    }

    public void method_6454(boolean fromBucket) {
        this.field_6011.method_12778(FROM_BUCKET, (Object)fromBucket);
    }

    public void method_6455(class_1799 bucketStack) {
        class_5761.method_35167((class_1308)this, (class_1799)bucketStack);
        class_9279.method_57452((class_9331)class_9334.field_49610, (class_1799)bucketStack, nbt -> nbt.method_10569("Variant", this.getVariant()));
    }

    public void method_35170(class_2487 bucketCompound) {
        class_5761.method_35168((class_1308)this, (class_2487)bucketCompound);
        this.setVariant(bucketCompound.method_10550("Variant"));
    }

    public class_1799 method_6452() {
        return new class_1799((class_1935)CACItems.DUMBO_OCTOPUS_BUCKET.get());
    }

    public class_3414 method_35171() {
        return class_3417.field_28295;
    }

    public void method_6007() {
        super.method_6007();
        if (!this.method_37908().method_8608() && !this.bubblingPlayer && this.method_6034()) {
            if (this.method_5799()) {
                if (this.isResting()) {
                    if (--this.restTimer <= 0) {
                        this.setResting(false);
                    }
                    this.method_18799(this.method_18798().method_1023(0.0, 0.01, 0.0));
                } else if (this.field_5974.method_43057() <= 0.001f) {
                    this.restTimer = this.field_5974.method_43051(200, 601);
                    this.setResting(true);
                }
            } else {
                this.setResting(false);
            }
        }
    }

    protected class_1408 method_5965(class_1937 level) {
        return new class_1412((class_1308)this, level);
    }

    public void method_6091(class_243 speed) {
        if (this.method_6034() && this.method_5799()) {
            this.method_5724(this.method_6029(), speed);
            this.method_5784(class_1313.field_6308, this.method_18798());
            this.method_18799(this.method_18798().method_1021(0.9));
        } else {
            super.method_6091(speed);
        }
    }

    protected class_1269 method_5992(class_1657 player, class_1268 interactionHand) {
        return class_5761.method_35169((class_1657)player, (class_1268)interactionHand, (class_1309)this).orElse(super.method_5992(player, interactionHand));
    }

    public class_1315 method_5943(class_5425 levelAccessor, class_1266 difficultyInstance, class_3730 mobSpawnType, class_1315 spawnGroupData) {
        if (mobSpawnType == class_3730.field_16473) {
            return spawnGroupData;
        }
        this.setVariant(this.field_5974.method_43051(0, 4));
        return super.method_5943(levelAccessor, difficultyInstance, mobSpawnType, spawnGroupData);
    }

    private PlayState predicate(AnimationState<?> event) {
        if (this.isResting()) {
            event.getController().setAnimation(RawAnimation.begin().thenLoop("dumbo_octopus_idle"));
        } else if (this.method_5799()) {
            event.getController().setAnimation(RawAnimation.begin().thenLoop("dumbo_octopus_swim"));
        } else {
            event.getController().setAnimation(RawAnimation.begin().thenLoop("dumbo_octopus_on_land"));
        }
        return PlayState.CONTINUE;
    }

    public void sendBubble(class_3222 player, boolean state) {
        if (!(player instanceof IBubbleState)) {
            return;
        }
        IBubbleState bubbleState = (IBubbleState)player;
        bubbleState.setBubbleActive(state);
        CACPacketHandler.BUBBLE_STATE.sendToTracking((class_1297)player, new ClientboundBubbleStatePacket(state, player.method_5628()));
    }

    public class_3222 getBubbledPlayer() {
        return this.bubbledPlayer;
    }

    public boolean isResting() {
        return (Boolean)this.field_6011.method_12789(RESTING);
    }

    public void setResting(boolean resting) {
        this.field_6011.method_12778(RESTING, (Object)resting);
    }

    public int getVariant() {
        return (Integer)this.field_6011.method_12789(VARIANT);
    }

    public void setVariant(int variant) {
        this.field_6011.method_12778(VARIANT, (Object)class_3532.method_15340((int)variant, (int)0, (int)3));
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController((GeoAnimatable)this, "controller", 4, this::predicate));
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    class DumboOctopusMoveControl
    extends class_5757 {
        public DumboOctopusMoveControl(int maxTurnX, int maxTurnY, float inWaterSpeedModifier, float outsideWaterSpeedModifier, boolean applyGravity) {
            super((class_1308)DumboOctopusEntity.this, maxTurnX, maxTurnY, inWaterSpeedModifier, outsideWaterSpeedModifier, applyGravity);
        }

        public void method_6240() {
            if (!DumboOctopusEntity.this.isResting()) {
                super.method_6240();
            }
        }
    }

    class BubblePlayerGoal
    extends class_1352 {
        private final class_1937 level;
        private final class_1408 navigation;
        private int timeToRecalcPath;
        private boolean bubbleSent;

        public BubblePlayerGoal() {
            this.level = DumboOctopusEntity.this.method_37908();
            this.navigation = DumboOctopusEntity.this.method_5942();
            this.method_6265(EnumSet.of(class_1352.class_4134.field_18405, class_1352.class_4134.field_18406));
        }

        public boolean method_6264() {
            class_3222 player = (class_3222)this.level.method_18460((class_1297)DumboOctopusEntity.this, 6.0);
            if (player != null && player.method_5669() < 150) {
                DumboOctopusEntity.this.bubbledPlayer = player;
                return true;
            }
            return false;
        }

        public boolean method_6266() {
            return DumboOctopusEntity.this.bubbledPlayer != null && DumboOctopusEntity.this.bubbledPlayer.method_5805() && DumboOctopusEntity.this.bubbledPlayer.method_5669() <= 150;
        }

        public void method_6269() {
            DumboOctopusEntity.this.bubblingPlayer = true;
            this.timeToRecalcPath = 0;
        }

        public void method_6268() {
            DumboOctopusEntity.this.method_5988().method_6226((class_1297)DumboOctopusEntity.this.bubbledPlayer, 10.0f, (float)DumboOctopusEntity.this.method_5978());
            if (DumboOctopusEntity.this.method_5858((class_1297)DumboOctopusEntity.this.bubbledPlayer) > 2.0) {
                --this.timeToRecalcPath;
                if (this.timeToRecalcPath <= 0) {
                    this.timeToRecalcPath = this.method_38847(10);
                    if (!DumboOctopusEntity.this.method_60953() && !DumboOctopusEntity.this.method_5765()) {
                        this.navigation.method_6335((class_1297)DumboOctopusEntity.this.bubbledPlayer, 2.0);
                    }
                }
            } else if (!this.bubbleSent) {
                DumboOctopusEntity.this.sendBubble(DumboOctopusEntity.this.bubbledPlayer, true);
                this.bubbleSent = true;
            }
            if (this.bubbleSent) {
                DumboOctopusEntity.this.bubbledPlayer.method_5855(150);
            }
        }

        public void method_6270() {
            DumboOctopusEntity.this.bubblingPlayer = false;
            DumboOctopusEntity.this.sendBubble(DumboOctopusEntity.this.bubbledPlayer, false);
            this.bubbleSent = false;
            DumboOctopusEntity.this.bubbledPlayer.method_43077((class_3414)CACSounds.BUBBLE_POP.get());
            DumboOctopusEntity.this.bubbledPlayer = null;
            this.navigation.method_6340();
        }
    }

    static class RandomSwimmingGoal
    extends class_1378 {
        private final DumboOctopusEntity dumboOctopus;

        public RandomSwimmingGoal(DumboOctopusEntity dumboOctopus, double speedModifier, int interval) {
            super((class_1314)dumboOctopus, speedModifier, interval);
            this.dumboOctopus = dumboOctopus;
        }

        public boolean method_6264() {
            return !this.dumboOctopus.isResting() && super.method_6264();
        }
    }
}

