/*
 * Decompiled with CFR 0.152.
 */
package com.github.eterdelta.crittersandcompanions.mixin;

import com.github.eterdelta.crittersandcompanions.extension.ISilkLeashState;
import com.github.eterdelta.crittersandcompanions.item.PearlNecklaceItem;
import com.github.eterdelta.crittersandcompanions.item.SilkLeashItem;
import com.github.eterdelta.crittersandcompanions.network.CACPacketHandler;
import com.github.eterdelta.crittersandcompanions.network.ClientboundSilkLeashStatePacket;
import com.github.eterdelta.crittersandcompanions.platform.Services;
import com.github.eterdelta.crittersandcompanions.registry.CACBlocks;
import com.github.eterdelta.crittersandcompanions.registry.CACItems;
import it.unimi.dsi.fastutil.Pair;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.objects.ObjectObjectImmutablePair;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1542;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_3218;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_1309.class})
public abstract class LivingEntityMixin
extends class_1297
implements ISilkLeashState {
    @Unique
    private final Pair<Set<UUID>, Set<UUID>> savedLeashState = new ObjectObjectImmutablePair(new HashSet(), new HashSet());
    @Unique
    private boolean needsLeashStateLoad;
    @Unique
    private int leashStateLoadDelay;
    @Unique
    private final Set<class_1309> leashingEntities = new HashSet<class_1309>();
    @Unique
    private final Set<class_1309> leashedByEntities = new HashSet<class_1309>();

    public LivingEntityMixin(class_1299<?> entityType, class_1937 level) {
        super(entityType, level);
    }

    @Inject(at={@At(value="TAIL")}, method={"addAdditionalSaveData"})
    private void onAddAdditionalSaveData(class_2487 compoundTag, CallbackInfo callbackInfo) {
        if (!this.method_37908().method_8608()) {
            class_2499 leashingEntitiesList = new class_2499();
            for (class_1297 class_12972 : this.getLeashingEntities()) {
                leashingEntitiesList.add((Object)class_2512.method_25929((UUID)class_12972.method_5667()));
            }
            compoundTag.method_10566("LeashingEntities", (class_2520)leashingEntitiesList);
            class_2499 leashedByEntitiesList = new class_2499();
            for (class_1297 class_12973 : this.getLeashedByEntities()) {
                leashedByEntitiesList.add((Object)class_2512.method_25929((UUID)class_12973.method_5667()));
            }
            compoundTag.method_10566("LeashedByEntities", (class_2520)leashedByEntitiesList);
        }
    }

    @Inject(at={@At(value="TAIL")}, method={"readAdditionalSaveData"})
    private void onReadAdditionalSaveData(class_2487 compoundTag, CallbackInfo callbackInfo) {
        if (!this.method_37908().method_8608()) {
            class_2499 leashingEntitiesList = compoundTag.method_10554("LeashingEntities", 11);
            for (class_2520 tag : leashingEntitiesList) {
                UUID uuid = class_2512.method_25930((class_2520)tag);
                ((Set)this.savedLeashState.first()).add(uuid);
            }
            class_2499 leashedByEntitiesList = compoundTag.method_10554("LeashedByEntities", 11);
            for (class_2520 tag : leashedByEntitiesList) {
                UUID uuid = class_2512.method_25930((class_2520)tag);
                ((Set)this.savedLeashState.second()).add(uuid);
            }
            if (!leashingEntitiesList.isEmpty() || !leashedByEntitiesList.isEmpty()) {
                this.needsLeashStateLoad = true;
            }
        }
    }

    @Inject(at={@At(value="TAIL")}, method={"tick"})
    private void onTick(CallbackInfo callbackInfo) {
        if (!this.method_37908().method_8608()) {
            if (this.needsLeashStateLoad) {
                ++this.leashStateLoadDelay;
                if (this.leashStateLoadDelay >= 20) {
                    class_1309 entity;
                    Set<class_1309> leashingEntities = this.getLeashingEntities();
                    Set<class_1309> leashedByEntities = this.getLeashedByEntities();
                    for (UUID uuid : (Set)this.savedLeashState.first()) {
                        entity = (class_1309)((class_3218)this.method_37908()).method_14190(uuid);
                        if (entity == null) continue;
                        leashingEntities.add(entity);
                    }
                    ((Set)this.savedLeashState.first()).clear();
                    for (UUID uuid : (Set)this.savedLeashState.second()) {
                        entity = (class_1309)((class_3218)this.method_37908()).method_14190(uuid);
                        if (entity == null) continue;
                        leashedByEntities.add(entity);
                    }
                    ((Set)this.savedLeashState.second()).clear();
                    this.sendLeashState();
                    this.needsLeashStateLoad = false;
                    this.leashStateLoadDelay = 0;
                }
            }
            int entitiesBefore = this.getLeashingEntities().size();
            this.getLeashingEntities().removeIf(leashedEntity -> {
                class_243 distance = this.method_19538().method_1020(leashedEntity.method_19538());
                double distanceSqr = distance.method_1027();
                if (distanceSqr > 14.0) {
                    leashedEntity.method_18799(leashedEntity.method_18798().method_1019(distance.method_1021(0.1).method_1031(0.0, 0.1, 0.0)));
                    if (distanceSqr > 28.0) {
                        ISilkLeashState leashedLeashState = (ISilkLeashState)leashedEntity;
                        leashedLeashState.getLeashedByEntities().remove(this);
                        leashedLeashState.sendLeashState();
                        return true;
                    }
                }
                return false;
            });
            int unleashedEntities = entitiesBefore - this.getLeashingEntities().size();
            if (unleashedEntities > 0) {
                class_1542 leadEntity = new class_1542(this.method_37908(), this.method_23317(), this.method_23318(), this.method_23321(), new class_1799((class_1935)CACItems.SILK_LEAD.get(), unleashedEntities));
                this.method_37908().method_8649((class_1297)leadEntity);
                this.sendLeashState();
            }
        }
    }

    @Inject(at={@At(value="INVOKE", target="net/minecraft/world/entity/LivingEntity.gameEvent(Lnet/minecraft/world/level/gameevent/GameEvent;)V", ordinal=0, shift=At.Shift.BY, by=1)}, method={"die"})
    private void onDie(class_1282 source, CallbackInfo callbackInfo) {
        int unleashedStates = 0;
        unleashedStates += Math.max(0, SilkLeashItem.updateLeashStates((class_1309)this, null) - 1);
        if ((unleashedStates += Math.max(0, SilkLeashItem.updateLeashStates(null, (class_1309)this) - 1)) > 0) {
            class_1542 leadEntity = new class_1542(this.method_37908(), this.method_23317(), this.method_23318(), this.method_23321(), new class_1799((class_1935)CACItems.SILK_LEAD.get(), unleashedStates));
            this.method_37908().method_8649((class_1297)leadEntity);
        }
    }

    @Redirect(at=@At(value="INVOKE", target="net/minecraft/world/entity/LivingEntity.isInWater()Z"), method={"travel(Lnet/minecraft/world/phys/Vec3;)V"})
    private boolean redirectIsInWater(class_1309 entity) {
        return this.method_5799() || this.method_36601().method_27852((class_2248)CACBlocks.SEA_BUNNY_SLIME_BLOCK.get());
    }

    @ModifyVariable(at=@At(value="LOAD"), method={"aiStep()V"}, ordinal=0)
    private boolean modifyWaterFlag(boolean flag) {
        return flag || this.method_36601().method_27852((class_2248)CACBlocks.SEA_BUNNY_SLIME_BLOCK.get());
    }

    @ModifyArg(method={"travel"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;moveRelative(FLnet/minecraft/world/phys/Vec3;)V", ordinal=0))
    private float modifySwimSpeed(float original) {
        return PearlNecklaceItem.getWearing(this).map(PearlNecklaceItem::getLevel).map(level -> Float.valueOf(original + (float)((double)original * ((double)level.intValue() * (Double)Services.CONFIGS.common().necklaceSwimSpeed.get())))).orElse(Float.valueOf(original)).floatValue();
    }

    @Override
    public void sendLeashState() {
        CACPacketHandler.SILK_LEASH_STATE.sendToTracking(this, new ClientboundSilkLeashStatePacket(new ClientboundSilkLeashStatePacket.LeashData(this.method_5628(), (IntList)new IntArrayList(this.getLeashingEntities().stream().mapToInt(class_1297::method_5628).toArray()), (IntList)new IntArrayList(this.getLeashedByEntities().stream().mapToInt(class_1297::method_5628).toArray()))));
    }

    @Override
    public Set<class_1309> getLeashingEntities() {
        return this.leashingEntities;
    }

    @Override
    public Set<class_1309> getLeashedByEntities() {
        return this.leashedByEntities;
    }
}

