/*
 * Decompiled with CFR 0.152.
 */
package net.arphex.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.lang.reflect.Method;
import net.arphex.entity.SpiderChaserHallucination3Entity;
import net.arphex.entity.model.SpiderChaserHallucination3Model;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.renderer.GeoEntityRenderer;

public class SpiderChaserHallucination3Renderer
extends GeoEntityRenderer<SpiderChaserHallucination3Entity> {
    private static Boolean isNyfsSpidersLoaded = null;
    private static Class<?> iClimberEntityClass;
    private static Class<?> orientationClass;

    public SpiderChaserHallucination3Renderer(EntityRendererProvider.Context renderManager) {
        super(renderManager, (GeoModel)new SpiderChaserHallucination3Model());
        this.f_114477_ = 0.5f;
        SpiderChaserHallucination3Renderer.checkNyfsSpidersIntegration();
    }

    private static void checkNyfsSpidersIntegration() {
        if (isNyfsSpidersLoaded == null) {
            try {
                iClimberEntityClass = Class.forName("com.nyfaria.nyfsspiders.common.entity.mob.IClimberEntity");
                orientationClass = Class.forName("com.nyfaria.nyfsspiders.common.entity.mob.Orientation");
                isNyfsSpidersLoaded = true;
            }
            catch (ClassNotFoundException e) {
                isNyfsSpidersLoaded = false;
            }
        }
    }

    public RenderType getRenderType(SpiderChaserHallucination3Entity animatable, ResourceLocation texture, MultiBufferSource bufferSource, float partialTick) {
        return RenderType.m_110473_((ResourceLocation)this.m_5478_((Entity)animatable));
    }

    public void preRender(PoseStack poseStack, SpiderChaserHallucination3Entity entity, BakedGeoModel model, MultiBufferSource bufferSource, VertexConsumer buffer, boolean isReRender, float partialTick, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        float scale;
        this.scaleHeight = scale = 1.6f;
        this.scaleWidth = scale;
        super.preRender(poseStack, (Entity)entity, model, bufferSource, buffer, isReRender, partialTick, packedLight, packedOverlay, red, green, blue, alpha);
    }

    public void applyRotations(SpiderChaserHallucination3Entity entity, PoseStack poseStack, float ageInTicks, float netHeadYaw, float partialTick) {
        if (!isNyfsSpidersLoaded.booleanValue() || !this.tryNyfsRotation(entity, poseStack, partialTick)) {
            super.applyRotations((Entity)entity, poseStack, ageInTicks, netHeadYaw, partialTick);
        }
    }

    private boolean tryNyfsRotation(SpiderChaserHallucination3Entity entity, PoseStack poseStack, float partialTick) {
        try {
            if (!iClimberEntityClass.isInstance((Object)entity)) {
                return false;
            }
            Object climberEntity = iClimberEntityClass.cast((Object)entity);
            Object orientationObj = this.getOrientationObject(climberEntity);
            if (orientationObj == null) {
                return false;
            }
            Vec3 normal = (Vec3)orientationClass.getField("normal").get(orientationObj);
            float yaw = Mth.m_14179_((float)partialTick, (float)entity.f_19859_, (float)entity.m_146908_());
            float halfHeight = entity.m_20206_() / 2.0f;
            boolean onCeiling = this.isOnCeiling(normal);
            float inverseScale = 0.625f;
            Quaternionf alignment = new Quaternionf().rotationTo((Vector3fc)new Vector3f(0.0f, 1.0f, 0.0f), (Vector3fc)new Vector3f((float)normal.f_82479_, (float)normal.f_82480_, (float)normal.f_82481_)).normalize();
            poseStack.m_252880_(0.0f, halfHeight * inverseScale, 0.0f);
            if (onCeiling) {
                Vector3f movementDir = new Vector3f(-Mth.m_14031_((float)(-yaw * ((float)Math.PI / 180))), 0.0f, Mth.m_14089_((float)(-yaw * ((float)Math.PI / 180))));
                movementDir.rotate((Quaternionfc)alignment);
                float surfaceYaw = (float)Math.atan2(movementDir.x, movementDir.z);
                poseStack.m_252781_(alignment);
                poseStack.m_252781_(new Quaternionf().rotateY(surfaceYaw));
            } else {
                poseStack.m_252781_(alignment);
                poseStack.m_252781_(new Quaternionf().rotateY((float)Math.PI / 180 * (-yaw + 180.0f)));
            }
            poseStack.m_252880_(0.0f, -halfHeight * inverseScale, 0.0f);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private boolean isOnCeiling(Vec3 normal) {
        return normal.f_82480_ < -0.9 && Math.abs(normal.f_82480_) > Math.max(Math.abs(normal.f_82479_), Math.abs(normal.f_82481_));
    }

    private Object getOrientationObject(Object climberEntity) throws Exception {
        Method method2;
        try {
            method2 = iClimberEntityClass.getMethod("getRenderOrientation", new Class[0]);
            Object result = method2.invoke(climberEntity, new Object[0]);
            if (result != null) {
                return result;
            }
        }
        catch (NoSuchMethodException method2) {
            // empty catch block
        }
        try {
            method2 = iClimberEntityClass.getMethod("getOrientation", new Class[0]);
            return method2.invoke(climberEntity, new Object[0]);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return null;
        }
    }

    protected float getDeathMaxRotation(SpiderChaserHallucination3Entity entityLivingBaseIn) {
        return 0.0f;
    }
}

