/*
 * Decompiled with CFR 0.152.
 */
package net.teamabyssalofficial.blocks;

import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.teamabyssalofficial.registry.EffectRegistry;
import net.teamabyssalofficial.registry.EntityRegistry;
import net.teamabyssalofficial.util.BlockSoundUtils;
import org.jetbrains.annotations.Nullable;

public class HiveBloom
extends Block
implements SimpleWaterloggedBlock {
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    private static final DirectionProperty FACING = HorizontalDirectionalBlock.f_54117_;
    private static final VoxelShape SHAPE_N = Stream.of(Block.m_49796_((double)-2.0, (double)0.1, (double)-2.0, (double)18.0, (double)5.1, (double)18.0), Block.m_49796_((double)8.191341716182546, (double)0.16193976625564271, (double)0.0, (double)24.19134171618255, (double)0.16193976625564271, (double)16.0), Block.m_49796_((double)-8.191341716182539, (double)0.16193976625564416, (double)0.0, (double)7.808658283817461, (double)0.16193976625564416, (double)16.0), Block.m_49796_((double)0.0, (double)0.1619397662556436, (double)8.191341716182546, (double)15.999999999999998, (double)0.1619397662556436, (double)24.19134171618255), Block.m_49796_((double)0.0, (double)0.16193976625564416, (double)-8.191341716182539, (double)16.0, (double)0.16193976625564416, (double)7.808658283817461)).reduce((v1, v2) -> Shapes.m_83113_((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.f_82695_)).get();
    private static final VoxelShape SHAPE_W = Stream.of(Block.m_49796_((double)-2.0, (double)0.1, (double)-2.0, (double)18.0, (double)5.1, (double)18.0), Block.m_49796_((double)0.0, (double)0.16193976625564271, (double)-8.19134171618255, (double)16.0, (double)0.16193976625564271, (double)7.808658283817454), Block.m_49796_((double)0.0, (double)0.16193976625564416, (double)8.191341716182539, (double)16.0, (double)0.16193976625564416, (double)24.19134171618254), Block.m_49796_((double)8.191341716182546, (double)0.1619397662556436, (double)1.7763568394002505E-15, (double)24.19134171618255, (double)0.1619397662556436, (double)16.0), Block.m_49796_((double)-8.191341716182539, (double)0.16193976625564416, (double)0.0, (double)7.808658283817461, (double)0.16193976625564416, (double)16.0)).reduce((v1, v2) -> Shapes.m_83113_((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.f_82695_)).get();
    private static final VoxelShape SHAPE_S = Stream.of(Block.m_49796_((double)-2.0, (double)0.1, (double)-2.0, (double)18.0, (double)5.1, (double)18.0), Block.m_49796_((double)-8.19134171618255, (double)0.16193976625564271, (double)0.0, (double)7.808658283817454, (double)0.16193976625564271, (double)16.0), Block.m_49796_((double)8.191341716182539, (double)0.16193976625564416, (double)0.0, (double)24.19134171618254, (double)0.16193976625564416, (double)16.0), Block.m_49796_((double)1.7763568394002505E-15, (double)0.1619397662556436, (double)-8.19134171618255, (double)16.0, (double)0.1619397662556436, (double)7.808658283817454), Block.m_49796_((double)0.0, (double)0.16193976625564416, (double)8.191341716182539, (double)16.0, (double)0.16193976625564416, (double)24.19134171618254)).reduce((v1, v2) -> Shapes.m_83113_((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.f_82695_)).get();
    private static final VoxelShape SHAPE_E = Stream.of(Block.m_49796_((double)-2.0, (double)0.1, (double)-2.0, (double)18.0, (double)5.1, (double)18.0), Block.m_49796_((double)0.0, (double)0.16193976625564271, (double)8.191341716182546, (double)16.0, (double)0.16193976625564271, (double)24.19134171618255), Block.m_49796_((double)0.0, (double)0.16193976625564416, (double)-8.191341716182539, (double)16.0, (double)0.16193976625564416, (double)7.808658283817461), Block.m_49796_((double)-8.19134171618255, (double)0.1619397662556436, (double)0.0, (double)7.808658283817454, (double)0.1619397662556436, (double)15.999999999999998), Block.m_49796_((double)8.191341716182539, (double)0.16193976625564416, (double)0.0, (double)24.19134171618254, (double)0.16193976625564416, (double)16.0)).reduce((v1, v2) -> Shapes.m_83113_((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.f_82695_)).get();

    public HiveBloom(BlockBehaviour.Properties pProperties) {
        super(pProperties.m_60918_(BlockSoundUtils.HIVE_BLOCK_SOUNDS).m_60910_().m_60955_().m_60966_().m_278166_(PushReaction.DESTROY));
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.FALSE));
    }

    public BlockState m_7417_(BlockState value, Direction pDirection, BlockState blockState, LevelAccessor aVoid, BlockPos blockPos, BlockPos blockPos1) {
        if (pDirection.m_122424_() == value.m_61143_((Property)FACING) && !value.m_60710_((LevelReader)aVoid, blockPos)) {
            return Blocks.f_50016_.m_49966_();
        }
        if (((Boolean)value.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            aVoid.m_186469_(blockPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)aVoid));
        }
        return super.m_7417_(value, pDirection, blockState, aVoid, blockPos, blockPos1);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter p_54373_, BlockPos p_54374_, CollisionContext p_54375_) {
        switch ((Direction)state.m_61143_((Property)FACING)) {
            case NORTH: {
                return SHAPE_N;
            }
            case SOUTH: {
                return SHAPE_S;
            }
            case WEST: {
                return SHAPE_W;
            }
        }
        return SHAPE_E;
    }

    public RenderShape m_7514_(BlockState pState) {
        return RenderShape.MODEL;
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext clickedFace) {
        return (BlockState)super.m_5573_(clickedFace).m_61124_((Property)FACING, (Comparable)clickedFace.m_8125_());
    }

    public BlockState m_6843_(BlockState pState, Rotation rotation) {
        return (BlockState)pState.m_61124_((Property)FACING, (Comparable)rotation.m_55954_((Direction)pState.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState pState, Mirror pMirror) {
        return pState.m_60717_(pMirror.m_54846_((Direction)pState.m_61143_((Property)FACING)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.m_61104_(new Property[]{FACING, WATERLOGGED});
    }

    public FluidState m_5888_(BlockState pState) {
        return (Boolean)pState.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(pState);
    }

    public void m_141947_(Level pLevel, BlockPos pPos, BlockState pState, Entity pEntity) {
        LivingEntity livingEntity;
        if (!EntityRegistry.FLOOD_FORMS.contains(pEntity) && pEntity instanceof LivingEntity && !(livingEntity = (LivingEntity)pEntity).m_21023_((MobEffect)EffectRegistry.PLAGUE_OF_THE_FLOOD.get())) {
            livingEntity.m_147207_(new MobEffectInstance((MobEffect)EffectRegistry.PLAGUE_OF_THE_FLOOD.get(), 1200, 0), (Entity)livingEntity);
        }
        super.m_141947_(pLevel, pPos, pState, pEntity);
    }

    public boolean isFlammable(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
        return true;
    }

    public int getFlammability(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
        return 15;
    }

    public int getFireSpreadSpeed(BlockState state, BlockGetter world, BlockPos pos, Direction face) {
        return 10;
    }
}

