/*
 * Decompiled with CFR 0.152.
 */
package net.teamabyssalofficial.config;

import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import com.electronwill.nightconfig.core.io.WritingMode;
import com.google.common.collect.Lists;
import java.io.File;
import java.util.List;
import net.minecraftforge.common.ForgeConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

public class DawnOfTheFloodConfig {
    public static final Server SERVER;
    public static final ForgeConfigSpec SERVER_SPEC;
    public static final DataGen DATAGEN;
    public static final ForgeConfigSpec DATAGEN_SPEC;

    public static void loadConfig(ForgeConfigSpec config, String path) {
        CommentedFileConfig file = (CommentedFileConfig)CommentedFileConfig.builder((File)new File(path)).sync().autosave().writingMode(WritingMode.REPLACE).build();
        file.load();
        config.setConfig((CommentedConfig)file);
    }

    static {
        Pair commonSpecPair = new ForgeConfigSpec.Builder().configure(Server::new);
        SERVER = (Server)commonSpecPair.getLeft();
        SERVER_SPEC = (ForgeConfigSpec)commonSpecPair.getRight();
        Pair commonPair = new ForgeConfigSpec.Builder().configure(DataGen::new);
        DATAGEN = (DataGen)commonPair.getLeft();
        DATAGEN_SPEC = (ForgeConfigSpec)commonPair.getRight();
    }

    public static class Server {
        public final ForgeConfigSpec.ConfigValue<Boolean> enableGlassBreaking;
        public final ForgeConfigSpec.ConfigValue<Boolean> fragileBlockDrops;
        public final ForgeConfigSpec.ConfigValue<Double> fragileBaseBreakChance;
        public final ForgeConfigSpec.ConfigValue<Double> gun_bullet_knockback;
        public final ForgeConfigSpec.ConfigValue<Boolean> gun_bullet_crit;
        public final ForgeConfigSpec.ConfigValue<Boolean> gun_shot_screen_shake;
        public final ForgeConfigSpec.ConfigValue<Double> gun_bullet_crit_chance;
        public final ForgeConfigSpec.ConfigValue<Double> gun_shot_sound_distance;
        public final ForgeConfigSpec.ConfigValue<Double> magnum_bullet_damage;
        public final ForgeConfigSpec.ConfigValue<Double> mk50_sidekick_bullet_damage;
        public final ForgeConfigSpec.ConfigValue<Double> needler_bullet_damage;
        public final ForgeConfigSpec.ConfigValue<Double> magnum_recoil;
        public final ForgeConfigSpec.ConfigValue<Double> mk50_sidekick_recoil;
        public final ForgeConfigSpec.ConfigValue<Double> needler_recoil;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> blacklist;
        public final ForgeConfigSpec.ConfigValue<Integer> mob_cap;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> dimension_parameters;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> spawns;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> flood_sickness;
        public final ForgeConfigSpec.ConfigValue<Integer> mobSpawnAttempts;
        public final ForgeConfigSpec.ConfigValue<Integer> additionalHordeMobs;
        public final ForgeConfigSpec.ConfigValue<Integer> ticksBeforeHordeSpawning;
        public final ForgeConfigSpec.ConfigValue<Integer> additionalRandomizedTicks;
        public final ForgeConfigSpec.ConfigValue<Boolean> enable_horde;
        public final ForgeConfigSpec.ConfigValue<Double> base_form_health;
        public final ForgeConfigSpec.ConfigValue<Double> base_form_damage;
        public final ForgeConfigSpec.ConfigValue<Double> sangheili_form_health;
        public final ForgeConfigSpec.ConfigValue<Double> sangheili_form_damage;
        public final ForgeConfigSpec.ConfigValue<Double> carrier_form_health;
        public final ForgeConfigSpec.ConfigValue<Double> carrier_form_damage;
        public final ForgeConfigSpec.ConfigValue<Double> carrier_form_explosion_damage;
        public final ForgeConfigSpec.ConfigValue<Boolean> base_form_age;
        public final ForgeConfigSpec.ConfigValue<Integer> base_to_carrier_form_age;
        public final ForgeConfigSpec.ConfigValue<Double> pod_infector_health;
        public final ForgeConfigSpec.ConfigValue<Double> pod_infector_damage;
        public final ForgeConfigSpec.ConfigValue<Double> pod_infector_extra_explosion_damage;
        public final ForgeConfigSpec.ConfigValue<Integer> pod_infector_ticks_before_exploding;
        public final ForgeConfigSpec.ConfigValue<Boolean> pod_form_regeneration;
        public final ForgeConfigSpec.ConfigValue<Boolean> pod_infector_screen_shake;
        public final ForgeConfigSpec.ConfigValue<Boolean> base_form_regeneration;
        public final ForgeConfigSpec.ConfigValue<Boolean> carrier_form_regeneration;
        public final ForgeConfigSpec.ConfigValue<Boolean> carrier_form_aggro_despawn;
        public final ForgeConfigSpec.ConfigValue<Integer> carrier_form_aggro_ticks;
        public final ForgeConfigSpec.ConfigValue<Boolean> carrier_form_screen_shake;
        public final ForgeConfigSpec.ConfigValue<Boolean> sangheili_form_regeneration;
        public final ForgeConfigSpec.ConfigValue<Boolean> base_form_climb;
        public final ForgeConfigSpec.ConfigValue<Boolean> base_form_screen_shake;
        public final ForgeConfigSpec.ConfigValue<Boolean> sangheili_form_climb;
        public final ForgeConfigSpec.ConfigValue<Boolean> player_form_breaks_blocks;
        public final ForgeConfigSpec.ConfigValue<Boolean> sangheili_form_breaks_blocks;
        public final ForgeConfigSpec.ConfigValue<Boolean> sangheili_form_tremble_walk;
        public final ForgeConfigSpec.ConfigValue<Boolean> sangheili_form_use_guns;
        public final ForgeConfigSpec.ConfigValue<Boolean> sangheili_form_use_energy_swords;
        public final ForgeConfigSpec.ConfigValue<Boolean> sangheili_form_aggro_despawn;
        public final ForgeConfigSpec.ConfigValue<Integer> sangheili_form_aggro_ticks;
        public final ForgeConfigSpec.ConfigValue<Integer> buff_potion_meter;
        public final ForgeConfigSpec.ConfigValue<Boolean> use_potions;
        public final ForgeConfigSpec.ConfigValue<Boolean> use_crossbow;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> buffing_potions;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> human_transformations;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> villager_transformations;
        public final ForgeConfigSpec.ConfigValue<Boolean> human_mutation;
        public final ForgeConfigSpec.ConfigValue<Boolean> villager_mutation;
        public final ForgeConfigSpec.ConfigValue<Boolean> player_mutation;
        public final ForgeConfigSpec.ConfigValue<Boolean> illager_human_alliance;
        public final ForgeConfigSpec.ConfigValue<Integer> illager_human_alliance_wave;
        public final ForgeConfigSpec.ConfigValue<Boolean> corpse_head_shake_animation;
        public final ForgeConfigSpec.ConfigValue<Boolean> corpse_spawn;
        public final ForgeConfigSpec.ConfigValue<Boolean> corpse_screen_shake_ground;
        public final ForgeConfigSpec.ConfigValue<Integer> energy_sword_durability;
        public final ForgeConfigSpec.ConfigValue<Integer> energy_sword_damage;

        public Server(ForgeConfigSpec.Builder builder) {
            builder.push("Gun Settings");
            this.enableGlassBreaking = builder.comment("Default true").define("If enabled, allows gAuns to shoot out glass and other fragile objects", true);
            this.fragileBlockDrops = builder.comment("Default true").define("If enabled, fragile blocks will drop their loot when broken", true);
            this.fragileBaseBreakChance = builder.comment("Default 1.0").defineInRange("The base chance that a fragile block is broken when impacted by a bullet, the hardness of a block will scale this value, the harder the block, the lower the final calculated chance will be", 1.0, 0.0, 1.0);
            this.gun_bullet_knockback = builder.comment("Default 0.15").defineInRange("Sets the knockback that an entity will take after being hit by a bullet", 0.15, 0.01, Double.MAX_VALUE);
            this.gun_bullet_crit = builder.comment("Default true").define("If true, bullets should cause crit hits with a chance", true);
            this.gun_shot_screen_shake = builder.comment("Default true").define("If true, guns should cause screen shake effects to the player's camera when he is shooting", true);
            this.gun_bullet_crit_chance = builder.comment("Default 0.05").defineInRange("Sets the chance of the bullet causing a crit hit, doubling the damage of the bullet, 0 05 means 5 percent chance", 0.05, 0.01, Double.MAX_VALUE);
            this.gun_shot_sound_distance = builder.comment("Default 70").defineInRange("Sets the distance from where a gun shot can still be heard, works best with sound physics remastered mod", 70.0, 15.0, Double.MAX_VALUE);
            this.magnum_bullet_damage = builder.comment("Default 12.2").defineInRange("Sets the damage of the magnum's bullet", 12.2, 3.5, Double.MAX_VALUE);
            this.mk50_sidekick_bullet_damage = builder.comment("Default 12.6").defineInRange("Sets the damage of the sidekick's bullet", 12.6, 3.8, Double.MAX_VALUE);
            this.needler_bullet_damage = builder.comment("Default 13.5").defineInRange("Sets the damage of the needler's bullet", 13.5, 5.0, Double.MAX_VALUE);
            this.magnum_recoil = builder.comment("Default 1.0").defineInRange("Sets the recoil of the magnum", 1.0, 0.0, Double.MAX_VALUE);
            this.mk50_sidekick_recoil = builder.comment("Default 1.0").defineInRange("Sets the recoil of the magnum", 1.0, 0.0, Double.MAX_VALUE);
            this.needler_recoil = builder.comment("Default 1.35").defineInRange("Sets the recoil of the magnum", 1.35, 0.0, Double.MAX_VALUE);
            builder.pop();
            builder.push("Mob Stuff");
            builder.push("Illager / Raider");
            this.illager_human_alliance = builder.comment("Default true").define("Should Illager Forms STOP attacking iron golems or players or villagers when they reach a certain stage due to the potential danger that the flood represents?", true);
            this.illager_human_alliance_wave = builder.comment("Default 3").define("The wave when the raider alliance will start their common enemy project, stopping all attacks pointed at the human side ", (Object)3);
            builder.pop();
            builder.push("Base Forms ( Human / Villager / Player )");
            this.base_form_health = builder.comment("Default 25").defineInRange("Sets Base Form's Max health", 25.0, 12.0, Double.MAX_VALUE);
            this.base_form_damage = builder.comment("Default 7").defineInRange("Sets Base Form's Damage", 7.0, 4.0, Double.MAX_VALUE);
            this.base_form_regeneration = builder.comment("Default true").define("Should Base Forms regenerate?", true);
            this.base_form_climb = builder.comment("Default true").define("Should Base Forms climb?", true);
            this.base_form_screen_shake = builder.comment("Default true").define("Should Base Forms cause a screen shake when roaring?", true);
            this.player_form_breaks_blocks = builder.comment("Default true").define("Should PLAYER Forms break blocks?", true);
            this.use_crossbow = builder.comment("Default true").define("Should Player Forms use Crossbows?", true);
            this.buffing_potions = builder.defineList("Potions that are used by the player form to buff the flood forms , NOT effects", (List)Lists.newArrayList((Object[])new String[]{"minecraft:fire_resistance", "minecraft:regeneration", "minecraft:strength"}), o -> o instanceof String);
            this.use_potions = builder.comment("Default true").define("Should Player Forms use Potions?", true);
            this.buff_potion_meter = builder.comment("Default 100").defineInRange("Sets the time before throwing a potion when buffing", 100, 1, Integer.MAX_VALUE);
            builder.pop();
            builder.push("Sangheili Forms");
            this.sangheili_form_health = builder.comment("Default 65").defineInRange("Sets Sangheili Form's Max health", 65.0, 20.0, Double.MAX_VALUE);
            this.sangheili_form_damage = builder.comment("Default 15").defineInRange("Sets Sangheili Form's Damage", 15.0, 5.0, Double.MAX_VALUE);
            this.sangheili_form_regeneration = builder.comment("Default true").define("Should Sangheili Forms regenerate?", true);
            this.sangheili_form_climb = builder.comment("Default true").define("Should Sangheili Forms climb?", true);
            this.sangheili_form_breaks_blocks = builder.comment("Default true").define("Should Sangheili Forms break blocks?", true);
            this.sangheili_form_tremble_walk = builder.comment("Default true").define("Should Sangheili Forms make your screen tremble when they walk?", true);
            this.sangheili_form_use_guns = builder.comment("Default true").define("Should Sangheili Forms use guns?", true);
            this.sangheili_form_use_energy_swords = builder.comment("Default true").define("Should Sangheili Forms use Energy Swords?", true);
            this.sangheili_form_aggro_despawn = builder.comment("Default true").define("Should Sangheili Forms NOT despawn after they have seen a target for too long?", true);
            this.sangheili_form_aggro_ticks = builder.comment("Default 7500").define("Sets Sangheili's time before it should STOP despawning when it has seen a target for too long", (Object)7500);
            builder.pop();
            builder.push("Carrier Forms");
            this.carrier_form_health = builder.comment("Default 35").defineInRange("Sets Carrier Form's Max health", 35.0, 10.0, Double.MAX_VALUE);
            this.carrier_form_damage = builder.comment("Default 0").defineInRange("Sets Carrier Form's Damage", 0.0, 0.0, Double.MAX_VALUE);
            this.carrier_form_explosion_damage = builder.comment("Default 2.75").defineInRange("Sets the damage of the explosion of the carrier form", 2.75, 0.0, Double.MAX_VALUE);
            this.carrier_form_regeneration = builder.comment("Default true").define("Should Carrier Forms regenerate?", true);
            this.base_form_age = builder.comment("Default true").define("Should Base Forms age and turn into carrier forms?", true);
            this.base_to_carrier_form_age = builder.comment("Default 20000").define("Time in ticks until any base form ages and turns into a carrier form", (Object)20000);
            this.carrier_form_aggro_despawn = builder.comment("Default true").define("Should Carrier Forms NOT despawn after they have seen a target for too long?", true);
            this.carrier_form_aggro_ticks = builder.comment("Default 9000").define("Sets Carrier's time before it should STOP despawning when it has seen a target for too long", (Object)9000);
            this.carrier_form_screen_shake = builder.comment("Default true").define("Should Carrier Forms cause a screen shake when exploding?", true);
            builder.pop();
            builder.push("Pod Infector");
            this.pod_infector_health = builder.comment("Default 7").defineInRange("Sets Pod Infector's Max health", 7.0, 3.0, Double.MAX_VALUE);
            this.pod_infector_damage = builder.comment("Default 5").defineInRange("Sets Pod Infector's Damage", 5.0, 2.0, Double.MAX_VALUE);
            this.pod_infector_extra_explosion_damage = builder.comment("Default 1.25").defineInRange("Sets Pod Infector's Explosion's Damage", 1.25, 0.0, Double.MAX_VALUE);
            this.pod_infector_ticks_before_exploding = builder.comment("Default 50").define("MobCap", (Object)50);
            this.pod_form_regeneration = builder.comment("Default true").define("Should Pod Infectors regenerate?", true);
            this.pod_infector_screen_shake = builder.comment("Default true").define("Should Pod Infectors cause a screen shake when exploding?", true);
            builder.pop();
            builder.push("Transformations");
            this.player_mutation = builder.comment("Default true").define("Should Pod Infectors transform players?", true);
            this.human_mutation = builder.comment("Default true").define("Should Pod Infectors transform zombies?", true);
            this.villager_mutation = builder.comment("Default true").define("Should Pod Infectors transform villagers?", true);
            this.human_transformations = builder.defineList("Mobs that can turn into Human Forms", (List)Lists.newArrayList((Object[])new String[]{"minecraft:zombie"}), o -> o instanceof String);
            this.villager_transformations = builder.defineList("Mobs that can turn into Villager Forms", (List)Lists.newArrayList((Object[])new String[]{"minecraft:villager", "rotted:farmer", "guardvillagers:guard"}), o -> o instanceof String);
            builder.pop();
            builder.push("Bodies / Corpses");
            this.corpse_spawn = builder.comment("Default true").define("Should corpses of the base forms have a chance to spawn after they get defeated?", true);
            this.corpse_head_shake_animation = builder.comment("Default true").define("Should corpses of the base forms have a shake animation applied to their head?", true);
            this.corpse_screen_shake_ground = builder.comment("Default true").define("Should corpses make your screen shake when falling to the ground?", true);
            builder.pop();
            builder.push("Spawns");
            this.mob_cap = builder.comment("Default 60").define("MobCap", (Object)60);
            this.dimension_parameters = builder.comment("Default minecraft:is_overworld").defineList("Dictates in what biome the flood forms spawn", (List)Lists.newArrayList((Object[])new String[]{"minecraft:is_overworld"}), o -> o instanceof String);
            this.spawns = builder.defineList("mob|weight|minimum|maximum", (List)Lists.newArrayList((Object[])new String[]{"dotf:pod_infector|7|1|3", "dotf:human_form|15|1|2", "dotf:player_form|11|1|1", "dotf:villager_form|13|1|2", "dotf:carrier_form|11|1|2|", "dotf:sangheili_form|7|1|1|"}), o -> o instanceof String);
            builder.pop();
            builder.push("Horde");
            this.enable_horde = builder.comment("Default true").define("Should flood base forms hordes spawn?", true);
            this.mobSpawnAttempts = builder.comment("Default 10").define("Number of Mobs Spawning in a Horde", (Object)10);
            this.additionalHordeMobs = builder.comment("Default 3").define("Number of mobs that will be added to the horde each wave", (Object)3);
            this.ticksBeforeHordeSpawning = builder.comment("Default 2500").define("Ticks before the horde spawning", (Object)2500);
            this.additionalRandomizedTicks = builder.comment("Default 500").define("Additional horde ticks", (Object)500);
            builder.pop();
            builder.push("Effects");
            this.flood_sickness = builder.defineList("Mobs that are immune to the flood virus", (List)Lists.newArrayList((Object[])new String[]{"minecraft:ghast", "minecraft:magma_cube", "minecraft:phantom", "minecraft:snow_golem", "minecraft:stray", "minecraft:skeleton"}), o -> o instanceof String);
            builder.pop();
            builder.push("Targeting Tasks");
            this.blacklist = builder.defineList("Mobs Not Targeted", (List)Lists.newArrayList((Object[])new String[]{"minecraft:squid", "minecraft:bat", "minecraft:armor_stand", "minecraft:creeper", "minecraft:ghast", "minecraft:falling_block", "minecraft:abstract_arrow", "minecraft:arrow", "minecraft:spectral_arrow", "minecraft:trident"}), o -> o instanceof String);
            builder.pop();
            builder.push("Items & Weapons");
            builder.push("Energy Sword");
            this.energy_sword_durability = builder.comment("Default 5000").define("Durability", (Object)5000);
            this.energy_sword_damage = builder.comment("Default 11").defineInRange("Damage", 11, 3, Integer.MAX_VALUE);
            builder.pop();
        }
    }

    public static class DataGen {
        public final ForgeConfigSpec.ConfigValue<Integer> wave1_points;
        public final ForgeConfigSpec.ConfigValue<Integer> wave2_points;
        public final ForgeConfigSpec.ConfigValue<Integer> wave3_points;
        public final ForgeConfigSpec.ConfigValue<Integer> wave4_points;
        public final ForgeConfigSpec.ConfigValue<Integer> wave5_points;
        public final ForgeConfigSpec.ConfigValue<Integer> devices_points;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> name;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> player_form_items;

        public DataGen(ForgeConfigSpec.Builder builder) {
            builder.push("waves");
            this.wave1_points = builder.comment("Default 2500").define("Sets points required to enter wave 1", (Object)2500);
            this.wave2_points = builder.comment("Default 10000").define("Sets points required to enter wave 2", (Object)10000);
            this.wave3_points = builder.comment("Default 100000").define("Sets points required to enter wave 3", (Object)100000);
            this.wave4_points = builder.comment("Default 1000000").define("Sets points required to enter wave 4", (Object)1000000);
            this.wave5_points = builder.comment("Default 2500000").define("Sets points required to enter wave 5", (Object)2500000);
            builder.pop();
            builder.push("Main Hand Items for the Player Form");
            this.player_form_items = builder.defineList("Main Hand Slot for the Player Form", (List)Lists.newArrayList((Object[])new String[]{"minecraft:iron_pickaxe|35", "minecraft:stone_pickaxe|25", "minecraft:golden_pickaxe|15"}), o -> o instanceof String);
            builder.pop();
            builder.push("Device Points");
            this.devices_points = builder.comment("Default 1000").define("Sets points that will be added / subtracted by the devices", (Object)1000);
            builder.pop();
            builder.push("Player Form Names");
            this.name = builder.defineList("Player Form Possible Names", (List)Lists.newArrayList((Object[])new String[]{"ASEStefan", "Nightfox", "Kronoz", "DAKOTA", "JC", "Korben", "Beta", "Renovated", "TeamAbyssal", "XEliteXCraftersX", "TqLxQuanZ", "Ian", "Andy", "Spaghetti", "AnnoyingSrpFan123", "YOASOBI", "Quattro", "NotMilkyCat", "Daralexen", "Chickon98", "ChingChilly", "wRatte", "ivan", "PHO3N1X", "Iwasawa Masami", "kevin", "WinVic", "Wikipedia", "Mr.Lambert", "Dr.Pilot", "Harbinger", "LukeUCraft", "purpleskittle", "Kanade Tachibana", "Adrian", "Isha21", "WitherBean", "Dr.Korpus", "Dr.Simon", "Dr.Robert", "MarioThePlumber", "Lelouch VI Britannia", "Light Yagami", "Mutationcraft", "yorkmousemodz", "Mattias", "entiral", "Chad", "DopeMan", "FlipperIvy", "MR138", "Sen", "SangheiliMan", "Hinata Hideki", "Otonashi Yuzuru", "Yui", "Nakamura Yuri", "existereoracle", "LiSA", "Evan Wingerter", "TechnoTheProtogen", "ScouT2Illustrates", "Jamsteo", "Joe Goldberg", "boodahbob", "Noxus", "FLOW", "C.C", "Kururugi Suzaku", "Tomioka Giyuu", "Guts", "Griffith", "C++", "C#", "Java", "JavaScript", "troubled boys", "Dr.Cal", "Covenant", "Forerunner", "Keyes", "CortanaDude", "Spartan", "Elite", "chadtheradlad", "Tomoya Okazaki", "Masterchief", "John"}), o -> o instanceof String);
            builder.pop();
        }
    }
}

